/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.airport.data.property.CloudQueryProperties;
import com.geoway.fczx.airport.data.query.AddQueryInfo;
import com.geoway.fczx.airport.data.query.AddResultInfo;
import com.geoway.fczx.airport.service.CloudQueryService;
import com.geoway.fczx.airport.thirdapi.cloud.CloudRestService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e09\u65b9\u670d\u52a1\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/cloudQuery/v3"})
public class CloudQueryController {
    @Resource
    private CloudRestService cloudRestService;
    @Resource
    private CloudQueryService cloudQueryService;

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u9009\u9879", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=101)
    @GetMapping(value={"/{workspaceId}/getQueryItems"})
    public ResponseEntity<BaseResponse> getQueryItems(@PathVariable String workspaceId) {
        OpRes<JSONObject> res = this.cloudRestService.getQueryItems(this.cloudQueryService.obtainProperties(workspaceId));
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u63d0\u4ea4\u4e91\u67e5\u8be2\u8bf7\u6c42", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=102)
    @PostMapping(value={"/{workspaceId}/add"})
    public ResponseEntity<BaseResponse> addQuery(@PathVariable String workspaceId, @RequestBody AddQueryInfo param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getParam(), param.getParam().getRange()})) {
            boolean flag;
            param.setWorkspaceId(workspaceId);
            CloudQueryProperties config = this.cloudQueryService.obtainProperties(workspaceId);
            OpRes<JSONObject> data = this.cloudRestService.add(config, param);
            if (!data.isOpRes()) {
                return BaseResponse.error((String)data.getErrorDesc());
            }
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getBizType(), param.getBizId()}) && !(flag = this.cloudQueryService.addQueryBizLogic(param, ((JSONObject)data.getData()).getJSONObject((Object)"data")))) {
                return BaseResponse.error((String)"\u63d0\u4ea4\u4e91\u67e5\u8be2\u8bf7\u6c42\u5931\u8d25");
            }
            return ObjectResponse.ok((Object)data.getData());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u72b6\u6001", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=103)
    @GetMapping(value={"/{workspaceId}/getRecordState"})
    public ResponseEntity<BaseResponse> getRecordState(@PathVariable String workspaceId, @RequestParam String requestId, String analyzeType) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, requestId})) {
            CloudQueryProperties config = this.cloudQueryService.obtainProperties(workspaceId);
            OpRes<JSONObject> data = this.cloudRestService.getRecordStateByRequestId(config, requestId, ObjectUtil.isNotEmpty((Object)analyzeType) ? analyzeType : "0");
            if (!data.isOpRes()) {
                return BaseResponse.error((String)data.getErrorDesc());
            }
            return ObjectResponse.ok((Object)data.getData());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=104)
    @GetMapping(value={"/{workspaceId}/getRecordById"})
    public ResponseEntity<BaseResponse> getRecordById(@PathVariable String workspaceId, @RequestParam String id) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, id})) {
            CloudQueryProperties config = this.cloudQueryService.obtainProperties(workspaceId);
            OpRes<JSONObject> data = this.cloudRestService.getRecordById(config, id);
            if (!data.isOpRes()) {
                return BaseResponse.error((String)data.getErrorDesc());
            }
            return ObjectResponse.ok((Object)data.getData());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u8be6\u60c5", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=105)
    @GetMapping(value={"/{workspaceId}/getResultJSON"})
    public ResponseEntity<BaseResponse> getResultJSON(@PathVariable String workspaceId, @RequestParam String requestId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, requestId})) {
            CloudQueryProperties config = this.cloudQueryService.obtainProperties(workspaceId);
            OpRes<JSONObject> data = this.cloudRestService.getResultJSON(config, requestId);
            if (!data.isOpRes()) {
                return BaseResponse.error((String)data.getErrorDesc());
            }
            return ObjectResponse.ok((Object)data.getData());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u9875\u9762", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=106)
    @PostMapping(value={"/{workspaceId}/addResult"})
    public ResponseEntity<BaseResponse> addResult(@PathVariable String workspaceId, @RequestBody AddResultInfo param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, param})) {
            CloudQueryProperties config = this.cloudQueryService.obtainProperties(workspaceId);
            OpRes<JSONObject> data = this.cloudRestService.addResult(config, param);
            if (!data.isOpRes()) {
                return BaseResponse.error((String)data.getErrorDesc());
            }
            return ObjectResponse.ok((Object)data.getData());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u7ed3\u679c", notes="<h2>\u3010\u8c03\u67e5\u4e91\u7cfb\u7edf\u3011</h2>")
    @ApiOperationSupport(order=106)
    @GetMapping(value={"/{workspaceId}/getResult"})
    public ResponseEntity<BaseResponse> getResult(@PathVariable String workspaceId, @RequestParam String requestId, @RequestParam String id, String analyzeType) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{workspaceId, requestId, id})) {
            CloudQueryProperties config = this.cloudQueryService.obtainProperties(workspaceId);
            OpRes<JSONObject> data = this.cloudQueryService.getResult(config, requestId, id, analyzeType);
            if (!data.isOpRes()) {
                return BaseResponse.error((String)data.getErrorDesc());
            }
            return ObjectResponse.ok((Object)data.getData());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }
}

