/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.controller;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.airport.data.StandardExport;
import com.geoway.fczx.airport.data.response.HttpResponse;
import com.geoway.fczx.airport.entity.DbExport;
import com.geoway.fczx.airport.service.StandardDbExportService;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6210\u679c\u4e0b\u8f7d\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/dbExport"})
public class DbExportController {
    @Resource
    private StandardDbExportService exportService;

    @Operation(summary="\u83b7\u53d6\u6210\u679c\u5217\u8868")
    @ApiImplicitParam(name="namespaceId", value="\u4efb\u52a1\u6807\u8bc6", required=true)
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/list"})
    public HttpResponse<List<DbExport>> dbExportList(String namespaceId, Integer type) {
        if (ObjectUtil.isEmpty((Object)type)) {
            type = 0;
        }
        List<DbExport> list = this.exportService.dbExportList(namespaceId, type);
        return HttpResponse.success(list);
    }

    @Operation(summary="\u751f\u6210DB\u6210\u679c\u5305")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/generate"})
    public HttpResponse<String> dbExportGenerate(@RequestBody StandardExport param) {
        String dbId = this.exportService.dbExportGenerate(param);
        return HttpResponse.success(dbId);
    }

    @Operation(summary="\u5220\u9664DB\u6210\u679c\u5305")
    @ApiOperationSupport(order=3)
    @DeleteMapping(value={"/remove/{id}"})
    public HttpResponse<String> dbExportRemove(@PathVariable(value="id") String id) {
        String error = this.exportService.dbExportRemove(id);
        return error != null ? HttpResponse.error(error) : HttpResponse.success("\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u5220\u9664DB\u6210\u679c\u5305")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/remove/{id}/delete"})
    public HttpResponse<String> dbExportRemove2(@PathVariable(value="id") String id) {
        String error = this.exportService.dbExportRemove(id);
        return error != null ? HttpResponse.error(error) : HttpResponse.success("\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u4e0b\u8f7dDB\u6210\u679c\u5305", hidden=true)
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/download"})
    public void dbExportDownload(String id, HttpServletResponse response) {
        OpRes<String> url = this.exportService.dbExportDownload(id);
        try {
            if (url.isOpRes()) {
                response.sendRedirect((String)url.getData());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="\u662f\u5426\u63a8\u9001\u6210\u679c")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/pushCgk"})
    public HttpResponse<Object> pushCgkConfig(Boolean detail) {
        Object data = this.exportService.pushCgkConfig(detail);
        return HttpResponse.success(data);
    }

    @Operation(summary="\u63a8\u9001\u81f3\u6210\u679c\u5e93")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/pushCgk"})
    public HttpResponse<String> pushCgk(@RequestParam String jobId) {
        OpRes<String> data = this.exportService.pushCgk(jobId);
        return !data.isOpRes() ? HttpResponse.error(data.getErrorDesc()) : HttpResponse.success((String)data.getData());
    }
}

