/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.data.query;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.airport.data.property.CloudQueryProperties;
import com.geoway.fczx.airport.data.query.QueryParam;
import com.geoway.fczx.airport.util.MeasureUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@ApiModel(value="\u4e91\u67e5\u8be2\u63d0\u4ea4\u5bf9\u8c61")
public class AddQueryInfo {
    @ApiModelProperty(value="\u5fc5\u586b json\u683c\u5f0f", required=true)
    private QueryParam param;
    @ApiModelProperty(value="\u7528\u6237\u4fe1\u606f", required=true)
    private String userId = "drone-map";
    @ApiModelProperty(value="\u8bf7\u6c42id")
    private String requestId;
    @ApiModelProperty(value="\u540d\u79f0")
    private String name;
    @ApiModelProperty(value="\u5206\u7ec4\u4fe1\u606f")
    private String tag;
    @ApiModelProperty(value="0\u4e3a\u4e91\u67e5\u8be2 \u6216 1\u4e3a\u4e91\u5206\u6790")
    private String analyzeType;
    @ApiModelProperty(value="\u4e1a\u52a1\u6807\u8bc6", required=true)
    private String bizId;
    @ApiModelProperty(value="\u4e1a\u52a1\u7c7b\u578b\uff1a1-\u7ebf\u7d22 2-\u6807\u6ce8", required=true)
    private Integer bizType;
    @ApiModelProperty(value="work\u6807\u8bc6", hidden=true)
    private String workspaceId;

    public MultiValueMap<String, Object> transferObject(CloudQueryProperties config) {
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.add((Object)"userId", (Object)this.userId);
        if (ObjectUtil.isEmpty((Object)this.param.getOptions())) {
            this.param.setOptions("3");
        }
        if (ObjectUtil.isEmpty((Object)this.param.getAnalyzetype())) {
            this.param.setAnalyzetype(config.getCloudOptions());
        }
        try {
            Geometry polygon = new WKTReader().read(this.param.getRange());
            this.param.setMj(MeasureUtil.calculateProjectionArea(this.param.getRange()) / 666.6667);
            this.param.setLon(polygon.getCentroid().getX());
            this.param.setLat(polygon.getCentroid().getY());
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u8303\u56f4\u4fe1\u606f\u6709\u8bef");
        }
        if (ObjectUtil.compare((Comparable)this.param.getMj(), (Comparable)Double.valueOf(300.0)) > 0) {
            throw new RuntimeException("\u67e5\u8be2\u8303\u56f4\u9762\u79ef\u5927\u4e8e300\u4ea9");
        }
        data.add((Object)"param", (Object)new JSONObject((Object)this.param));
        if (ObjectUtil.isNotNull((Object)this.requestId)) {
            data.add((Object)"requestId", (Object)this.requestId);
        }
        if (ObjectUtil.isNotNull((Object)this.name)) {
            data.add((Object)"name", (Object)this.name);
        }
        if (ObjectUtil.isNotNull((Object)this.tag)) {
            data.add((Object)"tag", (Object)this.tag);
        }
        if (ObjectUtil.isNotNull((Object)this.analyzeType)) {
            data.add((Object)"analyzeType", (Object)this.analyzeType);
        }
        return data;
    }

    public QueryParam getParam() {
        return this.param;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String getAnalyzeType() {
        return this.analyzeType;
    }

    public String getBizId() {
        return this.bizId;
    }

    public Integer getBizType() {
        return this.bizType;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setParam(QueryParam param) {
        this.param = param;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setAnalyzeType(String analyzeType) {
        this.analyzeType = analyzeType;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddQueryInfo)) {
            return false;
        }
        AddQueryInfo other = (AddQueryInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$bizType = this.getBizType();
        Integer other$bizType = other.getBizType();
        if (this$bizType == null ? other$bizType != null : !((Object)this$bizType).equals(other$bizType)) {
            return false;
        }
        QueryParam this$param = this.getParam();
        QueryParam other$param = other.getParam();
        if (this$param == null ? other$param != null : !((Object)this$param).equals(other$param)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$analyzeType = this.getAnalyzeType();
        String other$analyzeType = other.getAnalyzeType();
        if (this$analyzeType == null ? other$analyzeType != null : !this$analyzeType.equals(other$analyzeType)) {
            return false;
        }
        String this$bizId = this.getBizId();
        String other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !this$bizId.equals(other$bizId)) {
            return false;
        }
        String this$workspaceId = this.getWorkspaceId();
        String other$workspaceId = other.getWorkspaceId();
        return !(this$workspaceId == null ? other$workspaceId != null : !this$workspaceId.equals(other$workspaceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddQueryInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $bizType = this.getBizType();
        result = result * 59 + ($bizType == null ? 43 : ((Object)$bizType).hashCode());
        QueryParam $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $analyzeType = this.getAnalyzeType();
        result = result * 59 + ($analyzeType == null ? 43 : $analyzeType.hashCode());
        String $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : $bizId.hashCode());
        String $workspaceId = this.getWorkspaceId();
        result = result * 59 + ($workspaceId == null ? 43 : $workspaceId.hashCode());
        return result;
    }

    public String toString() {
        return "AddQueryInfo(param=" + this.getParam() + ", userId=" + this.getUserId() + ", requestId=" + this.getRequestId() + ", name=" + this.getName() + ", tag=" + this.getTag() + ", analyzeType=" + this.getAnalyzeType() + ", bizId=" + this.getBizId() + ", bizType=" + this.getBizType() + ", workspaceId=" + this.getWorkspaceId() + ")";
    }
}

