/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.data.response;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53")
public class HttpResponse<T> {
    public static final int CODE_SUCCESS = 200;
    public static final int CODE_FAILED = 500;
    public static final String MESSAGE_SUCCESS = "success";
    public static final String MESSAGE_FAILED = "failed";
    @Schema(description="\u72b6\u6001\u7801(\u6210\u529f\uff1a200 \u5f02\u5e38\uff1a500)", example="200")
    private int code;
    @Schema(description="\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u8bf4\u660e")
    private String message;
    @Schema(description="\u8ffd\u8e2a\u7684\u552f\u4e00\u6807\u8bc6")
    private String traceid;
    @Schema(description="\u72b6\u6001\u8fd4\u56de\u4fe1\u606f")
    private T data;

    public static HttpResponse success() {
        return new HttpResponseBuilder().code(200).message(MESSAGE_SUCCESS).data("").build();
    }

    public static <T> HttpResponse<T> success(T data) {
        HttpResponse response = HttpResponse.success();
        response.setData(data);
        return response;
    }

    public static <T> HttpResponse<T> success(T data, String message) {
        HttpResponse response = HttpResponse.success();
        response.setData(data);
        response.setMessage(message);
        return response;
    }

    public static HttpResponse error() {
        return new HttpResponseBuilder().code(500).message(MESSAGE_FAILED).build();
    }

    public static HttpResponse error(String message) {
        return new HttpResponseBuilder().code(500).message(message).build();
    }

    public static HttpResponse error(int code, String message) {
        return new HttpResponseBuilder().code(code).message(message).build();
    }

    HttpResponse(int code, String message, String traceid, T data) {
        this.code = code;
        this.message = message;
        this.traceid = traceid;
        this.data = data;
    }

    public static <T> HttpResponseBuilder<T> builder() {
        return new HttpResponseBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTraceid() {
        return this.traceid;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTraceid(String traceid) {
        this.traceid = traceid;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$traceid = this.getTraceid();
        String other$traceid = other.getTraceid();
        if (this$traceid == null ? other$traceid != null : !this$traceid.equals(other$traceid)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $traceid = this.getTraceid();
        result = result * 59 + ($traceid == null ? 43 : $traceid.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ", traceid=" + this.getTraceid() + ", data=" + this.getData() + ")";
    }

    public static class HttpResponseBuilder<T> {
        private int code;
        private String message;
        private String traceid;
        private T data;

        HttpResponseBuilder() {
        }

        public HttpResponseBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public HttpResponseBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public HttpResponseBuilder<T> traceid(String traceid) {
            this.traceid = traceid;
            return this;
        }

        public HttpResponseBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public HttpResponse<T> build() {
            return new HttpResponse<T>(this.code, this.message, this.traceid, this.data);
        }

        public String toString() {
            return "HttpResponse.HttpResponseBuilder(code=" + this.code + ", message=" + this.message + ", traceid=" + this.traceid + ", data=" + this.data + ")";
        }
    }
}

