/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.entity;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.airport.data.CgkPushItem;
import com.geoway.fczx.airport.entity.TaskInfo;
import com.geoway.fczx.airport.util.AirportTool;
import java.util.ArrayList;
import java.util.List;

public class GwTaskInfo
extends TaskInfo {
    private List<JSONObject> attachs;
    private List<JSONObject> photos;
    private JSONObject device;
    private String tbIds;

    public List<CgkPushItem> convertCgkItem(String jobId, String jobName, String droneSn, String username, String cgkBusType, String bizId, String bizName, String cgkRegion, String zsdm, boolean flag, String downloadUrl, String endpoint, String bucket, int width, int height) {
        ArrayList<CgkPushItem> list = new ArrayList<CgkPushItem>();
        if (ObjectUtil.isNotEmpty(this.attachs)) {
            this.attachs.forEach(e -> {
                String objectKey = (String)e.getByPath("file.object_key", String.class);
                if (ObjectUtil.notEqual((Object)"mp4", (Object)FileUtil.getSuffix((String)objectKey))) {
                    CgkPushItem item = new CgkPushItem();
                    item.setDimWidth(width);
                    item.setDimHeight(height);
                    item.setLongitude((Double)e.getByPath("file.metadata.shoot_position.lng", Double.class));
                    item.setLatitude((Double)e.getByPath("file.metadata.shoot_position.lat", Double.class));
                    item.setRoll((Integer)e.getByPath("trackInfo.gimbalRoll", Integer.class));
                    item.setAzimuth((Integer)e.getByPath("file.metadata.gimbal_yaw_degree", Integer.class));
                    item.setBizId(bizId);
                    item.setBizName(bizName);
                    item.setSm3(e.getStr((Object)"fjhxz", "unknown"));
                    item.setVerifycode(e.getStr((Object)"gtyjym", "unknown"));
                    item.setPitch((Integer)e.getByPath("trackInfo.gimbalPitch", Integer.class));
                    item.setServerPath(String.join((CharSequence)"/", endpoint, bucket, AirportTool.getCloudSecretName(objectKey)));
                    item.setPhotoTime(AirportTool.fmtCloudCreate2((String)e.getByPath("file.metadata.created_time", String.class)));
                    item.setUserName(droneSn);
                    item.setFocal35mm(e.getInt((Object)"focalLength", Integer.valueOf(0)));
                    item.setFileSize(e.getDouble((Object)"sizeNum", Double.valueOf(0.0)) / 1024.0);
                    item.setZsdm(zsdm);
                    item.setPsgd((Double)e.getByPath("file.metadata.relative_altitude", Double.class));
                    item.setJdgd((Double)e.getByPath("file.metadata.absolute_altitude", Double.class));
                    item.setYwlx(cgkBusType);
                    item.setXzqdm(cgkRegion);
                    item.setFilename(FileUtil.getName((String)objectKey));
                    item.setFlightId(jobId);
                    item.setFlightName(jobName);
                    if (ObjectUtil.isNotEmpty((Object)downloadUrl)) {
                        if (flag) {
                            item.setServerPath(AirportTool.getRedirectUrl(downloadUrl.concat(AirportTool.getCloudSecretName(objectKey))));
                        } else {
                            item.setServerPath(downloadUrl.concat(AirportTool.getCloudSecretName(objectKey)));
                        }
                    }
                    list.add(item);
                }
            });
        }
        return list;
    }

    public List<JSONObject> getAttachs() {
        return this.attachs;
    }

    public List<JSONObject> getPhotos() {
        return this.photos;
    }

    public JSONObject getDevice() {
        return this.device;
    }

    public String getTbIds() {
        return this.tbIds;
    }

    public void setAttachs(List<JSONObject> attachs) {
        this.attachs = attachs;
    }

    public void setPhotos(List<JSONObject> photos) {
        this.photos = photos;
    }

    public void setDevice(JSONObject device) {
        this.device = device;
    }

    public void setTbIds(String tbIds) {
        this.tbIds = tbIds;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GwTaskInfo)) {
            return false;
        }
        GwTaskInfo other = (GwTaskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<JSONObject> this$attachs = this.getAttachs();
        List<JSONObject> other$attachs = other.getAttachs();
        if (this$attachs == null ? other$attachs != null : !((Object)this$attachs).equals(other$attachs)) {
            return false;
        }
        List<JSONObject> this$photos = this.getPhotos();
        List<JSONObject> other$photos = other.getPhotos();
        if (this$photos == null ? other$photos != null : !((Object)this$photos).equals(other$photos)) {
            return false;
        }
        JSONObject this$device = this.getDevice();
        JSONObject other$device = other.getDevice();
        if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
            return false;
        }
        String this$tbIds = this.getTbIds();
        String other$tbIds = other.getTbIds();
        return !(this$tbIds == null ? other$tbIds != null : !this$tbIds.equals(other$tbIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GwTaskInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<JSONObject> $attachs = this.getAttachs();
        result = result * 59 + ($attachs == null ? 43 : ((Object)$attachs).hashCode());
        List<JSONObject> $photos = this.getPhotos();
        result = result * 59 + ($photos == null ? 43 : ((Object)$photos).hashCode());
        JSONObject $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        String $tbIds = this.getTbIds();
        result = result * 59 + ($tbIds == null ? 43 : $tbIds.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GwTaskInfo(attachs=" + this.getAttachs() + ", photos=" + this.getPhotos() + ", device=" + this.getDevice() + ", tbIds=" + this.getTbIds() + ")";
    }
}

