/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.entity;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.airport.data.CgkPushItem;
import com.geoway.fczx.airport.util.AirportTool;

public class TaskFileInfo {
    private String name;
    private String objectKey;
    private Object metadata;

    public JSONObject obtainMetaJson() {
        if (ObjectUtil.isNotEmpty((Object)this.metadata)) {
            return (JSONObject)this.metadata;
        }
        return null;
    }

    public CgkPushItem convertCgkItem(String jobId, String jobName, String droneSn, String username, String cgkBusType, String bizId, String bizName, String cgkRegion, String zsdm, boolean flag, String downloadUrl, String endpoint, String bucket, int width, int height) {
        JSONObject e = this.obtainMetaJson();
        if (e != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{e.getStr((Object)"gtyjym"), e.getStr((Object)"fjhxz")})) {
            CgkPushItem item = new CgkPushItem();
            item.setDimWidth(width);
            item.setDimHeight(height);
            item.setLongitude(e.getDouble((Object)"longitude", Double.valueOf(0.0)));
            item.setLatitude(e.getDouble((Object)"latitude", Double.valueOf(0.0)));
            item.setRoll(e.getInt((Object)"pshgj", Integer.valueOf(0)));
            item.setAzimuth(e.getInt((Object)"psjd", Integer.valueOf(0)));
            item.setBizId(bizId);
            item.setBizName(bizName);
            item.setSm3(e.getStr((Object)"fjhxz", "unknown"));
            item.setVerifycode(e.getStr((Object)"gtyjym", "unknown"));
            item.setPitch(e.getInt((Object)"psfyj", Integer.valueOf(0)));
            item.setServerPath(String.join((CharSequence)"/", endpoint, bucket, AirportTool.getCloudSecretName(this.objectKey)));
            item.setPhotoTime(e.getStr((Object)"pssj"));
            item.setUserName(droneSn);
            item.setFocal35mm(e.getInt((Object)"psjj", Integer.valueOf(0)));
            item.setFileSize(e.getDouble((Object)"fjsize", Double.valueOf(0.0)) / 1024.0);
            item.setZsdm(zsdm);
            item.setPsgd(e.getDouble((Object)"xdgd", Double.valueOf(0.0)));
            item.setJdgd(e.getDouble((Object)"jdgd", Double.valueOf(0.0)));
            item.setYwlx(cgkBusType);
            item.setXzqdm(cgkRegion);
            item.setFilename(this.name);
            item.setFlightId(jobId);
            item.setFlightName(jobName);
            if (ObjectUtil.isNotEmpty((Object)downloadUrl)) {
                if (flag) {
                    item.setServerPath(AirportTool.getRedirectUrl(downloadUrl.concat(AirportTool.getCloudSecretName(this.objectKey))));
                } else {
                    item.setServerPath(downloadUrl.concat(AirportTool.getCloudSecretName(this.objectKey)));
                }
            }
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskFileInfo)) {
            return false;
        }
        TaskFileInfo other = (TaskFileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$objectKey = this.getObjectKey();
        String other$objectKey = other.getObjectKey();
        if (this$objectKey == null ? other$objectKey != null : !this$objectKey.equals(other$objectKey)) {
            return false;
        }
        Object this$metadata = this.getMetadata();
        Object other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskFileInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $objectKey = this.getObjectKey();
        result = result * 59 + ($objectKey == null ? 43 : $objectKey.hashCode());
        Object $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "TaskFileInfo(name=" + this.getName() + ", objectKey=" + this.getObjectKey() + ", metadata=" + this.getMetadata() + ")";
    }

    public TaskFileInfo() {
    }

    public TaskFileInfo(String name, String objectKey, Object metadata) {
        this.name = name;
        this.objectKey = objectKey;
        this.metadata = metadata;
    }
}

