/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.entity;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.airport.data.ShootPosition;
import com.geoway.fczx.airport.data.TaskAttach;
import com.geoway.fczx.airport.entity.TaskFileInfo;
import com.geoway.fczx.airport.util.AirportTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaskResultInfo {
    private static final String DOWN_URL = "/api/files/v1/original?objectKey=";
    private String jobId;
    private String tbIds;
    private String attachs;
    private Integer status;

    public int countAttach() {
        if (ObjectUtil.isNotEmpty((Object)this.attachs)) {
            return JSONUtil.parseArray((String)this.attachs).size();
        }
        return 0;
    }

    public int countSpot() {
        if (ObjectUtil.isNotEmpty((Object)this.tbIds)) {
            return this.tbIds.split(",").length;
        }
        return 0;
    }

    public List<TaskAttach> convertAttaches(String serverUrl, Map<String, TaskFileInfo> metas) {
        if (this.countAttach() > 0) {
            ArrayList<TaskAttach> attaches = new ArrayList<TaskAttach>();
            for (JSONObject json : JSONUtil.parseArray((String)this.attachs).jsonIter()) {
                JSONObject meta;
                if (!json.containsKey((Object)"file")) continue;
                JSONObject file = json.getJSONObject((Object)"file");
                TaskAttach attach = (TaskAttach)file.getBean((Object)"metadata", TaskAttach.class);
                attach.setFilename(file.getStr((Object)"name"));
                String gtyjym = "";
                if (metas != null && metas.get(attach.getFilename()) != null && (meta = metas.get(attach.getFilename()).obtainMetaJson()) != null) {
                    gtyjym = meta.getStr((Object)"gtyjym");
                }
                attach.setGtyjym(gtyjym);
                attach.setDownload(serverUrl.concat(DOWN_URL).concat(AirportTool.getCloudSecretName(file.getStr((Object)"object_key"))));
                ShootPosition position = (ShootPosition)file.getByPath("metadata.shoot_position", ShootPosition.class);
                if (ObjectUtil.isNotEmpty((Object)position)) {
                    attach.setLatitude(position.getLat());
                    attach.setLongitude(position.getLng());
                }
                attaches.add(attach);
            }
            return attaches;
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getTbIds() {
        return this.tbIds;
    }

    public String getAttachs() {
        return this.attachs;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setTbIds(String tbIds) {
        this.tbIds = tbIds;
    }

    public void setAttachs(String attachs) {
        this.attachs = attachs;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskResultInfo)) {
            return false;
        }
        TaskResultInfo other = (TaskResultInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$tbIds = this.getTbIds();
        String other$tbIds = other.getTbIds();
        if (this$tbIds == null ? other$tbIds != null : !this$tbIds.equals(other$tbIds)) {
            return false;
        }
        String this$attachs = this.getAttachs();
        String other$attachs = other.getAttachs();
        return !(this$attachs == null ? other$attachs != null : !this$attachs.equals(other$attachs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskResultInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $tbIds = this.getTbIds();
        result = result * 59 + ($tbIds == null ? 43 : $tbIds.hashCode());
        String $attachs = this.getAttachs();
        result = result * 59 + ($attachs == null ? 43 : $attachs.hashCode());
        return result;
    }

    public String toString() {
        return "TaskResultInfo(jobId=" + this.getJobId() + ", tbIds=" + this.getTbIds() + ", attachs=" + this.getAttachs() + ", status=" + this.getStatus() + ")";
    }
}

