/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.handler;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.airport.data.property.AirportAccessProperties;
import com.geoway.fczx.airport.service.AirportAccessService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class AppStartedHandler
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(AppStartedHandler.class);
    @Value(value="${app.version:v1.0.0}")
    private String version;
    @Value(value="${app.build-time:}")
    private String time;
    @Resource
    private AirportAccessProperties accessProperties;
    @Resource
    private AirportAccessService airportService;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (ObjectUtil.isNotEmpty((Object)this.accessProperties.getDroneServerUrl())) {
            this.printVersion();
        }
        if (BooleanUtil.isTrue((Boolean)this.accessProperties.getInitIcloudNamespace())) {
            this.airportService.initICloudNamespace();
        }
    }

    public int getOrder() {
        return 0;
    }

    private void printVersion() {
        System.out.println("===================================================================");
        System.out.println("\t\t\u5f53\u524d\u7248\u672c\uff1a" + this.version + "\t\u6253\u5305\u65f6\u95f4\uff1a" + AppStartedHandler.formatPkgTime(this.time));
        System.out.println("===================================================================");
    }

    public static String formatPkgTime(String time) {
        if (time != null && ObjectUtil.isNotEmpty((Object)time) && !time.contains("T")) {
            return time.substring(0, 4) + "-" + time.substring(4, 6) + "-" + time.substring(6, 8) + " " + time.substring(8, 10) + ":" + time.substring(10, 12) + ":" + time.substring(12, 14);
        }
        return time;
    }
}

