/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.druid.proxy.jdbc.ClobProxyImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.postgresql.util.PGobject;

public class JsonTypeHandler
extends BaseTypeHandler {
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        Connection conn = ps.getConnection();
        if (JsonTypeHandler.isEmbeddedDb(conn)) {
            ps.setObject(i, JSONUtil.toJsonStr((Object)parameter));
        } else {
            PGobject ext = new PGobject();
            ext.setType("json");
            ext.setValue(JSONUtil.toJsonStr((Object)parameter));
            ps.setObject(i, ext);
        }
    }

    private static boolean isEmbeddedDb(Connection connection) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        return productName.equalsIgnoreCase("apache derby") || productName.equalsIgnoreCase("H2");
    }

    public Object getNullableResult(ResultSet resultSet, String s) throws SQLException {
        Object resData = resultSet.getObject(s);
        if (resData instanceof ClobProxyImpl) {
            return this.getJSON(resData);
        }
        return ObjectUtil.isEmpty((Object)resData) ? null : JSONUtil.parse((Object)resData.toString());
    }

    public Object getNullableResult(ResultSet resultSet, int i) throws SQLException {
        Object resData = resultSet.getObject(i);
        if (resData instanceof ClobProxyImpl) {
            return this.getJSON(resData);
        }
        return ObjectUtil.isEmpty((Object)resData) ? null : JSONUtil.parse((Object)resData.toString());
    }

    public Object getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        Object resData = callableStatement.getObject(i);
        if (resData instanceof ClobProxyImpl) {
            return this.getJSON(resData);
        }
        return ObjectUtil.isEmpty((Object)resData) ? null : JSONUtil.parse((Object)resData.toString());
    }

    private Object getJSON(Object data) throws SQLException {
        String res = JsonTypeHandler.ClobToString((Clob)((ClobProxyImpl)data));
        return ObjectUtil.isEmpty((Object)res) ? null : JSONUtil.parse((Object)res);
    }

    public static String ClobToString(Clob clob) throws SQLException {
        String reString = "";
        try {
            Reader is = clob.getCharacterStream();
            BufferedReader br = new BufferedReader(is);
            String s = br.readLine();
            StringBuffer sb = new StringBuffer();
            while (s != null) {
                sb.append(s);
                s = br.readLine();
            }
            reString = sb.toString();
            return reString;
        }
        catch (IOException e) {
            throw new SQLException("ClobToString error,{}", e.toString());
        }
    }
}

