/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.handler;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.airport.handler.AbstractResultEncoder;
import com.geoway.fczx.airport.service.AirportAccessService;
import com.geoway.fczx.airport.service.CloudQueryService;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResultEncodeHandler
implements AbstractResultEncoder {
    private static final Logger log = LoggerFactory.getLogger(ResultEncodeHandler.class);
    @Resource
    private AirportAccessService airportService;
    @Resource
    private CloudQueryService queryService;

    @Override
    public void before(Method method, Object[] args, Object target) {
        try {
            String payload;
            if (ObjectUtil.isNotEmpty((Object)args) && args.length == 2 && ObjectUtil.isNotEmpty((Object)(payload = (String)args[1]))) {
                String event = (String)JSONUtil.parseObj((String)payload).getByPath("method", String.class);
                if (ObjectUtil.equal((Object)event, (Object)"dji_flight_device_sync")) {
                    String workspaceId = (String)JSONUtil.parseObj((String)payload).getByPath("data.workspace_id", String.class);
                    if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
                        this.queryService.syncCloudQueryState(workspaceId);
                    }
                } else {
                    Map<String, Object> res;
                    String objectKey = (String)JSONUtil.parseObj((String)payload).getByPath("data.file.object_key", String.class);
                    if (ObjectUtil.isNotEmpty((Object)objectKey) && ObjectUtil.contains(Arrays.asList("jpeg", "jpg"), (Object)FileUtil.getSuffix((String)objectKey)) && ObjectUtil.isNotEmpty((Object)(res = this.airportService.encodeResult(objectKey, true)).get("fjhxz"))) {
                        args[1] = JSONUtil.parseObj((Object)args[1]).putOpt("fjhxz", res.get("fjhxz")).putOpt("gtyjym", res.get("gtyjym")).toString();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u6210\u679c\u52a0\u5bc6/\u4e91\u67e5\u8be2\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
    }
}

