/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.org.landcloud.security.sm3.SM3Utils;
import com.geoway.fczx.airport.dao.FlightTaskDao;
import com.geoway.fczx.airport.data.AddTaskParam;
import com.geoway.fczx.airport.data.CloudExifBuild;
import com.geoway.fczx.airport.data.DroneStatus;
import com.geoway.fczx.airport.data.TaskResult;
import com.geoway.fczx.airport.data.property.AirportAccessProperties;
import com.geoway.fczx.airport.data.property.NamespaceProperties;
import com.geoway.fczx.airport.data.redis.Device;
import com.geoway.fczx.airport.data.redis.DockOsd;
import com.geoway.fczx.airport.data.redis.DroneOsd;
import com.geoway.fczx.airport.data.redis.DronePayload;
import com.geoway.fczx.airport.data.response.HttpResponse;
import com.geoway.fczx.airport.entity.TaskFileInfo;
import com.geoway.fczx.airport.entity.TaskInfo;
import com.geoway.fczx.airport.entity.TaskResultInfo;
import com.geoway.fczx.airport.handler.RedisServiceHandler;
import com.geoway.fczx.airport.service.AirportAccessService;
import com.geoway.fczx.airport.thirdapi.fczx.FczxRestService;
import com.geoway.fczx.airport.util.AirportTool;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.Path;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLong;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AirportAccessServiceImpl
implements AirportAccessService {
    private static final Logger log = LoggerFactory.getLogger(AirportAccessServiceImpl.class);
    private static final int TAG_PIXEL_X_DIMENSION = 40962;
    private static final int TAG_PIXEL_Y_DIMENSION = 40963;
    private static final int TAG_EXIF_VERSION = 36864;
    private static final int TAG_MAKER_NOTE = 37500;
    private static final TagInfoLong EXIF_PIXEL_X_DIMENSION = new TagInfoLong("PixelXDimension", 40962, TiffDirectoryType.EXIF_DIRECTORY_EXIF_IFD, true);
    private static final TagInfoLong EXIF_PIXEL_Y_DIMENSION = new TagInfoLong("PixelYDimension", 40963, TiffDirectoryType.EXIF_DIRECTORY_EXIF_IFD, true);
    private static final TagInfoAscii EXIF_EXIF_VERSION = new TagInfoAscii("ExifVersion", 36864, -1, TiffDirectoryType.EXIF_DIRECTORY_EXIF_IFD);
    private static final TagInfoAscii EXIF_MAKER_NOTE = new TagInfoAscii("MakerNote", 37500, -1, TiffDirectoryType.EXIF_DIRECTORY_EXIF_IFD);
    @Resource
    private AirportAccessProperties accessProperties;
    @Resource
    private RedisServiceHandler redisService;
    @Resource
    private FczxRestService fczxRestService;
    @Resource
    private FlightTaskDao flightTaskDao;

    @Override
    public HttpResponse<DroneStatus> getDroneStatus(String deviceid) {
        DroneStatus status = new DroneStatus();
        Device device = this.redisService.getBean("online:" + deviceid, Device.class);
        if (device != null) {
            switch (device.getDomain()) {
                case 3: {
                    DockOsd dockOsd = this.redisService.getBean("osd:" + deviceid, DockOsd.class);
                    if (dockOsd == null) break;
                    BeanUtil.copyProperties((Object)dockOsd, (Object)status, (String[])new String[0]);
                    return HttpResponse.success(status);
                }
                case 0: {
                    List payloads;
                    DroneOsd droneOsd = this.redisService.getBean("osd:" + deviceid, DroneOsd.class);
                    if (droneOsd == null) break;
                    BeanUtil.copyProperties((Object)droneOsd, (Object)status, (String[])new String[0]);
                    status.setElevation(droneOsd.getElevation());
                    status.setBatteryCapacityPercent(droneOsd.getBattery().getCapacityPercent());
                    if (!droneOsd.getPayload().isEmpty() && droneOsd.getPayload().size() > 1 && !(payloads = droneOsd.getPayload().getBeanList((Object)1, DronePayload.class)).isEmpty()) {
                        status.setGimbalYaw(((DronePayload)payloads.get(0)).getGimbalYaw());
                        status.setGimbalPitch(((DronePayload)payloads.get(0)).getGimbalPitch());
                    }
                    return HttpResponse.success(status);
                }
            }
            status.setModeCode(-1);
        } else {
            status.setModeCode(-2);
        }
        return HttpResponse.success(status);
    }

    @Override
    public HttpResponse<Object> addTask(AddTaskParam param) {
        OpRes<String> create;
        boolean existed;
        List<Map<String, Object>> spots = param.convertSpotList();
        boolean flag = spots.stream().anyMatch(spot -> ObjectUtil.isEmpty(spot.get("bsm")));
        if (flag) {
            return HttpResponse.error("\u6807\u8bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NamespaceProperties info = this.accessProperties.getNamespaceConfig();
        if (ObjectUtil.isNotEmpty((Object)param.getBizidname())) {
            info.setName(param.getBizidname());
        }
        if (ObjectUtil.isNotEmpty((Object)param.getBizcode())) {
            info.setNsId(param.getBizcode());
        }
        if (!(existed = this.flightTaskDao.existICloudNs(param.getBizcode())) && !(create = this.fczxRestService.createICloudNs(info)).isOpRes()) {
            log.error("\u521b\u5efa\u9879\u76ee\u5931\u8d25{}", (Object)create.getErrorDesc());
            return HttpResponse.error(create.getErrorDesc());
        }
        OpRes<Boolean> res = this.fczxRestService.importSpotData(info, spots);
        if (!res.isOpRes()) {
            return HttpResponse.error(res.getErrorDesc());
        }
        if (BooleanUtil.isTrue((Boolean)param.getTaskIsFlight())) {
            ArrayList<String> bsm = new ArrayList<String>();
            spots.forEach(spot -> bsm.add((String)spot.get("bsm")));
            OpRes<JSONObject> data = this.fczxRestService.makeFlightTask(info, param.getBizidname(), bsm);
            if (!data.isOpRes()) {
                return HttpResponse.error(res.getErrorDesc());
            }
            Set jobs = ((JSONObject)data.getData()).keySet();
            if (!jobs.isEmpty()) {
                jobs.remove("restrict");
                jobs.remove("invalid");
                jobs.remove("failed");
            }
            return HttpResponse.success(jobs, "\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u6dfb\u52a0\u6210\u529f");
        }
        return HttpResponse.success(info.getNsId(), "\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public HttpResponse<Object> cancelTask(String taskid, Boolean taskIsFlight) {
        if (BooleanUtil.isTrue((Boolean)taskIsFlight)) {
            TaskInfo taskInfo = this.flightTaskDao.findTaskInfo(taskid);
            if (taskInfo != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{taskInfo, taskInfo.getDockSn()})) {
                try {
                    OpRes<Boolean> res = this.fczxRestService.cancelFlightTask(taskid);
                    if (res.isOpRes()) {
                        return HttpResponse.success(taskid, "\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u53d6\u6d88\u6210\u529f\uff01");
                    }
                    return HttpResponse.error(res.getErrorDesc());
                }
                catch (Exception e) {
                    log.error("\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u53d6\u6d88\u5931\u8d25", (Throwable)e);
                    return HttpResponse.error("\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u53d6\u6d88\u5931\u8d25\uff01");
                }
            }
        } else {
            NamespaceProperties info = this.flightTaskDao.findNamespace(taskid);
            if (info != null) {
                info.setStatus(3);
                int flag = this.flightTaskDao.updateNamespaceStatus(info);
                return flag > 0 ? HttpResponse.success(taskid, "\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u53d6\u6d88\u6210\u529f\uff01") : HttpResponse.error("\u65e0\u4eba\u673a\u673a\u573a\u4efb\u52a1\u53d6\u6d88\u5931\u8d25\uff01");
            }
        }
        return HttpResponse.error("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u4fe1\u606f");
    }

    @Override
    public HttpResponse<Object> queryTaskStatus(String taskid, Boolean taskIsFlight) {
        if (BooleanUtil.isTrue((Boolean)taskIsFlight)) {
            TaskInfo taskInfo = this.flightTaskDao.findTaskInfo(taskid);
            if (taskInfo != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{taskInfo, taskInfo.getStatus()})) {
                switch (taskInfo.getStatus()) {
                    case 1: {
                        return HttpResponse.error(201, "\u4efb\u52a1\u5f85\u6267\u884c");
                    }
                    case 2: {
                        return HttpResponse.error(202, "\u4efb\u52a1\u6267\u884c\u4e2d");
                    }
                    case 3: {
                        return HttpResponse.success("", "\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
                    }
                    case 4: {
                        return HttpResponse.error(204, "\u4efb\u52a1\u53d6\u6d88");
                    }
                    case 5: {
                        return HttpResponse.error(205, "\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                    }
                    case 6: {
                        return HttpResponse.error(206, "\u4efb\u52a1\u6682\u505c");
                    }
                }
            }
        } else {
            NamespaceProperties info = this.flightTaskDao.findNamespace(taskid);
            if (info != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{info, info.getStatus()})) {
                switch (info.getStatus()) {
                    case 1: {
                        return HttpResponse.error(202, "\u4efb\u52a1\u6267\u884c\u4e2d");
                    }
                    case 2: {
                        return HttpResponse.success("", "\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
                    }
                    case 3: {
                        return HttpResponse.error(204, "\u4efb\u52a1\u53d6\u6d88");
                    }
                }
            }
        }
        return HttpResponse.error("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u4fe1\u606f");
    }

    @Override
    public HttpResponse<TaskResult> getResult(String taskid, Boolean taskIsFlight) {
        TaskResultInfo resultInfo = this.flightTaskDao.findTaskResult(taskid, BooleanUtil.isTrue((Boolean)taskIsFlight));
        if (ObjectUtil.isEmpty((Object)resultInfo)) {
            return HttpResponse.error("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u4fe1\u606f");
        }
        if (ObjectUtil.isEmpty((Object)resultInfo.getAttachs()) || resultInfo.countAttach() == 0) {
            return HttpResponse.error("\u672a\u627e\u5230\u4efb\u52a1\u5173\u8054\u6210\u679c\u4fe1\u606f");
        }
        Map<String, TaskFileInfo> files = this.flightTaskDao.findTaskFileMetas(taskid);
        String serverUrl = System.getProperty("com.geoway.fczx.airport.drone-server-url");
        TaskResult taskResult = new TaskResult();
        taskResult.setTaskid(taskid);
        taskResult.setCount(resultInfo.countSpot());
        taskResult.setAttachmentCount(resultInfo.countAttach());
        taskResult.setAttaches(resultInfo.convertAttaches(serverUrl, files));
        return HttpResponse.success(taskResult, "\u65e0\u4eba\u673a\u6210\u679c\u83b7\u53d6\u6210\u529f");
    }

    @Override
    public void initICloudNamespace() {
        boolean flag = this.flightTaskDao.existICloudNs(this.accessProperties.getNamespaceConfig().getNsId());
        if (!flag) {
            this.fczxRestService.createICloudNs(this.accessProperties.getNamespaceConfig());
        }
    }

    @Override
    public Map<String, Object> encodeResult(String objectKey, boolean upload) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        StringBuilder jym = new StringBuilder();
        byte[] data = this.obtainEncodeResult(objectKey, upload, jym);
        if (ObjectUtil.isNotEmpty((Object)data)) {
            String fjhxz = SM3Utils.sm3((byte[])data);
            res.put("fjhxz", fjhxz);
        }
        if (ObjectUtil.isNotEmpty((Object)jym)) {
            log.debug("\u9644\u4ef6{}\u56fd\u571f\u4e91\u6821\u9a8c\u7801\u662f{}", (Object)objectKey, (Object)jym);
            res.put("gtyjym", jym.toString());
        }
        return res;
    }

    @Override
    public byte[] obtainEncodeResult(String objectKey, boolean upload, StringBuilder jym) {
        if (objectKey == null) {
            log.error("\u52a0\u5bc6\u6210\u679cobjectKey\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        if (!objectKey.endsWith("jpeg")) {
            log.error("\u52a0\u5bc6\u6210\u679cobjectKey{}\u4e0d\u652f\u6301\u683c\u5f0f\u9644\u4ef6", (Object)objectKey);
            return null;
        }
        List<TaskFileInfo> files = this.flightTaskDao.findMediaMeta(objectKey);
        if (ObjectUtil.isNotEmpty(files)) {
            for (TaskFileInfo file : files) {
                JSONObject json = file.obtainMetaJson();
                if (json != null && json.containsKey((Object)"gtyjym")) {
                    jym.append(json.getStr((Object)"gtyjym"));
                    String path = AirportTool.getCloudSecretName(objectKey);
                    String httpUrl = this.accessProperties.getDroneServerUrl() + "/api/files/v1/original?objectKey=" + path;
                    try {
                        return AirportTool.getHttpFileContent(httpUrl, FileUtil.getName((String)path));
                    }
                    catch (Exception e) {
                        log.error("\u4e0b\u8f7d\u9644\u4ef6{}\u5931\u8d25", (Object)path, (Object)e);
                        continue;
                    }
                }
                return this.encodeResultFile(objectKey, upload, jym);
            }
        } else {
            return this.encodeResultFile(objectKey, upload, jym);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveCloudExif(CloudExifBuild meta, InputStream input, String output) {
        String original = System.getProperty("user.dir") + "/" + IdUtil.fastSimpleUUID() + "." + "jpeg";
        try {
            File file = FileUtil.writeFromStream((InputStream)input, (String)original);
            ImageMetadata metadata = Imaging.getMetadata((File)file);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffOutputSet out = new TiffOutputSet();
            if (jpegMetadata != null) {
                TiffImageMetadata exif = jpegMetadata.getExif();
                out = exif.getOutputSet();
            }
            TiffOutputDirectory root = out.getOrCreateRootDirectory();
            root.removeField((TagInfo)TiffTagConstants.TIFF_TAG_ARTIST);
            root.add(TiffTagConstants.TIFF_TAG_ARTIST, new String[]{meta.getPsry()});
            TiffOutputDirectory exif = out.getOrCreateExifDirectory();
            TiffOutputDirectory gps = out.getOrCreateGpsDirectory();
            out.setGpsInDegrees(meta.getLongitude().doubleValue(), meta.getLatitude().doubleValue());
            gps.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE, RationalNumber.valueOf((double)meta.getXdgd()));
            gps.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)meta.getPsjd().intValue()));
            exif.add(EXIF_EXIF_VERSION, new String[]{"0230"});
            exif.add(TiffTagConstants.TIFF_TAG_SOFTWARE, new String[]{meta.getZsdm()});
            exif.add(TiffTagConstants.TIFF_TAG_ARTIST, new String[]{meta.getPsry()});
            exif.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE, RationalNumber.valueOf((double)meta.getXdgd()));
            exif.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)meta.getPsjd().intValue()));
            exif.add(EXIF_PIXEL_X_DIMENSION, (int)meta.getFjyskd().shortValue());
            exif.add(EXIF_PIXEL_Y_DIMENSION, (int)meta.getFjysgd().shortValue());
            exif.add(ExifTagConstants.EXIF_TAG_DIGITAL_ZOOM_RATIO, RationalNumber.valueOf((double)meta.getBjbs().shortValue()));
            exif.add(ExifTagConstants.EXIF_TAG_FOCAL_LENGTH_IN_35MM_FORMAT, meta.getPsjj().shortValue());
            exif.add(TiffTagConstants.TIFF_TAG_DATE_TIME, new String[]{String.valueOf(meta.getPssj())});
            exif.add(EXIF_MAKER_NOTE, new String[]{meta.getNote()});
            BufferedOutputStream bos = new BufferedOutputStream(FileUtil.getOutputStream((String)output));
            new ExifRewriter().updateExifMetadataLossless(file, (OutputStream)bos, out);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (FileUtil.exist((String)original)) {
                FileUtil.del((String)original);
            }
        }
        return true;
    }

    private String generateCloudCode(CloudExifBuild exif, byte[] file) {
        try {
            String keyword = exif.concatKeyword(SM3Utils.sm3((byte[])file));
            return AirportTool.generateCloudCode(this.accessProperties.getLicenseSecret(), keyword);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u56fd\u571f\u4e91\u9644\u4ef6\u6821\u9a8c\u7801\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private byte[] encodeResultFile(String objectKey, boolean upload, StringBuilder jym) {
        OpRes<JSONObject> res = this.fczxRestService.readAttachExif(objectKey);
        if (res.isOpRes() && ObjectUtil.isNotEmpty((Object)res.getData())) {
            CloudExifBuild exif = AirportTool.buildCloudExif((JSONObject)res.getData(), this.accessProperties.getLicenseCode());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("width", this.accessProperties.getResWidth());
            param.put("height", this.accessProperties.getResHeight());
            OpRes<InputStream> thumb = this.fczxRestService.buildCloudThumb(objectKey, param);
            if (thumb.isOpRes()) {
                String path = AirportTool.getCloudSecretName(objectKey);
                String output = Path.joinPath((String)File.separator, (String[])new String[]{System.getProperty("user.dir"), path});
                boolean flag = this.saveCloudExif(exif, (InputStream)thumb.getData(), output);
                if (flag) {
                    OpRes<Boolean> opRes;
                    byte[] data = FileUtil.readBytes((String)output);
                    HashMap<String, Object> meta = new HashMap<String, Object>();
                    jym.append(this.generateCloudCode(exif, data));
                    if (ObjectUtil.isNotEmpty((Object)jym.toString())) {
                        meta.putAll(exif.toMap());
                        meta.put("fjhxz", SM3Utils.sm3((byte[])data));
                        meta.put("gtyjym", jym.toString());
                        meta.put("fjsize", data.length);
                        try {
                            this.flightTaskDao.updateMediaMeta(new TaskFileInfo(FileUtil.getName((String)path), objectKey, meta));
                        }
                        catch (Exception e) {
                            log.error("\u63d2\u5165\u9644\u4ef6{}\u56fd\u571f\u4e91\u6821\u9a8c\u7801\u5931\u8d25", (Object)objectKey, (Object)e);
                        }
                    }
                    log.debug("\u9644\u4ef6{}\u751f\u6210\u56fd\u571f\u4e91\u6821\u9a8c\u7801{}", (Object)objectKey, (Object)jym);
                    if (BooleanUtil.isTrue((Boolean)upload) && !(opRes = this.fczxRestService.uploadCloudExif(path, output, meta)).isOpRes()) {
                        log.error("\u4e0a\u4f20\u56fd\u571f\u4e91\u52a0\u5bc6\u6210\u679c{}\u5931\u8d25", (Object)output);
                    }
                    if (FileUtil.exist((String)output)) {
                        FileUtil.del((String)output);
                    }
                    return data;
                }
                log.error("\u4fdd\u5b58{}\u56fd\u571f\u4e91\u56fe\u7247exif\u5931\u8d25", (Object)output);
            }
        }
        return null;
    }
}

