/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.airport.dao.CloudQueryDao;
import com.geoway.fczx.airport.data.WorkConfig;
import com.geoway.fczx.airport.data.property.CloudQueryProperties;
import com.geoway.fczx.airport.data.query.AddQueryInfo;
import com.geoway.fczx.airport.data.query.AddResultInfo;
import com.geoway.fczx.airport.data.query.BizQueryData;
import com.geoway.fczx.airport.data.query.QueryItem;
import com.geoway.fczx.airport.service.CloudQueryService;
import com.geoway.fczx.airport.thirdapi.cloud.CloudRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CloudQueryServiceImpl
implements CloudQueryService {
    private static final Logger log = LoggerFactory.getLogger(CloudQueryServiceImpl.class);
    @Resource
    private CloudRestService cloudRestService;
    @Resource
    private CloudQueryProperties properties;
    @Resource
    private CloudQueryDao queryDao;

    @Override
    public CloudQueryProperties obtainProperties(String workspaceId) {
        WorkConfig config = this.queryDao.findWorkConfig(workspaceId);
        if (config != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{config.getMetadata(), config.getMetadata().getByPath("cloudQueryConfig.value")})) {
            return (CloudQueryProperties)config.getMetadata().getByPath("cloudQueryConfig.value", CloudQueryProperties.class);
        }
        return this.properties;
    }

    @Override
    public boolean addQueryBizLogic(AddQueryInfo param, JSONObject queryRes) {
        WorkConfig data = this.queryDao.findBizData(param.getBizType(), param.getBizId());
        if (ObjectUtil.isEmpty((Object)data)) {
            log.error("\u672a\u627e\u5230{}\u76f8\u5173\u4e1a\u52a1{}\u6570\u636e", (Object)param.getBizType(), (Object)param.getBizId());
            return false;
        }
        data.getMetadata().putOpt("queryId", (Object)(ObjectUtil.isNotEmpty((Object)queryRes) ? queryRes.getStr((Object)"id") : ""));
        data.getMetadata().putOpt("queryState", ObjectUtil.isNotEmpty((Object)queryRes) ? queryRes.getInt((Object)"state") : null);
        data.getMetadata().putOpt("analyzeType", (Object)(ObjectUtil.isNotEmpty((Object)queryRes) ? param.getParam().getAnalyzetype() : ""));
        data.getMetadata().putOpt("queryRequestId", (Object)(ObjectUtil.isNotEmpty((Object)queryRes) ? queryRes.getStr((Object)"requestId") : ""));
        return this.queryDao.updateQueryData(new BizQueryData(param.getBizType(), param.getBizId(), data.getMetadata())) > 0;
    }

    @Override
    public void syncCloudQueryState(String workspaceId) {
    }

    @Override
    public OpRes<JSONObject> getResult(CloudQueryProperties config, String requestId, String id, String analyzeType) {
        OpRes<JSONObject> res;
        if (ObjectUtil.isEmpty((Object)analyzeType)) {
            analyzeType = "0";
        }
        if (!(res = this.cloudRestService.getRecordStateByRequestId(config, requestId, analyzeType)).isOpRes()) {
            return res;
        }
        List state = (List)((JSONObject)res.getData()).getByPath("data.state", List.class);
        if (ObjectUtil.equal((Object)4, state.get(0))) {
            return new OpRes("\u4e0a\u4f20\u5931\u8d25", null, false);
        }
        if (ObjectUtil.contains(Arrays.asList(1, 2), state.get(0))) {
            res = this.cloudRestService.getRecordByRequestId(config, requestId, analyzeType);
            if (!res.isOpRes()) {
                log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55id={}\u5931\u8d25", (Object)requestId);
                return res;
            }
            String queryParam = (String)((JSONObject)res.getData()).getByPath("data[0].param", String.class);
            if (ObjectUtil.isEmpty((Object)queryParam)) {
                return new OpRes("\u83b7\u53d6\u5f53\u524d\u4e91\u67e5\u8be2\u8bb0\u5f55\u8bf7\u6c42\u53c2\u6570\u5931\u8d25", null, false);
            }
            String displayAnalyzeType = JSONUtil.parseObj((String)queryParam).getStr((Object)"analyzetype");
            if (ObjectUtil.isEmpty((Object)displayAnalyzeType)) {
                return new OpRes("\u83b7\u53d6\u5f53\u524d\u4e91\u67e5\u8be2\u8bb0\u5f55\u5206\u6790\u9879\u5931\u8d25", null, false);
            }
            res = this.cloudRestService.getResultJSON(config, requestId);
            if (!res.isOpRes()) {
                log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8be6\u60c5requestId={}\u5931\u8d25", (Object)requestId);
                return res;
            }
            JSONObject detailResultJson = ((JSONObject)res.getData()).getJSONObject((Object)"data");
            res = this.cloudRestService.getQueryItems(config);
            if (!res.isOpRes()) {
                log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u9009\u9879{}\u5931\u8d25", (Object)config);
                return res;
            }
            List items = ((JSONObject)res.getData()).getBeanList((Object)"data", QueryItem.class).stream().filter(d -> ObjectUtil.contains((Object)displayAnalyzeType.split("\u3001"), (Object)d.getDisplayAnalyzeType())).collect(Collectors.toList());
            AddResultInfo info = new AddResultInfo();
            info.setId(id);
            info.setMetaJson(new JSONArray(items));
            info.setDetailResultJson(detailResultJson);
            res = this.cloudRestService.addResult(config, info);
            return res;
        }
        return res;
    }
}

