/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.org.landcloud.security.sm3.SM3Utils;
import com.geoway.fczx.airport.dao.DbExportDao;
import com.geoway.fczx.airport.dao.FlightTaskDao;
import com.geoway.fczx.airport.data.CgkPushItem;
import com.geoway.fczx.airport.data.CloudExifBuild;
import com.geoway.fczx.airport.data.DbResultItem;
import com.geoway.fczx.airport.data.StandardExport;
import com.geoway.fczx.airport.data.property.AirportAccessProperties;
import com.geoway.fczx.airport.entity.DbExport;
import com.geoway.fczx.airport.entity.GwTaskInfo;
import com.geoway.fczx.airport.entity.TaskFileInfo;
import com.geoway.fczx.airport.entity.TaskSpot;
import com.geoway.fczx.airport.service.StandardDbExportService;
import com.geoway.fczx.airport.thirdapi.cloud.CgkRestService;
import com.geoway.fczx.airport.thirdapi.fczx.FczxRestService;
import com.geoway.fczx.airport.util.AirportTool;
import com.geoway.fczx.airport.util.SqlLiteConnTool;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class StandardDbExportServiceImpl
implements StandardDbExportService {
    private static final Logger log = LoggerFactory.getLogger(StandardDbExportServiceImpl.class);
    private final String dbVersion = "2.0";
    @Resource
    private DbExportDao dbExportDao;
    @Resource
    private Environment environment;
    @Resource
    private FlightTaskDao flightTaskDao;
    @Resource
    private CgkRestService cgkRestService;
    @Resource
    private FczxRestService fczxRestService;
    @Resource
    private AirportAccessProperties accessProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDb(StandardExport param) {
        String base = Path.joinPath((String)"/", (String[])new String[]{System.getProperty("user.dir"), "standard/export", param.getId()});
        if (!FileUtil.exist((String)base)) {
            FileUtil.mkdir((String)base);
        }
        String dbFile = base + "/" + DateUtil.format((Date)param.getPkgTime(), (String)"yyyyMMddHHmmss") + ".db";
        boolean flag = this.createTableStruct(dbFile);
        String error = "";
        HashSet<String> set = new HashSet<String>();
        String objectKey = this.accessProperties.getObjectDirPrefix() + "/" + param.getId() + ".db";
        try {
            if (flag) {
                List<DbResultItem> attaches = this.obtainResultData(param, set);
                if (attaches != null && !attaches.isEmpty()) {
                    flag = this.insertDbData(dbFile, attaches);
                    if (flag) {
                        OpRes<Boolean> res = this.fczxRestService.uploadCloudExif(objectKey, dbFile, MapUtil.empty());
                        if (!res.isOpRes()) {
                            error = res.getErrorDesc();
                        }
                    } else {
                        error = "\u63d2\u5165FJ\u8868\u6570\u636e\u5931\u8d25";
                    }
                } else {
                    error = "\u672a\u627e\u5230\u76f8\u5173\u9644\u4ef6\u6570\u636e";
                }
            } else {
                error = "\u521b\u5efaFJ\u8868\u5931\u8d25";
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            error = "\u751f\u6210DB\u6210\u679c\u5305\u5f02\u5e38\uff1a" + e.getMessage();
        }
        finally {
            FileUtil.del((String)base);
        }
        this.dbExportUpdate(param.getId(), error, ObjectUtil.isEmpty((Object)error) ? "2" : "3", ObjectUtil.isEmpty((Object)error) ? objectKey : null, set);
    }

    private boolean generateDBInfo(Connection connection) {
        PreparedStatement statement = null;
        try {
            String DB_INFO_SQL = "insert into DB_INFO(version,createtime,updatetime,createuser,description) values(?,?,?,?,?)";
            statement = connection.prepareStatement(DB_INFO_SQL);
            statement.setString(1, "2.0");
            statement.setString(2, DateUtil.formatDateTime((Date)new Date()));
            statement.setString(3, DateUtil.formatDateTime((Date)new Date()));
            statement.setString(4, "fczx");
            statement.setString(5, "");
            statement.executeUpdate();
            connection.commit();
            statement.close();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6570\u636e\u5e93\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean generateJMXX(Connection connection) {
        PreparedStatement statement = null;
        try {
            String JMXX_SQL = "insert into JMXX(ZSDM, SZZS, ZSBFJGDM, ZSBFJGGY) values(?,?,?,?)";
            statement = connection.prepareStatement(JMXX_SQL);
            statement.setString(1, this.accessProperties.getLicenseCode());
            statement.setString(2, this.accessProperties.getLicense());
            statement.setString(3, this.accessProperties.getLicenseOrgan());
            statement.setString(4, this.accessProperties.getLicensePublicKey());
            statement.executeUpdate();
            connection.commit();
            statement.close();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u52a0\u5bc6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean generateFJ(Connection connection, List<DbResultItem> attaches) {
        PreparedStatement statement = null;
        try {
            String FJ_SQL = "insert into FJ(BSM,DKLX,DKBSM,XZQDM,FJMC,FJLX,PSTZ,FJ,FJHXZ,PSSJ,XDGD,JDGD,Longitude,Latitude,PSFYJ,PSJD,PSHGJ,PSJJ,FJYSKD,FJYSGD,PSRY,SPKZXX,ZSDM,JYM,ZDKBH,PSDXZXX) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            statement = connection.prepareStatement(FJ_SQL);
            for (int i = 0; i < attaches.size(); ++i) {
                this.makeFJPre(statement, attaches.get(i), i + 1);
                if (i % 500 != 0) continue;
                statement.executeBatch();
                statement.clearBatch();
            }
            statement.executeBatch();
            statement.clearBatch();
            connection.commit();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertDbData(String file, List<DbResultItem> attaches) {
        Connection connection = null;
        try {
            connection = SqlLiteConnTool.getConnection(file, this.accessProperties.getDbExportPassword());
            connection.setAutoCommit(false);
            this.generateFJ(connection, attaches);
            this.generateDBInfo(connection);
            this.generateJMXX(connection);
        }
        catch (Exception e) {
            boolean bl;
            try {
                log.error("\u63d2\u5165\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                SqlLiteConnTool.closeConnection(connection, null);
                throw throwable;
            }
            SqlLiteConnTool.closeConnection(connection, null);
            return bl;
        }
        SqlLiteConnTool.closeConnection(connection, null);
        return true;
    }

    private void makeFJPre(PreparedStatement statement, DbResultItem dbResultItem, int row) throws Exception {
        log.debug("\u5b58\u5165\u6570\u636e{}", (Object)dbResultItem);
        statement.setString(1, String.valueOf(row));
        statement.setString(2, dbResultItem.getDKLX());
        statement.setString(3, dbResultItem.getDKBSM());
        statement.setString(4, dbResultItem.getXZQDM());
        statement.setString(5, dbResultItem.getFJMC());
        statement.setString(6, dbResultItem.getFJLX());
        statement.setString(7, dbResultItem.getPSTZ());
        statement.setBytes(8, dbResultItem.getFJ());
        statement.setString(9, dbResultItem.getFJHXZ());
        statement.setString(10, dbResultItem.getPSSJ());
        statement.setDouble(11, dbResultItem.getXDGD());
        statement.setDouble(12, dbResultItem.getJDGD());
        statement.setDouble(13, dbResultItem.getLongitude());
        statement.setDouble(14, dbResultItem.getLatitude());
        statement.setInt(15, dbResultItem.getPSFYJ());
        statement.setInt(16, dbResultItem.getPSJD());
        statement.setInt(17, dbResultItem.getPSHGJ());
        statement.setInt(18, dbResultItem.getPSJJ());
        statement.setInt(19, dbResultItem.getFJYSKD());
        statement.setInt(20, dbResultItem.getFJYSGD());
        statement.setString(21, AirportTool.fmtCloudArtist(dbResultItem.getPSRY()));
        statement.setString(22, dbResultItem.getSPKZXX());
        statement.setString(23, dbResultItem.getZSDM());
        statement.setString(24, dbResultItem.getJYM());
        statement.setString(25, dbResultItem.getZDKBH());
        statement.setString(26, dbResultItem.getPSDXZXX());
        statement.addBatch();
    }

    private List<DbResultItem> obtainResultData(StandardExport param, Set<String> taskIds) {
        ArrayList<DbResultItem> list = new ArrayList<DbResultItem>();
        List<GwTaskInfo> tasks = this.flightTaskDao.findTasks(param.convertMap());
        if (tasks == null || tasks.isEmpty()) {
            log.error("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u6210\u679c\u4fe1\u606f{}", (Object)param);
            return null;
        }
        for (GwTaskInfo task : tasks) {
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{task.getPhotos(), task.getAttachs(), task.getTbIds()}) && ObjectUtil.equal((Object)task.getPhotos().size(), (Object)task.getAttachs().size())) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("namespaceId", param.getNamespaceId());
                args.put("list", Arrays.asList(task.getTbIds().split(",")));
                Map<String, TaskSpot> spots = this.flightTaskDao.findTaskSpots(args);
                for (int i = 0; i < task.getAttachs().size(); ++i) {
                    JSONObject attach = task.getAttachs().get(i);
                    JSONObject photo = task.getPhotos().get(i);
                    JSONArray linkTbIds = (JSONArray)photo.getByPath("photoPoints[0].linkTbIds", JSONArray.class);
                    if (linkTbIds == null || linkTbIds.isEmpty() || !spots.containsKey((String)linkTbIds.get(0))) continue;
                    String objectKey = (String)attach.getByPath("file.object_key", String.class);
                    try {
                        TaskSpot spot = spots.get((String)linkTbIds.get(0));
                        OpRes<JSONObject> res = this.fczxRestService.readAttachExif(objectKey);
                        if (!res.isOpRes() || !ObjectUtil.isNotEmpty((Object)res.getData())) continue;
                        CloudExifBuild exif = AirportTool.buildCloudExif((JSONObject)res.getData(), this.accessProperties.getLicenseCode());
                        String path = AirportTool.getCloudSecretName(objectKey);
                        String httpUrl = this.accessProperties.getDroneServerUrl() + "/api/files/v1/original?objectKey=" + path;
                        byte[] content = AirportTool.getHttpFileContent(httpUrl, FileUtil.getName((String)path));
                        DbResultItem dbResultItem = new DbResultItem(exif);
                        dbResultItem.setFJ(content);
                        dbResultItem.setBSM(spot.getBsm());
                        dbResultItem.setDKLX(spot.getDlmc());
                        dbResultItem.setDKBSM(spot.getBsm());
                        dbResultItem.setZDKBH(spot.getBsm());
                        dbResultItem.setFJHXZ(SM3Utils.sm3((byte[])content));
                        if (ObjectUtil.isNotEmpty((Object)spot.getZldwdm())) {
                            if (spot.getZldwdm().length() > 6) {
                                dbResultItem.setXZQDM(spot.getZldwdm().substring(0, 6));
                            } else {
                                dbResultItem.setXZQDM(spot.getZldwdm());
                            }
                        }
                        dbResultItem.setPSTZ("T");
                        dbResultItem.setFJMC(FileUtil.getName((String)path));
                        dbResultItem.setFJLX(ObjectUtil.notEqual((Object)"pano", (Object)((JSONObject)res.getData()).get((Object)"Windows XP Keywords")) ? "1" : "3");
                        dbResultItem.setJYM(AirportTool.generateCloudCode(this.accessProperties.getLicenseSecret(), exif.concatKeyword(dbResultItem.getFJHXZ())));
                        list.add(dbResultItem);
                        taskIds.add(task.getJobId());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u6784\u5efa\u9644\u4ef6\u4fe1\u606f{}\u5931\u8d25", (Object)objectKey, (Object)e);
                    }
                }
                continue;
            }
            log.error("\u9644\u4ef6\u4fe1\u606f\u672a\u627e\u5230/\u4efb\u52a1\u56fe\u6591\u4fe1\u606f\u672a\u627e\u5230{}", (Object)task.getJobId());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTableStruct(String file) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SqlLiteConnTool.getConnection(file, this.accessProperties.getDbExportPassword());
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            String FJ_SQL = "create table FJ(BSM text(50), DKLX text(20), DKBSM text(50), ZDKBH text(50), XZQDM text(6), FJMC text(100), FJLX text(1),  PSTZ text(1), FJ blob, FJHXZ text(64), PSSJ text(20), XDGD real, JDGD real, Longitude real, Latitude real, PSFYJ INTEGER,  PSJD INTEGER, PSHGJ INTEGER, PSJJ INTEGER, FJYSKD INTEGER, FJYSGD INTEGER, PSDXZXX text, PSRY text(50), SPKZXX text, ZSDM text(32), JYM text(150))";
            statement.executeUpdate(FJ_SQL);
            String JMXX_SQL = "create table JMXX(ZSDM text(32), SZZS text(800), ZSBFJGDM text(18), ZSBFJGGY text(255))";
            statement.executeUpdate(JMXX_SQL);
            String DB_INFO_SQL = "create table DB_INFO (version text(10), createtime text(20), updatetime text(20), createuser text(50), description text(255))";
            statement.executeUpdate(DB_INFO_SQL);
            connection.commit();
        }
        catch (Exception e) {
            boolean bl;
            try {
                log.error("\u751f\u6210\u9644\u4ef6\u8868\u5f02\u5e38", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                SqlLiteConnTool.closeConnection(connection, statement);
                throw throwable;
            }
            SqlLiteConnTool.closeConnection(connection, statement);
            return bl;
        }
        SqlLiteConnTool.closeConnection(connection, statement);
        return true;
    }

    @Override
    public String dbExportGenerate(StandardExport param) {
        param.setId(IdUtil.fastSimpleUUID());
        param.setPkgTime(new Date());
        this.dbExportDao.saveDbExport(param);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> this.generateDb(param));
        return param.getId();
    }

    @Override
    public List<DbExport> dbExportList(String namespaceId, Integer type) {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("namespaceId", namespaceId);
        query.put("type", type);
        return this.dbExportDao.findExportsByNsId(query);
    }

    @Override
    public String dbExportRemove(String id) {
        DbExport export = this.dbExportDao.findExportById(id);
        if (export == null) {
            return "\u672a\u627e\u5230\u6253\u5305\u6210\u679c\u4fe1\u606f";
        }
        if (ObjectUtil.equal((Object)export.getStatus(), (Object)1)) {
            return "\u6b63\u5728\u6253\u5305\u4e0d\u80fd\u88ab\u5220\u9664";
        }
        this.dbExportDao.deleteDbExport(id);
        return null;
    }

    @Override
    public boolean dbExportUpdate(String id, String error, String status, String objectKey, Set<String> jobIds) {
        return this.dbExportDao.updateDbExport(new DbExport(id, status, error, objectKey, jobIds)) > 0;
    }

    @Override
    public OpRes<String> dbExportDownload(String id) {
        DbExport export = this.dbExportDao.findExportById(id);
        if (export == null || ObjectUtil.isEmpty((Object)export.getObjectKey())) {
            return new OpRes("\u672a\u627e\u5230\u6253\u5305\u6210\u679c\u4fe1\u606f", null, false);
        }
        String url = this.accessProperties.getDroneOutSideUrl() + "/api/files/v1/original?objectKey=" + export.getObjectKey();
        return new OpRes("", (Object)url, true);
    }

    @Override
    public Object pushCgkConfig(Boolean detail) {
        if (BooleanUtil.isTrue((Boolean)detail)) {
            return BeanUtil.beanToMap((Object)this.accessProperties, (String[])new String[]{"cgkPushServerUrl", "cgkPushTokenKey", "cgkBizType", "cgkBizId", "cgkBizName", "cgkRegionCode"});
        }
        return ObjectUtil.isNotEmpty((Object)this.accessProperties.getCgkPushServerUrl());
    }

    @Override
    public OpRes<String> pushCgk(String jobId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{this.accessProperties.getCgkPushServerUrl()})) {
            String token = this.cgkRestService.generateToken(this.accessProperties.getLicenseCode(), this.accessProperties.getLicenseSecret());
            if (ObjectUtil.isEmpty((Object)token)) {
                return new OpRes("\u751f\u6210\u6210\u679c\u5e93\u8c03\u7528token\u5931\u8d25", null, false);
            }
            List<GwTaskInfo> tasks = this.flightTaskDao.findTasks(MapUtil.of((Object)"jobIds", Collections.singletonList(jobId)));
            if (tasks == null || tasks.isEmpty()) {
                return new OpRes("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u4fe1\u606f\u6216\u4efb\u52a1\u672a\u5b8c\u6210", null, false);
            }
            ArrayList<CgkPushItem> items = new ArrayList<CgkPushItem>();
            String endpoint = this.environment.getProperty("com.geoway.fczx.obs.endpoint", "");
            String bucket = this.environment.getProperty("com.geoway.fczx.obs.bucket", "");
            String downloadUrl = ObjectUtil.isEmpty((Object)this.accessProperties.getDroneOutSideUrl()) ? null : this.accessProperties.getDroneOutSideUrl() + (this.accessProperties.getCgkUseObsUrl() != false ? "/api/files/v1/redirect?objectKey=" : "/api/files/v1/original?objectKey=");
            for (GwTaskInfo task : tasks) {
                List<CgkPushItem> list;
                Map<String, TaskFileInfo> files = this.flightTaskDao.findTaskFileMetas(jobId);
                if (ObjectUtil.isNotEmpty(files)) {
                    files.values().removeIf(e -> !ObjectUtil.contains(Arrays.asList("jpeg", "jpg"), (Object)FileUtil.getSuffix((String)e.getName())));
                    files.values().forEach(e -> items.add(e.convertCgkItem(task.getJobId(), task.getJobName(), task.getDevice().getStr((Object)"childSn", "geoway"), task.getUsername(), this.accessProperties.getCgkBizType(), this.accessProperties.getCgkBizId(), this.accessProperties.getCgkBizName(), this.accessProperties.getCgkRegionCode(), this.accessProperties.getLicenseCode(), this.accessProperties.getCgkUseObsUrl(), downloadUrl, endpoint, bucket, this.accessProperties.getResWidth(), this.accessProperties.getResHeight())));
                    continue;
                }
                if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{task.getPhotos(), task.getAttachs(), task.getDevice()}) || !ObjectUtil.isNotEmpty(list = task.convertCgkItem(task.getJobId(), task.getJobName(), task.getDevice().getStr((Object)"childSn", "geoway"), task.getUsername(), this.accessProperties.getCgkBizType(), this.accessProperties.getCgkBizId(), this.accessProperties.getCgkBizName(), this.accessProperties.getCgkRegionCode(), this.accessProperties.getLicenseCode(), this.accessProperties.getCgkUseObsUrl(), downloadUrl, endpoint, bucket, this.accessProperties.getResWidth(), this.accessProperties.getResHeight()))) continue;
                items.addAll(list);
            }
            items.removeIf(ObjectUtil::isEmpty);
            if (ObjectUtil.isEmpty(items)) {
                return new OpRes("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u6210\u679c\u4fe1\u606f", null, false);
            }
            String id = IdUtil.randomUUID();
            OpRes<JSONObject> res = this.cgkRestService.multiAdd(this.accessProperties.getCgkPushServerUrl(), this.accessProperties.getCgkPushTokenKey(), token, items);
            if (res.isOpRes()) {
                StandardExport export = new StandardExport(id);
                export.setNamespaceId(tasks.get(0).getNamespaceId());
                export.setPkgTime(new Date());
                export.setJobIds(jobId);
                export.setType(1);
                this.dbExportDao.saveDbExport(export);
            }
            return new OpRes(res.getErrorDesc(), (Object)id, res.isOpRes());
        }
        return new OpRes("\u6210\u679c\u63a8\u9001\u6210\u679c\u5e93\u5171\u4eab\u4e2d\u5fc3\u5730\u5740\u672a\u77e5", null, false);
    }
}

