/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.thirdapi.cloud;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.drew.lang.annotations.NotNull;
import com.geoway.fczx.airport.data.CgkPushItem;
import com.geoway.ue.common.data.response.OpRes;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CgkRestService {
    private static final Logger log = LoggerFactory.getLogger(CgkRestService.class);
    @Resource
    private RestTemplate cgkApiRest;
    private static final String multiAddUrl = "/artifact/api/media/v1/third/items";

    public OpRes<JSONObject> multiAdd(String server, String key, String token, List<CgkPushItem> params) {
        try {
            log.debug("{}", (Object)JSONUtil.toJsonPrettyStr(params));
            if (ObjectUtil.isEmpty((Object)server)) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = server.concat(multiAddUrl);
            HttpHeaders headers = new HttpHeaders();
            headers.add(key, token);
            ResponseEntity response = this.cgkApiRest.exchange(url, HttpMethod.POST, new HttpEntity(params, (MultiValueMap)headers), JSONObject.class, new Object[]{params});
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u6210\u679c\u5e93\u591a\u4e2a\u9644\u4ef6\u65b0\u589e\u63a5\u53e3,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes("\u6210\u679c\u5e93\u591a\u4e2a\u9644\u4ef6\u65b0\u589e\u63a5\u53e3\u5f02\u5e38" + e.getMessage(), null, false);
        }
    }

    public String generateToken(String certCode, String privateKey) {
        long a = System.currentTimeMillis();
        String c = certCode + a;
        byte[] d = c.getBytes(StandardCharsets.UTF_8);
        byte[] e = SmUtil.sm2((String)privateKey, null).sign(d);
        String f = Base64.getEncoder().encodeToString(e);
        return certCode + "." + a + "." + f;
    }

    private OpRes<JSONObject> dealResponse(@NotNull ResponseEntity<JSONObject> response) {
        JSONObject body = (JSONObject)response.getBody();
        if (response.getStatusCode().equals((Object)HttpStatus.OK) && body != null) {
            if (body.getBool((Object)"status").booleanValue()) {
                return new OpRes("", (Object)body, true);
            }
            return new OpRes(body.getStr((Object)"msg"), null, false);
        }
        return new OpRes(response.getStatusCode().getReasonPhrase(), null, false);
    }
}

