/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.thirdapi.cloud;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.drew.lang.annotations.NotNull;
import com.geoway.fczx.airport.data.property.CloudQueryProperties;
import com.geoway.fczx.airport.data.query.AddQueryInfo;
import com.geoway.fczx.airport.data.query.AddResultInfo;
import com.geoway.fczx.airport.util.JwtUtils;
import com.geoway.ue.common.data.response.OpRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CloudRestService {
    private static final Logger log = LoggerFactory.getLogger(CloudRestService.class);
    @Resource
    private RestTemplate queryApiRest;
    public static final String getToken = "/cloudQuery/v3/getToken";
    public static final String getQueryItems = "/cloudQuery/v3/getQueryItems";
    public static final String add = "/cloudQuery/v3/add";
    public static final String requestAgain = "/cloudQuery/v3/requestAgain";
    public static final String getRecordById = "/cloudQuery/v3/getRecordById";
    public static final String getRecordByRequestId = "/cloudQuery/v3/getRecordByRequestId";
    public static final String getRecordStateByRequestId = "/cloudQuery/v3/getRecordStateByRequestId";
    public static final String getRecordStateByRequestIds = "/cloudQuery/v3/getRecordStateByRequestIds";
    public static final String getRecordStateBytIds = "/cloudQuery/v3/getRecordStateBytIds";
    public static final String getDetailRecordById = "/cloudQuery/v3/getDetailRecordById";
    public static final String getResultJSON = "/cloudQuery/v3/getResultJSON";
    public static final String getShowHtml = "/cloudQuery/v3/getShowHtml";
    public static final String addResult = "/cloudQuery/result/addResult";

    public OpRes<JSONObject> getToken(CloudQueryProperties config) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("id", "1");
            params.put("time", -1);
            params.put("appkey", config.getAppKey());
            params.put("appsecret", config.getAppSecret());
            log.debug("\u83b7\u53d6\u63a5\u53e3\u8c03\u7528\u51ed\u636e, params={}", params);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getToken);
            ResponseEntity response = this.queryApiRest.getForEntity(this.dealGetUri(url, params), JSONObject.class, params);
            log.info("\u83b7\u53d6\u63a5\u53e3\u8c03\u7528\u51ed\u636e,params={},response={}", params, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u63a5\u53e3\u8c03\u7528\u51ed\u636e,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getQueryItems(CloudQueryProperties config) {
        JSONObject params = new JSONObject();
        try {
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getQueryItems);
            ResponseEntity response = this.queryApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(config, (Map)params), JSONObject.class, (Map)params);
            log.debug("\u83b7\u53d6\u4e91\u67e5\u8be2\u9879\u5217\u8868,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u9879\u5217\u8868,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", (Object)params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> add(CloudQueryProperties config, AddQueryInfo data) {
        try {
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(add);
            ResponseEntity response = this.queryApiRest.exchange(url, HttpMethod.POST, this.buildHttpParams(config, (Map)data.transferObject(config)), JSONObject.class, new Object[0]);
            log.debug("\u63d0\u4ea4\u4e91\u67e5\u8be2\u8bf7\u6c42,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u4e91\u67e5\u8be2\u8bf7\u6c42,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", (Object)data, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> requestAgain(CloudQueryProperties config, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("id", id);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(requestAgain);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u91cd\u65b0\u67e5\u8be2\u63a5\u53e3,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u91cd\u65b0\u67e5\u8be2\u63a5\u53e3,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getRecordById(CloudQueryProperties config, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("id", id);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getRecordById);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getRecordByRequestId(CloudQueryProperties config, String requestId, String analyzeType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("requestId", requestId);
            params.put("analyzeType", analyzeType);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getRecordByRequestId);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getRecordStateByRequestId(CloudQueryProperties config, String requestId, String analyzeType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("requestId", requestId);
            params.put("analyzeType", analyzeType);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getRecordStateByRequestId);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getRecordStateByRequestIds(CloudQueryProperties config, String requestIds, String analyzeType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("requestIds", requestIds);
            params.put("analyzeType", analyzeType);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getRecordStateByRequestIds);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getRecordStateBytIds(CloudQueryProperties config, String ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("ids", ids);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getRecordStateBytIds);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u67e5\u8be2\u8bb0\u5f55,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getDetailRecordById(CloudQueryProperties config, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("id", id);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getDetailRecordById);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6db\u89e3\u6790\u7ed3\u679c,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6db\u89e3\u6790\u7ed3\u679c,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getResultJSON(CloudQueryProperties config, String requestId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("requestId", requestId);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getResultJSON);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6db\u89e3\u6790\u7ed3\u679c,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6db\u89e3\u6790\u7ed3\u679c,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> getShowHtml(CloudQueryProperties config, String requestId, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("requestId", requestId);
            params.put("type", type);
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(getShowHtml);
            ResponseEntity response = this.queryApiRest.exchange(this.dealGetUri(url, params), HttpMethod.GET, this.buildHttpParams(config, params), JSONObject.class, params);
            log.debug("\u83b7\u53d6web\u7aef\u9ed8\u8ba4\u5c55\u793a\u9875\u9762,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6web\u7aef\u9ed8\u8ba4\u5c55\u793a\u9875\u9762,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", params, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    public OpRes<JSONObject> addResult(CloudQueryProperties config, AddResultInfo data) {
        try {
            if (ObjectUtil.isEmpty((Object)config.getServer())) {
                return new OpRes("\u4e91\u67e5\u8be2\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u672a\u77e5", null, false);
            }
            String url = config.getServer().concat(addResult);
            ResponseEntity response = this.queryApiRest.postForEntity(url, this.buildHttpParams(config, (Map)data.transferObject()), JSONObject.class, new Object[0]);
            log.debug("\u83b7\u53d6web\u7aef\u9ed8\u8ba4\u5c55\u793a\u9875\u9762,url={},response={}", (Object)url, (Object)response);
            return this.dealResponse((ResponseEntity<JSONObject>)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6web\u7aef\u9ed8\u8ba4\u5c55\u793a\u9875\u9762,params={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f", (Object)data, (Object)e);
            return new OpRes(e.getMessage(), null, false);
        }
    }

    private String dealGetUri(@NotNull String uri, Map<String, Object> params) {
        if (ObjectUtil.isNotEmpty(params)) {
            uri = uri.concat("?");
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : params.keySet()) {
                keys.add(key.concat("={").concat(key).concat("}"));
            }
            uri = uri.concat(String.join((CharSequence)"&", keys));
        }
        return uri;
    }

    private OpRes<JSONObject> dealResponse(@NotNull ResponseEntity<JSONObject> response) {
        JSONObject body = (JSONObject)response.getBody();
        if (response.getStatusCode().equals((Object)HttpStatus.OK) && body != null) {
            if (ObjectUtil.equal((Object)body.getInt((Object)"code"), (Object)200)) {
                return new OpRes("", (Object)body, true);
            }
            return new OpRes(body.getStr((Object)"message"), null, false);
        }
        return new OpRes("", null, false);
    }

    private HttpEntity<Map<String, Object>> buildHttpParams(CloudQueryProperties properties, Map params) {
        String token = JwtUtils.createJWT("1", properties.getAppKey(), properties.getAppSecret(), -1L);
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.add("appkey", properties.getAppKey());
        if (params instanceof MultiValueMap) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        return new HttpEntity((Object)params, (MultiValueMap)headers);
    }

    public <T> T resolveResult(OpRes<JSONObject> result, Class<T> clazz) {
        return (T)((JSONObject)result.getData()).getBean((Object)"data", clazz);
    }
}

