/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.thirdapi.fczx;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.fczx.airport.data.property.AirportAccessProperties;
import com.geoway.fczx.airport.data.property.NamespaceProperties;
import com.geoway.ue.common.data.response.OpRes;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class FczxRestService {
    private static final Logger log = LoggerFactory.getLogger(FczxRestService.class);
    @Resource
    private RestTemplate fczxApiRest;
    @Resource
    private AirportAccessProperties accessConfig;
    @Value(value="${com.geoway.fczx.show-original: true}")
    private boolean showOriginal;
    private static final String createNsUrl = "/api/namespaces/v1/info";
    private static final String createNsUrl2 = "/api/namespaces/v1/info/put";
    private static final String makeFlightUrl = "/api/waylines/v1/make/job";
    private static final String undoFlightUrl = "/api/waylines/v1/cancel/job?jobId=";
    private static final String undoFlightUrl2 = "/api/waylines/v1/cancel/job/delete?jobId=";
    private static final String importSpotUrl = "/api/spots/v1/insert/batch";
    private static final String uploadCloudUrl = "/api/files/v1/upload";
    private static final String buildThumbUrl = "/api/files/v1/thumbnail?objectKey={objectKey}&height={height}&width={width}";
    private static final String readExifUrl = "/api/files/v1/exif?objectKey={objectKey}";
    public static final String downResultUrl = "/api/files/v1/original?objectKey=";
    public static final String obsResultUrl = "/api/files/v1/redirect?objectKey=";

    public OpRes<String> createICloudNs(NamespaceProperties namespace) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", namespace.getName());
        params.put("alias", namespace.getNsId());
        params.put("namespaceId", namespace.getNsId());
        params.put("description", namespace.getDesc());
        params.put("workspaceId", namespace.getWorkspaceId());
        String url = this.getDroneServerUrl().concat(this.showOriginal ? createNsUrl : createNsUrl2);
        ResponseEntity res = this.fczxApiRest.exchange(url, this.showOriginal ? HttpMethod.PUT : HttpMethod.POST, new HttpEntity(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u521b\u5efa\u8c03\u67e5\u4e91\u9879\u76ee\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String nsId = (String)objectMapper.readValue((String)res.getBody(), String.class);
            return new OpRes(null, (Object)nsId, true);
        }
        catch (Exception e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u9879\u76ee\u6807\u8bc6\u9519\u8bef");
            return new OpRes("\u53cd\u5e8f\u5217\u5316\u9879\u76ee\u6807\u8bc6\u9519\u8bef", null, false);
        }
    }

    public OpRes<JSONObject> makeFlightTask(NamespaceProperties namespace, String name, List<String> bsm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", bsm);
        params.put("name", name);
        params.put("namespaceId", namespace.getNsId());
        String url = this.getDroneServerUrl().concat(makeFlightUrl);
        ResponseEntity res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u751f\u6210\u822a\u7ebf\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)JSONUtil.parseObj((String)((String)res.getBody())), true);
    }

    public OpRes<JSONObject> readAttachExif(String objectKey) {
        String url = this.getDroneServerUrl().concat(readExifUrl);
        ResponseEntity res = this.fczxApiRest.getForEntity(url, String.class, new Object[]{objectKey});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u8bfb\u53d6\u9644\u4ef6\u3010{}\u3011Exif\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)objectKey, (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)JSONUtil.parseObj((String)((String)res.getBody())), true);
    }

    public OpRes<InputStream> buildCloudThumb(String objectKey, Map<String, Object> meta) {
        meta.put("objectKey", objectKey);
        String url = this.getDroneServerUrl().concat(buildThumbUrl);
        ResponseEntity res = this.fczxApiRest.getForEntity(url, byte[].class, meta);
        if (ObjectUtil.notEqual((Object)res.getStatusCode(), (Object)HttpStatus.OK) || res.getBody() == null) {
            log.error("\u751f\u6210\u8c03\u67e5\u4e91\u7f29\u7565\u56fe{}\uff1a{}", (Object)objectKey, (Object)res);
            return new OpRes(JSONUtil.parseObj((Object)res.getBody()).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)new ByteArrayInputStream((byte[])res.getBody()), true);
    }

    public OpRes<Boolean> cancelFlightTask(String taskid) {
        String url = this.getDroneServerUrl().concat(this.showOriginal ? undoFlightUrl : undoFlightUrl2).concat(taskid);
        ResponseEntity res = this.fczxApiRest.exchange(url, this.showOriginal ? HttpMethod.DELETE : HttpMethod.POST, new HttpEntity(null), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u751f\u6210\u822a\u7ebf\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), (Object)false, false);
        }
        return new OpRes(null, (Object)true, true);
    }

    public OpRes<Boolean> importSpotData(NamespaceProperties namespace, List<Map<String, Object>> spots) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spots", spots);
        params.put("namespaceId", namespace.getNsId());
        String url = this.getDroneServerUrl().concat(importSpotUrl);
        ResponseEntity res = this.fczxApiRest.postForEntity(url, (Object)new HttpEntity(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u5bfc\u5165\u56fe\u6591\u6570\u636e\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), (Object)false, false);
        }
        return new OpRes(null, (Object)true, true);
    }

    public OpRes<Boolean> uploadCloudExif(String objectKey, String file, Map<String, Object> meta) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.setAll(meta);
        body.add((Object)"file", (Object)new FileSystemResource(file));
        body.add((Object)"objectKey", (Object)objectKey);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity param = new HttpEntity((Object)body, (MultiValueMap)headers);
        String url = this.getDroneServerUrl().concat(uploadCloudUrl);
        ResponseEntity res = this.fczxApiRest.postForEntity(url, (Object)param, String.class, new Object[]{objectKey});
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u81f3OBS\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes("\u5931\u8d25:" + JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), (Object)false, false);
        }
        return new OpRes(null, (Object)true, true);
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        return ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK);
    }

    private String getDroneServerUrl() {
        if (ObjectUtil.isEmpty((Object)this.accessConfig.getDroneServerUrl())) {
            return System.getProperty("com.geoway.fczx.airport.drone-server-url");
        }
        return this.accessConfig.getDroneServerUrl();
    }
}

