/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.json.JSONObject;
import cn.org.landcloud.security.sm2.SM2SignVerUtils;
import cn.org.landcloud.security.sm3.SM3Utils;
import com.geoway.fczx.airport.data.CloudExifBuild;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Date;
import org.apache.logging.log4j.util.Base64Util;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirportTool {
    private static final Logger log = LoggerFactory.getLogger(AirportTool.class);

    public static String fmtCloudLngLat(Double number) {
        return String.format("%.7f", number);
    }

    public static String fmtCloudHeight(Double number) {
        return String.format("%.2f", number);
    }

    public static Double fmtCloudPsjd(Double number) {
        return number > 0.0 ? number : number + 360.0;
    }

    public static String fmtCloudCreate(String time) {
        DateTime date = DateUtil.parse((CharSequence)time, (String)"yyyy:MM:dd HH:mm:ss");
        return DateUtil.formatDateTime((Date)date);
    }

    public static String fmtCloudCreate2(String time) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return OffsetDateTime.parse(time, inputFormatter).format(outputFormatter);
    }

    public static String fmtCloudArtist(String psry) {
        byte[] data = Base64.getDecoder().decode(psry);
        return new String(data);
    }

    public static String getCloudSecretName(String objectKey) {
        String suffix = ".jpeg";
        return objectKey.replace(suffix, "_CLOUD" + suffix);
    }

    public static CloudExifBuild buildCloudExif(JSONObject data, String license) {
        return CloudExifBuild.builder().version("0230").latitude(Double.parseDouble(AirportTool.fmtCloudLngLat(data.getDouble((Object)"drone-dji:GpsLatitude")))).longitude(Double.parseDouble(AirportTool.fmtCloudLngLat(data.getDouble((Object)"drone-dji:GpsLongitude")))).xdgd(Double.parseDouble(AirportTool.fmtCloudHeight(data.getDouble((Object)"drone-dji:RelativeAltitude")))).jdgd(Double.parseDouble(AirportTool.fmtCloudHeight(data.getDouble((Object)"drone-dji:AbsoluteAltitude")))).psjd(AirportTool.fmtCloudPsjd(data.getDouble((Object)"drone-dji:GimbalYawDegree")).intValue()).psfyj(data.getDouble((Object)"drone-dji:GimbalPitchDegree").intValue()).pshgj(data.getDouble((Object)"drone-dji:GimbalRollDegree").intValue()).psry(Base64Util.encode((String)data.getStr((Object)"drone-dji:DroneSerialNumber", "geoway"))).zsdm(license).fjyskd(Integer.parseInt(data.getStr((Object)"Image Width").replace(" pixels", ""))).fjysgd(Integer.parseInt(data.getStr((Object)"Image Height").replace(" pixels", ""))).psjj(Integer.parseInt(data.getStr((Object)"Focal Length 35").replace(" mm", ""))).pssj(AirportTool.fmtCloudCreate(data.getStr((Object)"Date/Time"))).bjbs(data.getDouble((Object)"Digital Zoom Ratio")).build();
    }

    public static String generateCloudCode(String secret, String keyword) {
        try {
            String sm3 = SM3Utils.sm3((String)keyword);
            return SM2SignVerUtils.Sign2SM2((byte[])ByteUtils.fromHexString((String)secret), (byte[])sm3.getBytes(StandardCharsets.UTF_8)).getSm2_signForHard().toUpperCase();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u56fd\u571f\u4e91\u9644\u4ef6\u6821\u9a8c\u7801\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getHttpFileContent(String httpUrl, String name) throws Exception {
        String tmp = System.getProperty("user.dir") + "/" + name;
        try {
            URL url = new URL(httpUrl);
            InputStream input = url.openStream();
            FileUtil.writeFromStream((InputStream)input, (String)tmp);
            input.close();
            byte[] byArray = FileUtil.readBytes((String)tmp);
            return byArray;
        }
        finally {
            FileUtil.del((String)tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRedirectUrl(String url) {
        URL href = null;
        HttpURLConnection conn = null;
        try {
            href = new URL(url);
            conn = (HttpURLConnection)href.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            int code = conn.getResponseCode();
            if (code > 300 && code < 400) {
                String string = conn.getHeaderField("Location");
                return string;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u91cd\u5b9a\u5411\u5730\u5740{}\u5931\u8d25{}", (Object)url, (Object)e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }
}

