/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.util;

import com.geoway.fczx.airport.util.ReferenceSystemUtil;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.Length;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.ProjCoordinate;

public class MeasureUtil {
    public static double calculateProjectionArea(String wkt) throws ParseException {
        Geometry sourceGeometry = new WKTReader().read(wkt);
        if (sourceGeometry instanceof Polygon) {
            return MeasureUtil.calculateProjectionArea((Polygon)sourceGeometry);
        }
        if (sourceGeometry instanceof MultiPolygon) {
            return MeasureUtil.calculateProjectionArea((MultiPolygon)sourceGeometry);
        }
        return 0.0;
    }

    public static double calculateProjectionLength(String wkt) throws ParseException {
        Geometry sourceGeometry = new WKTReader().read(wkt);
        if (sourceGeometry instanceof Polygon) {
            return MeasureUtil.calculateProjectionLength((Polygon)sourceGeometry);
        }
        if (sourceGeometry instanceof MultiPolygon) {
            return MeasureUtil.calculateProjectionLength((MultiPolygon)sourceGeometry);
        }
        if (sourceGeometry instanceof LineString) {
            return MeasureUtil.calculateProjectionLength((LineString)sourceGeometry);
        }
        if (sourceGeometry instanceof MultiLineString) {
            return MeasureUtil.calculateProjectionLength((MultiLineString)sourceGeometry);
        }
        return 0.0;
    }

    public static double calculateGeodesicArea(String wkt) throws ParseException {
        Geometry sourceGeometry = new WKTReader().read(wkt);
        if (sourceGeometry instanceof Polygon) {
            return MeasureUtil.calculateGeodesicArea((Polygon)sourceGeometry);
        }
        if (sourceGeometry instanceof MultiPolygon) {
            return MeasureUtil.calculateGeodesicArea((MultiPolygon)sourceGeometry);
        }
        return 0.0;
    }

    public static double calculateGeodesicLength(String wkt) throws ParseException {
        Geometry sourceGeometry = new WKTReader().read(wkt);
        if (sourceGeometry instanceof Polygon) {
            return MeasureUtil.calculateGeodesicLength((Polygon)sourceGeometry);
        }
        if (sourceGeometry instanceof MultiPolygon) {
            return MeasureUtil.calculateGeodesicLength((MultiPolygon)sourceGeometry);
        }
        if (sourceGeometry instanceof LineString) {
            return MeasureUtil.calculateGeodesicLength((LineString)sourceGeometry);
        }
        if (sourceGeometry instanceof MultiLineString) {
            return MeasureUtil.calculateGeodesicLength((MultiLineString)sourceGeometry);
        }
        return 0.0;
    }

    public static double calculateProjectionArea(Polygon polygon) {
        double centerLongitude = polygon.getInteriorPoint().getX();
        int srid = (int)Math.floor((centerLongitude + 1.5) / 3.0) - 25 + 4513;
        CoordinateTransform wgsToUtm = ReferenceSystemUtil.getCoordinateTransformBySrid(srid);
        if (wgsToUtm != null) {
            double sumArea = Area.ofRing((Coordinate[])MeasureUtil.projectCoords(wgsToUtm, polygon.getExteriorRing().getCoordinates()));
            for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
                sumArea -= Area.ofRing((Coordinate[])MeasureUtil.projectCoords(wgsToUtm, polygon.getInteriorRingN(j).getCoordinates()));
            }
            return sumArea;
        }
        return MeasureUtil.calculateGeodesicArea(polygon);
    }

    public static double calculateProjectionArea(MultiPolygon polygon) {
        double sumArea = 0.0;
        for (int i = 0; i < polygon.getNumGeometries(); ++i) {
            sumArea += MeasureUtil.calculateProjectionArea((Polygon)polygon.getGeometryN(i));
        }
        return sumArea;
    }

    public static double calculateProjectionLength(Polygon polygon) {
        double centerLongitude = polygon.getInteriorPoint().getX();
        int srid = (int)Math.floor((centerLongitude + 1.5) / 3.0) - 25 + 4513;
        CoordinateTransform wgsToUtm = ReferenceSystemUtil.getCoordinateTransformBySrid(srid);
        if (wgsToUtm != null) {
            CoordinateSequence seq = CoordinateArraySequenceFactory.instance().create(MeasureUtil.projectCoords(wgsToUtm, polygon.getExteriorRing().getCoordinates()));
            double sumLength = Length.ofLine((CoordinateSequence)seq);
            for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
                sumLength += Area.ofRing((Coordinate[])MeasureUtil.projectCoords(wgsToUtm, polygon.getInteriorRingN(j).getCoordinates()));
            }
            return sumLength;
        }
        return MeasureUtil.calculateGeodesicLength(polygon);
    }

    public static double calculateProjectionLength(LineString polyline) {
        double centerLongitude = polyline.getInteriorPoint().getX();
        int srid = (int)Math.floor((centerLongitude + 1.5) / 3.0) - 25 + 4513;
        CoordinateTransform wgsToUtm = ReferenceSystemUtil.getCoordinateTransformBySrid(srid);
        if (wgsToUtm != null) {
            CoordinateSequence seq = CoordinateArraySequenceFactory.instance().create(MeasureUtil.projectCoords(wgsToUtm, polyline.getCoordinates()));
            return Length.ofLine((CoordinateSequence)seq);
        }
        return MeasureUtil.calculateGeodesicLength(polyline);
    }

    public static double calculateProjectionLength(MultiPolygon polygon) {
        double sumArea = 0.0;
        for (int i = 0; i < polygon.getNumGeometries(); ++i) {
            sumArea += MeasureUtil.calculateProjectionLength((Polygon)polygon.getGeometryN(i));
        }
        return sumArea;
    }

    public static double calculateProjectionLength(MultiLineString polyline) {
        double sumArea = 0.0;
        for (int i = 0; i < polyline.getNumGeometries(); ++i) {
            sumArea += MeasureUtil.calculateProjectionLength((LineString)polyline.getGeometryN(i));
        }
        return sumArea;
    }

    public static double calculateGeodesicArea(Polygon polygon) {
        double sumArea = MeasureUtil.calculateGeodesicArea(polygon.getExteriorRing().getCoordinates());
        for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
            sumArea -= MeasureUtil.calculateGeodesicArea(polygon.getInteriorRingN(j).getCoordinates());
        }
        return sumArea;
    }

    public static double calculateGeodesicArea(MultiPolygon polygon) {
        double sumArea = 0.0;
        for (int i = 0; i < polygon.getNumGeometries(); ++i) {
            sumArea += MeasureUtil.calculateGeodesicArea((Polygon)polygon.getGeometryN(i));
        }
        return sumArea;
    }

    public static double calculateGeodesicLength(Polygon polygon) {
        double sumLength = MeasureUtil.calculateGeodesicLength(polygon.getExteriorRing().getCoordinates());
        for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
            sumLength += MeasureUtil.calculateGeodesicLength(polygon.getInteriorRingN(j).getCoordinates());
        }
        return sumLength;
    }

    public static double calculateGeodesicLength(LineString polyline) {
        double sumLength = MeasureUtil.calculateGeodesicLength(polyline.getCoordinates());
        return sumLength;
    }

    public static double calculateGeodesicLength(MultiPolygon polygon) {
        double sumArea = 0.0;
        for (int i = 0; i < polygon.getNumGeometries(); ++i) {
            sumArea += MeasureUtil.calculateGeodesicLength((Polygon)polygon.getGeometryN(i));
        }
        return sumArea;
    }

    public static double calculateGeodesicLength(MultiLineString polyline) {
        double sumArea = 0.0;
        for (int i = 0; i < polyline.getNumGeometries(); ++i) {
            sumArea += MeasureUtil.calculateGeodesicLength((LineString)polyline.getGeometryN(i));
        }
        return sumArea;
    }

    private static double calculateGeodesicArea(Coordinate[] coordinates) {
        Coordinate loc = coordinates[0];
        PosInfo[] temp = new PosInfo[coordinates.length];
        temp[0] = new PosInfo();
        int i = 0;
        for (i = 1; i < coordinates.length; ++i) {
            Coordinate loc1 = new Coordinate();
            temp[i] = new PosInfo();
            loc1.setX(coordinates[i].getX());
            loc1.setY(coordinates[0].getY());
            temp[i].mLon = MeasureUtil.computeDistanceAndBearing(loc1.y, loc1.x, loc.y, loc.x);
            if (loc1.x < loc.x) {
                temp[i].mLon *= -1.0;
            }
            loc1.setX(coordinates[0].getX());
            loc1.setY(coordinates[i].getY());
            temp[i].mLat = MeasureUtil.computeDistanceAndBearing(loc1.y, loc1.x, loc.y, loc.x);
            if (!(loc1.y < loc.y)) continue;
            temp[i].mLat *= -1.0;
        }
        double dArea = 0.0;
        for (i = 0; i < coordinates.length; ++i) {
            int j = i + 1;
            if (j == coordinates.length) {
                j = 0;
            }
            dArea += temp[i].mLon * temp[j].mLat - temp[i].mLat * temp[j].mLon;
        }
        if ((dArea /= 2.0) < 0.0) {
            dArea *= -1.0;
        }
        return dArea;
    }

    private static double calculateGeodesicLength(Coordinate[] coordinates) {
        double subLength = 0.0;
        for (int i = 0; i < coordinates.length - 1; ++i) {
            Coordinate loc1 = coordinates[i];
            Coordinate loc2 = coordinates[i + 1];
            double distance = Math.abs(MeasureUtil.computeDistanceAndBearing(loc2.y, loc2.x, loc1.y, loc1.x));
            subLength += distance;
        }
        return subLength;
    }

    private static double computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2) {
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double l = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double aA = 0.0;
        double u1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double u2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double cosU1 = Math.cos(u1);
        double cosU2 = Math.cos(u2);
        double sinU1 = Math.sin(u1);
        double sinU2 = Math.sin(u2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = l;
        for (int iter = 0; iter < 20; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            double sinSigma = Math.sqrt(sinSqSigma);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            double cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            aA = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double bB = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double cC = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = bB * sinSigma * (cos2SM + bB / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - bB / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = l + (1.0 - cC) * f * sinAlpha * (sigma + cC * sinSigma * (cos2SM + cC * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        return b * aA * (sigma - deltaSigma);
    }

    private static Coordinate[] projectCoords(CoordinateTransform wgsToUtm, Coordinate[] coords) {
        Coordinate[] projs = new Coordinate[coords.length];
        for (int j = 0; j < coords.length; ++j) {
            ProjCoordinate pp = new ProjCoordinate();
            wgsToUtm.transform(new ProjCoordinate(coords[j].x, coords[j].y), pp);
            projs[j] = new Coordinate(pp.x, pp.y);
        }
        return projs;
    }

    private static class PosInfo {
        double mLon;
        double mLat;

        private PosInfo() {
        }
    }
}

