/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.airport.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;

class ReferenceSystemUtil {
    private static ConcurrentMap<Integer, CoordinateTransform> coordinateTransformMap = new ConcurrentHashMap<Integer, CoordinateTransform>();

    ReferenceSystemUtil() {
    }

    public static CoordinateTransform getCoordinateTransformBySrid(int srid) {
        return (CoordinateTransform)coordinateTransformMap.get(srid);
    }

    static {
        CRSFactory crsFactory = new CRSFactory();
        CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
        CoordinateReferenceSystem cgs2000 = crsFactory.createFromName("epsg:4490");
        for (int i = 4513; i <= 4533; ++i) {
            CoordinateReferenceSystem UTM = crsFactory.createFromName("epsg:" + i);
            CoordinateTransform trans = ctFactory.createTransform(cgs2000, UTM);
            coordinateTransformMap.put(i, trans);
        }
    }
}

