/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.config;

import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.data.ImageUploadRes;
import com.geoway.fczx.dawn.data.property.DawnTransmitProperties;
import com.geoway.fczx.dawn.handler.ModelRebuildAsyncHandler;
import com.geoway.fczx.dawn.handler.VideoSpliceAsyncHandler;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@IgnoreLoad
@EnableAsync
@Configuration
public class ThreadPoolConfig
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);
    @Resource
    private DawnTransmitProperties transmitProperties;

    @Bean(value={"uploadThreadPool"})
    public CompletionService<ImageUploadRes> uploadCompletionService() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.transmitProperties.getUploadMaxThreadNum(), Executors.defaultThreadFactory());
        return new ExecutorCompletionService<ImageUploadRes>(executorService, new LinkedBlockingDeque(this.transmitProperties.getUploadQueueCapacity()));
    }

    @Bean(value={"videoSpliceExecutor"})
    public ThreadPoolTaskExecutor videoSpliceExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        taskExecutor.setThreadNamePrefix("video-splice-service-");
        taskExecutor.setMaxPoolSize(this.transmitProperties.getSpliceMaxThreadNum().intValue());
        taskExecutor.setCorePoolSize(this.transmitProperties.getSpliceCoreThreadNum().intValue());
        taskExecutor.setQueueCapacity(this.transmitProperties.getSpliceQueueCapacity().intValue());
        taskExecutor.setKeepAliveSeconds(this.transmitProperties.getKeepAliveSeconds().intValue());
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (throwable, method, objects) -> {
            if (method.equals(VideoSpliceAsyncHandler.class.getMethods()[0])) {
                log.debug("\u5f02\u6b65\u5f71\u50cf\u5feb\u62fc\u6267\u884c\u5931\u8d25", throwable);
            } else if (method.equals(ModelRebuildAsyncHandler.class.getMethods()[0])) {
                log.debug("\u5f02\u6b65\u6a21\u578b\u91cd\u5efa\u6267\u884c\u5931\u8d25", throwable);
            }
        };
    }
}

