/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.controller;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.dawn.DawnTransmitApp;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.handler.PackDownAsyncHandler;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6253\u5305\u4e0b\u8f7d\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DawnTransmitApp.class})
@RequestMapping(value={"/api/package/v1"})
public class PackDownController {
    @Autowired(required=false)
    private PackDownAsyncHandler packDownAsyncHandler;
    @Resource
    private ImageService imageService;

    @ApiOperation(value="\u521b\u5efa\u6253\u5305\u4efb\u52a1", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/create/task"})
    public ResponseEntity<BaseResponse> createTask(@RequestBody ImageUploadDto param) {
        if (param == null || ObjectUtil.isEmpty(param.getList()) || ObjectUtil.isEmpty((Object)param.getBizId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BooleanUtil.isTrue((Boolean)param.getAsync())) {
            this.packDownAsyncHandler.createPackDownAsync(param);
            return BaseResponse.ok();
        }
        boolean res = this.imageService.createPackageTask(param);
        return res ? BaseResponse.ok() : BaseResponse.error((String)"\u521b\u5efa\u6253\u5305\u4efb\u52a1\u5931\u8d25");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6253\u5305\u6210\u679c")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/download/result"})
    public void downloadResult(@RequestParam String bizId, HttpServletResponse response) {
        this.imageService.downloadPackageResult(bizId, response);
    }

    @ApiOperation(value="\u5220\u9664\u6210\u679c\u6587\u4ef6", notes="\u6a21\u578b\u6210\u679c&\u6253\u5305\u6210\u679c")
    @ApiOperationSupport(order=3)
    @DeleteMapping(value={"/remove/result"})
    public ResponseEntity<BaseResponse> removeResultFile(@RequestParam String bizId) {
        boolean flag = this.imageService.removeResultFile(bizId);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u6210\u679c\u6587\u4ef6\u5931\u8d25");
    }

    @ApiOperation(value="\u5220\u9664\u6210\u679c\u6587\u4ef6", notes="\u6a21\u578b\u6210\u679c&\u6253\u5305\u6210\u679c")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/remove/result/delete"})
    public ResponseEntity<BaseResponse> removeResultFile2(@RequestParam String bizId) {
        boolean flag = this.imageService.removeResultFile(bizId);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u6210\u679c\u6587\u4ef6\u5931\u8d25");
    }
}

