/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import com.geoway.fczx.dawn.DawnTransmitApp;
import com.geoway.fczx.dawn.data.RsmseCreateJob;
import com.geoway.fczx.dawn.data.RsmseJobStatus;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.dawn.RsmseRestService;
import com.geoway.fczx.dawn.util.TransmitTool;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8f6f\u4ef6\u5efa\u6a21\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DawnTransmitApp.class})
@RequestMapping(value={"/api/rsmse/v1"})
public class RsmseUavController {
    @Resource
    private RsmseRestService rsmseRestService;
    @Resource
    private ImageService imageService;

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/list/tasks"})
    public ResponseEntity<BaseResponse> listTasks(String workspaceId, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("workspaceId", workspaceId);
        OpRes<JSONArray> res = this.rsmseRestService.listTasks(map);
        return res.isOpRes() ? ObjectResponse.ok(res) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/query/task"})
    public ResponseEntity<BaseResponse> queryTask(@RequestParam String jobId) {
        if (ObjectUtil.isEmpty((Object)jobId)) {
            return BaseResponse.error((String)"jobId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<RsmseJobStatus> res = this.rsmseRestService.queryTask(jobId);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u521b\u5efa\u5efa\u6a21\u4efb\u52a1")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/create/task"})
    public ResponseEntity<BaseResponse> createTask(@RequestBody RsmseCreateJob data) {
        if (data != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{data.getDatas()})) {
            OpRes<String> res = this.rsmseRestService.createTask(data.convertMap());
            return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5efa\u6a21\u6210\u679c")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/download/result"})
    public void downloadResult(@RequestParam String jobId, HttpServletResponse response) {
        if (ObjectUtil.isEmpty((Object)jobId)) {
            ResponseEntity result = BaseResponse.error((String)"jobId\u4e0d\u80fd\u4e3a\u7a7a");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        } else {
            this.imageService.downloadRsmseResult(jobId, response);
        }
    }
}

