/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.controller;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.dawn.DawnTransmitApp;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.data.ImageUploadRes;
import com.geoway.fczx.dawn.data.ProcessModel;
import com.geoway.fczx.dawn.data.ProcessResult;
import com.geoway.fczx.dawn.data.ProcessTask;
import com.geoway.fczx.dawn.data.ProcessTaskStat;
import com.geoway.fczx.dawn.handler.VideoSpliceAsyncHandler;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.dawn.DawnRestService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f71\u50cf\u5feb\u62fc\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DawnTransmitApp.class})
@RequestMapping(value={"/api/transmit/v1"})
public class TransmitController {
    @Autowired(required=false)
    private VideoSpliceAsyncHandler spliceAsyncHandler;
    @Resource
    private DawnRestService dawnRestService;
    @Resource
    private ImageService imageService;

    @ApiOperation(value="\u521b\u5efa\u5f71\u50cf\u670d\u52a1", notes="\u9700\u8981\u7ecf\u8fc7\u7834\u6653\u5f15\u64ce\u5904\u7406")
    @ApiOperationSupport(order=1, includeParameters={"list", "bizId"})
    @PostMapping(value={"/video/service"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json"})
    public ResponseEntity<BaseResponse> videoService(@RequestBody Map<String, Object> param) {
        OpRes<String> res = this.dawnRestService.createTask(param);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/video/task"})
    public ResponseEntity<BaseResponse> queryVideoTask(String processId) {
        OpRes<ProcessTask> res = this.dawnRestService.queryTask(processId);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u5feb\u62fc\u6a21\u578b\u67e5\u8be2", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/video/model"})
    public ResponseEntity<BaseResponse> queryVideoModel(String modelId) {
        OpRes<ProcessModel> res = this.dawnRestService.queryMetadata(modelId);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u4efb\u52a1\u6210\u679c\u67e5\u8be2", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/video/result"})
    public ResponseEntity<BaseResponse> queryVideoResult(String processId) {
        OpRes<List<ProcessResult>> res = this.dawnRestService.queryResult(processId);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u4efb\u52a1\u72b6\u6001\u7edf\u8ba1", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/task/stat"})
    public ResponseEntity<BaseResponse> queryTaskStat(String processId) {
        OpRes<ProcessTaskStat> res = this.dawnRestService.queryTaskStat(processId);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u5f71\u50cf\u56fe\u7247\u4e0a\u4f20", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/upload/img"})
    public ResponseEntity<BaseResponse> imageUpload(@RequestBody ImageUploadDto param) {
        if (param == null || ObjectUtil.isEmpty(param.getList()) || ObjectUtil.isEmpty((Object)param.getBizId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpRes<List<ImageUploadRes>> res = this.imageService.imageUpload(param, null);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u521b\u5efa\u5feb\u62fc\u4efb\u52a1", produces="application/json;charset=UTF-8", consumes="application/json")
    @ApiOperationSupport(order=7, includeParameters={"list", "bizId"})
    @PostMapping(value={"/splice/task"})
    public ResponseEntity<BaseResponse> videoSplice(@RequestBody ImageUploadDto param) {
        if (param == null || ObjectUtil.isEmpty(param.getList()) || ObjectUtil.isEmpty((Object)param.getBizId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BooleanUtil.isTrue((Boolean)param.getAsync())) {
            this.spliceAsyncHandler.createSpliceVideoAsync(param);
            return BaseResponse.ok();
        }
        OpRes<String> res = this.imageService.videoSplice(param);
        return res.isOpRes() ? ObjectResponse.ok((Object)res.getData()) : BaseResponse.error((String)res.getErrorDesc());
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5feb\u62fc\u6210\u679c", notes="\u514d\u5904\u7406\u65f6\u4f20bizId")
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/download/result"})
    public void downloadResult(String processId, String bizId, HttpServletResponse response) {
        this.imageService.downloadResult(processId, bizId, response);
    }
}

