/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.handler;

import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.enmus.ProcessState;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import com.geoway.ue.common.data.response.OpRes;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@IgnoreLoad
@Component
public class ModelRebuildAsyncHandler {
    private static final Logger log = LoggerFactory.getLogger(ModelRebuildAsyncHandler.class);
    @Resource
    private ImageService imageService;
    @Resource
    private FczxRestService fczxRestService;

    @Async(value="videoSpliceExecutor")
    public void createModelRebuildAsync(ImageUploadDto data, String processId) {
        try {
            OpRes<String> opRes = this.imageService.createRebuildTask(data, processId);
            if (!opRes.isOpRes()) {
                log.error("{}", (Object)opRes.getErrorDesc());
                this.fczxRestService.downErrorCall(new CallDataDto("rebuild", (String)opRes.getData(), ProcessState.DOWN_ERROR.name(), data));
            } else {
                this.fczxRestService.downErrorCall(new CallDataDto("rebuild", (String)opRes.getData(), ProcessState.RUNNING.name(), data));
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
            this.fczxRestService.downErrorCall(new CallDataDto("rebuild", null, ProcessState.ERROR.name(), data));
        }
    }
}

