/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.handler;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.DjiTerrainFile;
import com.geoway.fczx.dawn.data.DjiTerrainJobRes;
import com.geoway.fczx.dawn.data.DjiTerrainJobState;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.data.ProcessTask;
import com.geoway.fczx.dawn.data.RsmseJobStatus;
import com.geoway.fczx.dawn.data.property.DawnTransmitProperties;
import com.geoway.fczx.dawn.data.property.DjiTerrainProperties;
import com.geoway.fczx.dawn.enmus.ModelSrvType;
import com.geoway.fczx.dawn.enmus.ProcessState;
import com.geoway.fczx.dawn.thirdapi.dawn.DawnRestService;
import com.geoway.fczx.dawn.thirdapi.dawn.RsmseRestService;
import com.geoway.fczx.dawn.thirdapi.dji.DjiTerrainRestService;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import com.geoway.fczx.dawn.util.TransmitTool;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.Path;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@IgnoreLoad
@Component
public class ModelRebuildStatusHandler {
    private static final Logger log = LoggerFactory.getLogger(ModelRebuildStatusHandler.class);
    private static final ConcurrentHashMap<String, String> rebuilds = new ConcurrentHashMap();
    @Resource
    private DjiTerrainRestService djiTerrainRestService;
    @Resource
    private DawnTransmitProperties transmitProperties;
    @Resource
    private DjiTerrainProperties terrainProperties;
    @Resource
    private RsmseRestService rsmseRestService;
    @Resource
    private DawnRestService dawnRestService;
    @Resource
    private FczxRestService fczxRestService;

    public Map<String, String> getJobStatusTimer() {
        return rebuilds;
    }

    public void buildJobStatusTimer(final ImageUploadDto data, final String jobId) {
        if (!rebuilds.containsKey(jobId)) {
            rebuilds.put(jobId, data.getBizId());
            final Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (ObjectUtil.equal((Object)ModelSrvType.DJI.getType(), (Object)data.getModelSrvType())) {
                        DjiTerrainJobState state = ModelRebuildStatusHandler.this.djiTerrainRestService.queryJobStatus(jobId);
                        if (ObjectUtil.isNotEmpty((Object)state)) {
                            String status = ProcessState.findDji(state);
                            if (state.getStatus() > 4) {
                                ModelRebuildStatusHandler.this.obtainDjiModelResult(state, data);
                                ModelRebuildStatusHandler.this.clearJobStatusTimer(timer, "rebuild", jobId, status, data);
                            } else {
                                data.setErrMsg(state.getErrMsg());
                                data.setProcess(state.getPercentage());
                                ModelRebuildStatusHandler.this.fczxRestService.downErrorCall(new CallDataDto("rebuild", jobId, status, data));
                            }
                        }
                    } else if (ObjectUtil.equal((Object)ModelSrvType.RSDAWN.getType(), (Object)data.getModelSrvType())) {
                        OpRes<ProcessTask> state = ModelRebuildStatusHandler.this.dawnRestService.queryTask(jobId);
                        if (state.isOpRes()) {
                            String status = ProcessState.findRsdawn((ProcessTask)state.getData());
                            if (!ObjectUtil.contains(Arrays.asList(ProcessState.RUNNING.name(), ProcessState.UN_RUNNING.name()), (Object)((ProcessTask)state.getData()).getState())) {
                                ModelRebuildStatusHandler.this.obtainRsdawnModelResult((ProcessTask)state.getData(), data);
                                ModelRebuildStatusHandler.this.clearJobStatusTimer(timer, "rebuild", jobId, status, data);
                            } else {
                                data.setErrMsg(state.getErrorDesc());
                                if (ObjectUtil.isNotEmpty((Object)((ProcessTask)state.getData()).getProgress())) {
                                    data.setProcess(Float.valueOf(((ProcessTask)state.getData()).getProgress().floatValue() / 100.0f));
                                }
                                ModelRebuildStatusHandler.this.fczxRestService.downErrorCall(new CallDataDto("rebuild", jobId, status, data));
                            }
                        }
                    } else if (ObjectUtil.equal((Object)ModelSrvType.RSMSE.getType(), (Object)data.getModelSrvType())) {
                        OpRes<RsmseJobStatus> state = ModelRebuildStatusHandler.this.rsmseRestService.queryTask(jobId);
                        if (state.isOpRes()) {
                            String status = ProcessState.findRsmse((RsmseJobStatus)state.getData());
                            if (((RsmseJobStatus)state.getData()).getStatus() > 30) {
                                ModelRebuildStatusHandler.this.obtainRsmseModelResult((RsmseJobStatus)state.getData(), data);
                                ModelRebuildStatusHandler.this.clearJobStatusTimer(timer, "rebuild", jobId, status, data);
                            } else {
                                data.setErrMsg(state.getErrorDesc());
                                if (ObjectUtil.isNotEmpty((Object)((RsmseJobStatus)state.getData()).getProgress())) {
                                    data.setProcess(Float.valueOf(((RsmseJobStatus)state.getData()).getProgress().floatValue() / 100.0f));
                                }
                                ModelRebuildStatusHandler.this.fczxRestService.downErrorCall(new CallDataDto("rebuild", jobId, status, data));
                            }
                        }
                    } else {
                        ModelRebuildStatusHandler.this.clearJobStatusTimer(timer, "", jobId, ProcessState.ERROR.name(), data);
                    }
                }
            };
            timer.scheduleAtFixedRate(task, 0L, 30000L);
        }
    }

    private void clearJobStatusTimer(Timer timer, String type, String jobId, String state, ImageUploadDto data) {
        timer.cancel();
        rebuilds.remove(jobId);
        this.fczxRestService.downErrorCall(new CallDataDto(type, jobId, state, data));
    }

    private void obtainRsmseModelResult(RsmseJobStatus state, ImageUploadDto data) {
        if (state != null && ObjectUtil.equal((Object)ProcessState.COMPLETE.getRsmse(), (Object)state.getStatus())) {
            log.info("\u6a21\u578b\u6210\u679c{}", (Object)state);
            if (ObjectUtil.isNotEmpty((Object)state.getPath())) {
                data.setResult(state.getPath());
            }
        }
    }

    private void obtainRsdawnModelResult(ProcessTask state, ImageUploadDto data) {
        if (state != null && ObjectUtil.equal((Object)ProcessState.COMPLETE.name(), (Object)state.getState()) && state.getNodes() != null && state.getNodes().get(0).getOuts() != null) {
            String path = state.getNodes().get(0).getOuts().get(0).getDataPath();
            String result = FileUtil.getParent((String)path, (int)1);
            data.setResult(result);
            data.setDataSize(FileUtil.size((File)new File(result), (boolean)true));
        }
    }

    private void obtainDjiModelResult(DjiTerrainJobState state, ImageUploadDto data) {
        DjiTerrainJobRes res;
        if (state != null && ObjectUtil.equal((Object)ProcessState.COMPLETE.getDji(), (Object)state.getStatus()) && ObjectUtil.isNotEmpty((Object)state.getOutputResourceUuid()) && (res = this.djiTerrainRestService.queryJobResult(state.getOutputResourceUuid())) != null && res.getFileUuids() != null) {
            data.setDataSize(res.getSummary().getTotalSize());
            ArrayList<DjiTerrainFile> files = new ArrayList<DjiTerrainFile>();
            if (ObjectUtil.isNotEmpty(res.getFileUuids())) {
                List<DjiTerrainFile> parts;
                HashMap<String, Object> param;
                int rows = this.terrainProperties.getListFilePage();
                int len = res.getFileUuids().size() / rows;
                for (int i = 1; i <= len; ++i) {
                    param = new HashMap<String, Object>();
                    param.put("rows", rows);
                    param.put("needURL", true);
                    param.put("uuids", String.join((CharSequence)",", res.getFileUuids().subList((i - 1) * rows, i * rows)));
                    parts = this.djiTerrainRestService.listFiles(param);
                    files.addAll(parts);
                    ThreadUtil.safeSleep((long)(this.terrainProperties.getListFileWait() * 1000));
                }
                int mod = res.getFileUuids().size() % rows;
                if (mod != 0) {
                    param = new HashMap();
                    param.put("rows", rows);
                    param.put("needURL", true);
                    param.put("uuids", String.join((CharSequence)",", res.getFileUuids().subList(len * rows, len * rows + mod)));
                    parts = this.djiTerrainRestService.listFiles(param);
                    files.addAll(parts);
                }
            }
            if (ObjectUtil.isNotEmpty(files)) {
                log.info("\u5f00\u59cb\u4e0b\u8f7d\u5927\u7586\u667a\u56fe\u5efa\u6a21\u6210\u679c{}", (Object)files.size());
                String base = Path.mergePath((String[])new String[]{this.transmitProperties.getResultPath(), "result", data.getBizId()});
                if (!FileUtil.exist((String)base)) {
                    FileUtil.mkdir((String)base);
                }
                for (DjiTerrainFile file : files) {
                    TransmitTool.downloadImage(file.getUrl(), Path.mergePath((String[])new String[]{base, file.getName()}));
                }
                data.setDataSize(FileUtil.size((File)new File(base), (boolean)true));
                data.setResult(base);
            }
        }
    }
}

