/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.handler;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@IgnoreLoad
@Component
public class TransmitStartedHandler
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TransmitStartedHandler.class);
    @Resource
    private FczxRestService fczxRestService;
    @Value(value="${app.version:v1.0.0}")
    private String version;
    @Value(value="${app.build-time:}")
    private String time;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.printVersion();
        try {
            this.fczxRestService.modelResync(null, null);
        }
        catch (Exception e) {
            log.error("\u6a21\u578b\u91cd\u5efa\u540c\u6b65\u5f02\u5e38");
            log.debug("", (Throwable)e);
        }
        try {
            this.fczxRestService.packageResync(null, null);
        }
        catch (Exception e) {
            log.error("\u6253\u5305\u4e0b\u8f7d\u540c\u6b65\u5f02\u5e38");
            log.debug("", (Throwable)e);
        }
    }

    public int getOrder() {
        return 0;
    }

    private void printVersion() {
        System.out.println("===================================================================");
        System.out.println("\t\t\u5f53\u524d\u7248\u672c\uff1a" + this.version + "\t\u6253\u5305\u65f6\u95f4\uff1a" + TransmitStartedHandler.formatPkgTime(this.time));
        System.out.println("===================================================================");
    }

    public static String formatPkgTime(String time) {
        if (time != null && ObjectUtil.isNotEmpty((Object)time) && !time.contains("T")) {
            return time.substring(0, 4) + "-" + time.substring(4, 6) + "-" + time.substring(6, 8) + " " + time.substring(8, 10) + ":" + time.substring(10, 12) + ":" + time.substring(12, 14);
        }
        return time;
    }
}

