/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.handler;

import cn.hutool.core.util.BooleanUtil;
import com.geoway.fczx.dawn.annotation.IgnoreLoad;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.data.ImageUploadRes;
import com.geoway.fczx.dawn.enmus.ProcessState;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@IgnoreLoad
@Component
public class VideoSpliceAsyncHandler {
    private static final Logger log = LoggerFactory.getLogger(VideoSpliceAsyncHandler.class);
    @Resource
    private ImageService imageService;
    @Resource
    private FczxRestService fczxRestService;

    @Async(value="videoSpliceExecutor")
    public void createSpliceVideoAsync(ImageUploadDto data) {
        OpRes<List<ImageUploadRes>> res = this.imageService.imageUpload(data, null);
        if (!res.isOpRes()) {
            this.fczxRestService.downErrorCall(new CallDataDto("splice", null, ProcessState.DOWN_ERROR.name(), data));
        }
        try {
            OpRes<String> opRes = this.imageService.createImageTask(data);
            if (BooleanUtil.isTrue((Boolean)data.getNoProcessing())) {
                this.fczxRestService.downOutputCall(new CallDataDto("splice", null, ProcessState.COMPLETE.name(), (String)opRes.getData(), data));
            } else if (!opRes.isOpRes()) {
                this.fczxRestService.downErrorCall(new CallDataDto("splice", (String)opRes.getData(), ProcessState.ERROR.name(), data));
            } else {
                this.fczxRestService.downErrorCall(new CallDataDto("splice", (String)opRes.getData(), ProcessState.RUNNING.name(), data));
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }
}

