/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectResult;
import com.geoway.fczx.dawn.data.CallDataDto;
import com.geoway.fczx.dawn.data.DjiTerrainRes;
import com.geoway.fczx.dawn.data.DjiTerrainToken;
import com.geoway.fczx.dawn.data.ImageUploadDto;
import com.geoway.fczx.dawn.data.ImageUploadRes;
import com.geoway.fczx.dawn.data.OuterProcessOrder;
import com.geoway.fczx.dawn.data.PackageCallData;
import com.geoway.fczx.dawn.data.ProcessResult;
import com.geoway.fczx.dawn.data.ProcessTask;
import com.geoway.fczx.dawn.data.RsmseCreateJob;
import com.geoway.fczx.dawn.data.RsmseJobStatus;
import com.geoway.fczx.dawn.data.SpliceCallData;
import com.geoway.fczx.dawn.data.property.DawnTransmitProperties;
import com.geoway.fczx.dawn.data.property.DjiTerrainProperties;
import com.geoway.fczx.dawn.enmus.ModelSrvType;
import com.geoway.fczx.dawn.enmus.ProcessState;
import com.geoway.fczx.dawn.handler.AbstractSpliceCallHandler;
import com.geoway.fczx.dawn.handler.ModelRebuildStatusHandler;
import com.geoway.fczx.dawn.handler.UploadThreadHandler;
import com.geoway.fczx.dawn.service.DownloadProgressService;
import com.geoway.fczx.dawn.service.ImageService;
import com.geoway.fczx.dawn.thirdapi.dawn.DawnRestService;
import com.geoway.fczx.dawn.thirdapi.dawn.RsmseRestService;
import com.geoway.fczx.dawn.thirdapi.dji.DjiTerrainRestService;
import com.geoway.fczx.dawn.thirdapi.fczx.FczxRestService;
import com.geoway.fczx.dawn.util.TransmitTool;
import com.geoway.fczx.dawn.util.UvaTool;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.Path;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ImageServiceImpl
implements ImageService {
    private static final Logger log = LoggerFactory.getLogger(ImageServiceImpl.class);
    @Resource
    private DawnRestService dawnRestService;
    @Autowired(required=false)
    private FczxRestService fczxRestService;
    @Resource
    private RsmseRestService rsmseRestService;
    @Autowired(required=false)
    private AbstractSpliceCallHandler callHandler;
    @Resource
    private DjiTerrainProperties terrainProperties;
    @Resource
    private DjiTerrainRestService terrainRestService;
    @Resource
    private DawnTransmitProperties transmitProperties;
    @Autowired(required=false)
    private ModelRebuildStatusHandler rebuildStatusHandler;
    @Autowired(required=false)
    private CompletionService<ImageUploadRes> uploadCompletionService;

    @Override
    public OpRes<Boolean> videoSpliceCall(SpliceCallData data) {
        if (this.callHandler != null) {
            log.debug("\u5f71\u50cf\u5feb\u62fc\u56de\u8c03{}", (Object)data);
            this.callHandler.callback(data);
        }
        return new OpRes(null, (Object)true, true);
    }

    @Override
    public OpRes<String> videoSplice(ImageUploadDto param) {
        OpRes<List<ImageUploadRes>> res = this.imageUpload(param, null);
        if (!res.isOpRes()) {
            return new OpRes(res.getErrorDesc(), null, false);
        }
        return this.createImageTask(param);
    }

    @Override
    public OpRes<String> createImageTask(ImageUploadDto data) {
        if (BooleanUtil.isTrue((Boolean)data.getNoProcessing())) {
            String out = this.transmitProperties.getResultPath() + "/" + data.getBizId();
            String base = this.transmitProperties.getUploadPath() + "/" + data.getBizId();
            log.info("\u521b\u5efa\u514d\u5904\u7406\u5f71\u50cf\u4efb\u52a1:\n\t\u5904\u7406\u56fe\u7247\u8def\u5f84\uff1a{}\n\t\u8f93\u51fa\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)base, (Object)out);
            if (!FileUtil.exist((String)out)) {
                FileUtil.mkdir((String)out);
            }
            List list = FileUtil.listFileNames((String)base);
            boolean flag = true;
            for (String file : list) {
                try {
                    boolean res = UvaTool.imageToWorldFile(base, base + "/" + file, out + "/result/");
                    flag = flag && res;
                }
                catch (Exception e) {
                    log.error("\u9519\u8bef", (Throwable)e);
                }
            }
            if (!flag) {
                log.error("\u90e8\u5206\u5f71\u50cf\u514d\u5904\u7406\u5931\u8d25");
            }
            log.info("\u5168\u90e8\u7167\u7247{}\u5904\u7406\u6210\u529f", (Object)list);
            return new OpRes(null, (Object)(out + "/result"), true);
        }
        Map<String, Object> param = this.buildVideoSpliceParam(data, true);
        return this.dawnRestService.createTask(param);
    }

    @Override
    public Map<String, Object> buildVideoSpliceParam(ImageUploadDto data, boolean needCall) {
        String callback = "";
        if (needCall) {
            callback = this.transmitProperties.getDroneServerUrl() + "/api/transmit/v1/splice/call";
        }
        String path = this.transmitProperties.getUploadPath() + "/" + data.getBizId();
        HashMap<String, String> bizInfo = new HashMap<String, String>();
        bizInfo.put("bizId", data.getBizId());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("src", this.transmitProperties.getSpliceId());
        param.put("modelId", this.transmitProperties.getSpliceModelId());
        param.put("bizInfo", bizInfo);
        param.put("callback", callback);
        ArrayList<OuterProcessOrder.Item_> parameter = new ArrayList<OuterProcessOrder.Item_>();
        parameter.add(new OuterProcessOrder.Item_("image_meta_data", this.transmitProperties.getNodeId(), Collections.singletonList(path)));
        parameter.add(new OuterProcessOrder.Item_("coordinate_system_2d_type", this.transmitProperties.getNodeId(), Collections.singletonList("2")));
        parameter.add(new OuterProcessOrder.Item_("coordinate_system_2d_epsg_code", this.transmitProperties.getNodeId(), Collections.singletonList("4490")));
        param.put("param", parameter);
        param.put("createUserId", this.transmitProperties.getUserId());
        param.put("createUserName", this.transmitProperties.getUserName());
        return param;
    }

    @Override
    public OpRes<List<ImageUploadRes>> imageUpload(ImageUploadDto param, DownloadProgressService handler) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param, param.getList()})) {
            long start = System.currentTimeMillis();
            ArrayList<ImageUploadRes> resList = new ArrayList<ImageUploadRes>();
            CopyOnWriteArrayList<Future<ImageUploadRes>> tasks = new CopyOnWriteArrayList<Future<ImageUploadRes>>();
            for (String string : param.getList()) {
                String path = Path.mergePath((String[])new String[]{this.transmitProperties.getUploadPath(), param.getBizId(), IdUtil.fastSimpleUUID() + ".jpeg"});
                if (handler != null) {
                    path = Path.mergePath((String[])new String[]{this.transmitProperties.getResultPath(), "result", param.getBizId(), FileUtil.getName((String)string)});
                }
                Future<ImageUploadRes> task = this.uploadCompletionService.submit(new UploadThreadHandler(handler, string, path, this.transmitProperties.getDroneServerUrl()));
                tasks.add(task);
            }
            while (ObjectUtil.isNotEmpty(tasks)) {
                for (Future future : tasks) {
                    try {
                        if (!future.isDone()) continue;
                        resList.add((ImageUploadRes)future.get(5L, TimeUnit.SECONDS));
                        tasks.remove(future);
                    }
                    catch (Exception e) {
                        log.error("\u4e0b\u8f7d{}\u5931\u8d25", (Object)future, (Object)e);
                    }
                }
                ThreadUtil.safeSleep((long)500L);
            }
            long end = System.currentTimeMillis();
            log.error("\u603b\u8ba1\u4e0b\u8f7d\u8017\u65f6{}ms", (Object)(end - start));
            return new OpRes("", resList, true);
        }
        return new OpRes("\u672a\u627e\u5230\u9700\u8981\u4e0b\u8f7d\u7684\u5bf9\u8c61\u4fe1\u606f", null, false);
    }

    @Override
    public void downloadResult(String processId, String bizId, HttpServletResponse response) {
        if (ObjectUtil.isNotEmpty((Object)bizId)) {
            String path = this.transmitProperties.getResultPath() + "/" + bizId + "/result";
            if (ObjectUtil.isNotEmpty((Object)FileUtil.listFileNames((String)path))) {
                ArrayList<String> list = new ArrayList<String>();
                FileUtil.listFileNames((String)path).forEach(name -> list.add(path + "/" + name));
                this.responseFileZip(list, bizId, response);
            } else {
                ResponseEntity result = BaseResponse.error((String)"\u672a\u627e\u5230\u6210\u679c\u6570\u636e");
                TransmitTool.responseJsonData(result.getBody(), null, response);
            }
        } else {
            OpRes<List<ProcessResult>> data = this.dawnRestService.queryResult(processId);
            if (data.isOpRes() && !((List)data.getData()).isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                ((List)data.getData()).forEach(file -> list.add(file.getPath()));
                this.responseFileZip(list, processId, response);
            } else {
                ResponseEntity result = BaseResponse.error((String)data.getErrorDesc());
                TransmitTool.responseJsonData(result.getBody(), null, response);
            }
        }
    }

    @Override
    public Map<String, String> getJobStatusTimer() {
        return this.rebuildStatusHandler.getJobStatusTimer();
    }

    @Override
    public void downloadRebuild(String bizId, String processId, Integer modelSrvType, HttpServletResponse response) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{bizId, processId, modelSrvType})) {
            if (ObjectUtil.equal((Object)ModelSrvType.DJI.getType(), (Object)modelSrvType)) {
                this.downloadPackageResult(bizId, response);
            } else if (ObjectUtil.equal((Object)ModelSrvType.RSDAWN.getType(), (Object)modelSrvType)) {
                OpRes<ProcessTask> data = this.dawnRestService.queryTask(processId);
                if (data.isOpRes() && data.getData() != null && ObjectUtil.isNotEmpty((Object)((ProcessTask)data.getData()).getWorkdir())) {
                    ResponseEntity result;
                    String path;
                    String dataPath = null;
                    if (((ProcessTask)data.getData()).getNodes() != null && ((ProcessTask)data.getData()).getNodes().get(0).getOuts() != null && ObjectUtil.isNotEmpty((Object)(path = ((ProcessTask)data.getData()).getNodes().get(0).getOuts().get(0).getDataPath()))) {
                        dataPath = FileUtil.getParent((String)path, (int)1);
                    }
                    if (ObjectUtil.isEmpty(dataPath)) {
                        result = BaseResponse.error((String)"\u672a\u53d1\u73b0\u6210\u679c\u4fe1\u606f");
                        TransmitTool.responseJsonData(result.getBody(), null, response);
                        return;
                    }
                    if (FileUtil.exist(dataPath)) {
                        this.responseFileZip(ZipUtil.zip(dataPath), bizId, response);
                    } else {
                        result = BaseResponse.error((String)"\u672a\u53d1\u73b0\u6210\u679c\u4fe1\u606f");
                        TransmitTool.responseJsonData(result.getBody(), null, response);
                    }
                } else {
                    ResponseEntity result = BaseResponse.error((String)data.getErrorDesc());
                    TransmitTool.responseJsonData(result.getBody(), null, response);
                }
            } else if (ObjectUtil.equal((Object)ModelSrvType.RSMSE.getType(), (Object)modelSrvType)) {
                this.downloadRsmseResult(processId, response);
            } else {
                ResponseEntity result = BaseResponse.error((String)"modelSrvType\u4fe1\u606f\u6709\u8bef");
                TransmitTool.responseJsonData(result.getBody(), null, response);
            }
        } else {
            ResponseEntity result = BaseResponse.error((String)"\u53c2\u6570\u4fe1\u606f\u6709\u8bef");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        }
    }

    @Override
    public boolean syncRebuild(ImageUploadDto param) {
        if (this.rebuildStatusHandler != null) {
            ThreadUtil.execAsync(() -> this.rebuildStatusHandler.buildJobStatusTimer(param, param.getProcessId()));
            return true;
        }
        return false;
    }

    @Override
    public void downloadRsmseResult(String jobId, HttpServletResponse response) {
        boolean flag = true;
        OpRes<RsmseJobStatus> res = this.rsmseRestService.queryTaskStatus(jobId);
        if (res.isOpRes() && res.getData() != null && ObjectUtil.equal((Object)ProcessState.COMPLETE.getRsmse(), (Object)((RsmseJobStatus)res.getData()).getStatus())) {
            flag = false;
            this.rsmseRestService.downloadResult(jobId, response);
        }
        if (flag) {
            ResponseEntity result = BaseResponse.error((String)"\u672a\u627e\u5230\u6a21\u578b\u6210\u679c\u4fe1\u606f");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        }
    }

    @Override
    public void downloadPackageResult(String bizId, HttpServletResponse response) {
        String path = Path.mergePath((String[])new String[]{this.transmitProperties.getResultPath(), "result", bizId});
        if (FileUtil.exist((String)(path + ".zip"))) {
            this.responseFileZip(FileUtil.file((String)(path + ".zip")), bizId, response);
        } else if (FileUtil.exist((String)path)) {
            this.responseFileZip(ZipUtil.zip((String)path), bizId, response);
        } else {
            ResponseEntity result = BaseResponse.error((String)"\u672a\u53d1\u73b0\u6210\u679c\u4fe1\u606f");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        }
    }

    @Override
    public boolean removeResultFile(String bizId) {
        String path = Path.mergePath((String[])new String[]{this.transmitProperties.getResultPath(), "result", bizId});
        FileUtil.del((String)path);
        FileUtil.del((String)path.concat(".zip"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpRes<String> createRebuildTask(ImageUploadDto data, String jobId) {
        OpRes result;
        if (ObjectUtil.contains(ModelSrvType.getAllType(), (Object)data.getModelSrvType())) {
            OpRes<List<ImageUploadRes>> down;
            if (ObjectUtil.notEqual((Object)ModelSrvType.RSMSE.getType(), (Object)data.getModelSrvType()) && (!(down = this.imageUpload(data, null)).isOpRes() || ObjectUtil.isEmpty((Object)down.getData()))) {
                log.error("\u4e0b\u8f7d\u5931\u8d25");
                return new OpRes("\u4e0b\u8f7d\u5931\u8d25", null, false);
            }
        } else {
            log.error("\u672a\u53d1\u73b0\u8be5\u7c7b\u578b\u7684\u6a21\u578b\u91cd\u5efa\u670d\u52a1");
            return new OpRes("\u672a\u53d1\u73b0\u8be5\u7c7b\u578b\u7684\u6a21\u578b\u91cd\u5efa\u670d\u52a1", null, false);
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6210\u679c\u81f3\u5927\u7586\u667a\u56fe");
        if (ObjectUtil.equal((Object)ModelSrvType.DJI.getType(), (Object)data.getModelSrvType())) {
            HashMap fileMap = new HashMap();
            String root = Path.mergePath((String[])new String[]{this.transmitProperties.getUploadPath(), data.getBizId()});
            for (String image : FileUtil.listFileNames((String)root)) {
                DjiTerrainToken token = this.terrainRestService.getDjiTerrainToken();
                OSS ossClient = null;
                try {
                    ossClient = new OSSClientBuilder().build(this.terrainProperties.getOssEndpoint(), token.getAccessKeyID(), token.getSecretAccessKey(), token.getSessionToken());
                    String objectKey = token.getStorePath().replace(FileUtil.getName((String)token.getStorePath()), "");
                    PutObjectResult put = ossClient.putObject(token.getCloudBucketName(), objectKey.concat(image), (InputStream)FileUtil.getInputStream((String)Path.mergePath((String[])new String[]{root, image})));
                    HashMap<String, String> meta = new HashMap<String, String>();
                    meta.put("name", image);
                    meta.put("etag", put.getETag());
                    meta.put("checksum", put.getETag());
                    fileMap.put(image, meta);
                    log.debug("\u4e0a\u4f20\u6210\u679c{}\u81f3\u5927\u7586\u667a\u56fe", (Object)image);
                }
                finally {
                    if (ossClient == null) continue;
                    ossClient.shutdown();
                }
            }
            log.info("\u4e0a\u4f20\u6210\u679c\u81f3\u5927\u7586\u667a\u56fe\u5b8c\u6210");
            DjiTerrainRes res = this.terrainRestService.creatResource(data.getBizId(), null);
            if (res == null || ObjectUtil.isEmpty((Object)res.getUuid())) {
                return new OpRes("\u521b\u5efa\u5927\u7586\u667a\u56fe\u5efa\u6a21\u8d44\u6e90\u5931\u8d25", null, false);
            }
            Collection list = fileMap.values();
            int size = list.size();
            if (size > 0) {
                JSONArray linked;
                int len = size / 50;
                for (int i = 1; i <= len; ++i) {
                    linked = this.terrainRestService.linkResFiles(res.getUuid(), this.terrainRestService.getDjiTerrainToken().getCallbackParam(), CollectionUtil.sub(list, (int)((i - 1) * 50), (int)(i * 50)));
                    if (linked != null) continue;
                    return new OpRes("\u521b\u5efa\u5927\u7586\u667a\u56fe\u5efa\u6a21\u5173\u8054\u8d44\u6e90\u5931\u8d25", null, false);
                }
                int mod = size % 50;
                if (mod != 0 && (linked = this.terrainRestService.linkResFiles(res.getUuid(), this.terrainRestService.getDjiTerrainToken().getCallbackParam(), CollectionUtil.sub(list, (int)(len * 50), (int)(len * 50 + mod)))) == null) {
                    return new OpRes("\u521b\u5efa\u5927\u7586\u667a\u56fe\u5efa\u6a21\u5173\u8054\u8d44\u6e90\u5931\u8d25", null, false);
                }
            }
            log.info("\u542f\u52a8\u5927\u7586\u667a\u56fe\u5efa\u6a21\u4efb\u52a1");
            boolean flag = this.terrainRestService.startJob(jobId, res.getUuid(), data.getModelType(), JSONUtil.toJsonStr((Object)data.getArgs()));
            if (!flag) {
                return new OpRes("\u542f\u52a8\u5927\u7586\u667a\u56fe\u5efa\u6a21\u4efb\u52a1\u5931\u8d25", null, false);
            }
            result = new OpRes(null, (Object)jobId, true);
        } else if (ObjectUtil.equal((Object)ModelSrvType.RSDAWN.getType(), (Object)data.getModelSrvType())) {
            Map<String, Object> param = this.buildVideoSpliceParam(data, false);
            result = this.dawnRestService.createTask(param);
        } else if (ObjectUtil.equal((Object)ModelSrvType.RSMSE.getType(), (Object)data.getModelSrvType())) {
            ArrayList<String> files = new ArrayList<String>();
            for (String objectKey : data.getList()) {
                String server = this.transmitProperties.getDroneServerUrl();
                String href = server + "/api/files/v1/original?objectKey=" + objectKey;
                files.add(href);
            }
            result = this.rsmseRestService.createTask(new RsmseCreateJob(files, data.getModelType()).convertMap());
        } else {
            return new OpRes("\u672a\u53d1\u73b0\u8be5\u7c7b\u578b\u7684\u6a21\u578b\u91cd\u5efa\u670d\u52a1", null, false);
        }
        if (result.isOpRes() && ObjectUtil.isNotEmpty((Object)result.getData()) && this.rebuildStatusHandler != null) {
            ThreadUtil.execAsync(() -> this.rebuildStatusHandler.buildJobStatusTimer(data, (String)result.getData()));
        }
        return result;
    }

    @Override
    public boolean createPackageTask(ImageUploadDto data) {
        if (this.fczxRestService != null) {
            OpRes<List<ImageUploadRes>> down = this.imageUpload(data, (name, flag) -> {
                ImageUploadDto imageUploadDto = data;
                synchronized (imageUploadDto) {
                    if (ObjectUtil.isEmpty((Object)data.getProcess())) {
                        data.setProcess(Float.valueOf(0.0f));
                    }
                    data.setProcess(Float.valueOf(data.getProcess().floatValue() + 1.0f));
                    CallDataDto callData = new CallDataDto("package", null, ProcessState.RUNNING.name(), data);
                    this.fczxRestService.downOutputCall(callData);
                }
            });
            if (!down.isOpRes() || ObjectUtil.isEmpty((Object)down.getData())) {
                log.error("\u4e0b\u8f7d\u5931\u8d25");
                return false;
            }
            JSONArray spots = this.fczxRestService.getPackageSpots(data.getWorkspaceId(), data.getBizId());
            String path = Path.mergePath((String[])new String[]{this.transmitProperties.getResultPath(), "result", data.getBizId()});
            if (ObjectUtil.isNotEmpty((Object)spots)) {
                spots.toList(JSONObject.class).forEach(e -> {
                    String name = FileUtil.getName((String)e.getStr((Object)"objectKey"));
                    if (FileUtil.exist((String)Path.mergePath((String[])new String[]{path, name}))) {
                        if (ObjectUtil.isNotEmpty((Object)e.getStr((Object)"tbIds"))) {
                            String[] tbIds = e.getStr((Object)"tbIds").split(",");
                            for (int i = 0; i < tbIds.length; ++i) {
                                String spot = Path.mergePath((String[])new String[]{path, tbIds[i]});
                                if (!FileUtil.exist((String)spot)) {
                                    FileUtil.mkdir((String)spot);
                                }
                                if (i == tbIds.length - 1) {
                                    FileUtil.move((File)FileUtil.file((String)Path.mergePath((String[])new String[]{path, name})), (File)FileUtil.newFile((String)Path.mergePath((String[])new String[]{spot, name})), (boolean)false);
                                    continue;
                                }
                                FileUtil.copy((File)FileUtil.file((String)Path.mergePath((String[])new String[]{path, name})), (File)FileUtil.newFile((String)Path.mergePath((String[])new String[]{spot, name})), (boolean)false);
                            }
                        } else {
                            String spot = Path.mergePath((String[])new String[]{path, "others"});
                            if (!FileUtil.exist((String)spot)) {
                                FileUtil.mkdir((String)spot);
                            }
                            FileUtil.move((File)FileUtil.file((String)Path.mergePath((String[])new String[]{path, name})), (File)FileUtil.newFile((String)Path.mergePath((String[])new String[]{spot, name})), (boolean)false);
                        }
                    }
                });
            }
            ZipUtil.zip((String)path);
            return true;
        }
        return false;
    }

    @Override
    public OpRes<Boolean> modelRebuildCall(CallDataDto data) {
        if (this.callHandler != null) {
            log.debug("\u6a21\u578b\u91cd\u5efa\u56de\u8c03{}", (Object)data);
            this.callHandler.callback(data);
        }
        return new OpRes(null, (Object)true, true);
    }

    @Override
    public OpRes<Boolean> packageTaskCall(PackageCallData data) {
        if (this.callHandler != null) {
            log.debug("\u538b\u7f29\u6253\u5305\u56de\u8c03{}", (Object)data);
            this.callHandler.callback(data);
        }
        return new OpRes(null, (Object)true, true);
    }

    public void responseFileZip(List<String> list, String fileId, HttpServletResponse response) {
        InputStream[] ins = new InputStream[list.size()];
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String file = list.get(i);
            BufferedInputStream in = FileUtil.getInputStream((String)file);
            if (in == null) continue;
            ins[i] = in;
            names[i] = FileUtil.getName((String)file);
        }
        response.setCharacterEncoding("UTF-8");
        try {
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(fileId + ".zip", "UTF-8"));
            ZipUtil.zip((OutputStream)response.getOutputStream(), (String[])names, (InputStream[])ins);
        }
        catch (Exception e) {
            ResponseEntity result = BaseResponse.error((String)"\u538b\u7f29\u6587\u4ef6\u5931\u8d25");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        }
    }

    public void responseFileZip(File zip, String fileId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        try {
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(fileId + ".zip", "UTF-8"));
            IoUtil.copy((InputStream)FileUtil.getInputStream((File)zip), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            ResponseEntity result = BaseResponse.error((String)"\u538b\u7f29\u6587\u4ef6\u5931\u8d25");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        }
    }
}

