/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.thirdapi.dawn;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.dawn.data.RsmseJobStatus;
import com.geoway.fczx.dawn.data.property.DjiTerrainProperties;
import com.geoway.fczx.dawn.util.TransmitTool;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.OpRes;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RsmseRestService {
    private static final Logger log = LoggerFactory.getLogger(RsmseRestService.class);
    @Resource
    private RestTemplate dawnApiRest;
    @Resource
    private DjiTerrainProperties terrainProperties;
    private static final String listTasksUrl = "/rsmse-uav-server/rsserver/taskInfo/getList";
    private static final String createTaskUrl = "/rsmse-uav-server/rs/mapmyth/task";
    private static final String queryTaskStatUrl = "/rsmse-uav-server/rs/mapmyth/task/";
    private static final String queryTaskUrl = "/rsmse-uav-server/rsserver/taskInfo/";
    private static final String queryResultUrl = "/rsmse-uav-server/rsserver/taskResult/";
    private static final String downloadResultUrl = "/rsmse-uav-server/rs/mapmyth/task/result/";

    public OpRes<JSONArray> listTasks(Map<String, Object> map) {
        String parameter = TransmitTool.buildUrlParameters(map);
        long s1 = System.currentTimeMillis();
        String url = this.terrainProperties.getServerUrl().concat(listTasksUrl).concat("?").concat(parameter);
        long s2 = System.currentTimeMillis();
        log.debug("\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u8bf7\u6c42\u8017\u65f6{}", (Object)(s2 - s1));
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)JSONUtil.parseObj((Object)res.getBody(), (JSONConfig)JSONConfig.create().setIgnoreNullValue(true)).getJSONArray((Object)"data"), true);
    }

    public OpRes<RsmseJobStatus> queryTask(String jobId) {
        String url = this.terrainProperties.getServerUrl().concat(queryTaskUrl).concat(jobId);
        long s1 = System.currentTimeMillis();
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[]{jobId});
        long s2 = System.currentTimeMillis();
        log.debug("\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u8bf7\u6c42\u8017\u65f6{}", (Object)(s2 - s1));
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u53ca\u8fdb\u5ea6\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a{}", res.getBody());
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((RsmseJobStatus)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", RsmseJobStatus.class)), true);
    }

    public OpRes<RsmseJobStatus> queryTaskStatus(String jobId) {
        String url = this.terrainProperties.getServerUrl().concat(queryTaskStatUrl).concat(jobId);
        long s1 = System.currentTimeMillis();
        ResponseEntity res = this.dawnApiRest.getForEntity(url, String.class, new Object[]{jobId});
        long s2 = System.currentTimeMillis();
        log.debug("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u53ca\u8fdb\u5ea6\u8bf7\u6c42\u8017\u65f6{}", (Object)(s2 - s1));
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u53ca\u8fdb\u5ea6\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((RsmseJobStatus)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", RsmseJobStatus.class)), true);
    }

    public OpRes<String> createTask(Map<String, Object> param) {
        String url = this.terrainProperties.getServerUrl().concat(createTaskUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        log.debug("{}", (Object)JSONUtil.toJsonPrettyStr(param));
        long s1 = System.currentTimeMillis();
        ResponseEntity res = this.dawnApiRest.postForEntity(url, (Object)new HttpEntity(param, (MultiValueMap)headers), String.class, new Object[0]);
        long s2 = System.currentTimeMillis();
        log.info("\u521b\u5efa\u6570\u636e\u5904\u7406\u4efb\u52a1\u8bf7\u6c42\u8017\u65f6{}", (Object)(s2 - s1));
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u521b\u5efa\u6570\u636e\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)res);
            return new OpRes(JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"msg"), null, false);
        }
        return new OpRes(null, (Object)((String)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", String.class)), true);
    }

    public void downloadResult(String jobId, HttpServletResponse response) {
        String url = this.terrainProperties.getServerUrl().concat(downloadResultUrl).concat(jobId);
        try {
            URL uri = new URL(url);
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(jobId + ".zip", "UTF-8"));
            IoUtil.copy((InputStream)uri.openStream(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6210\u679c\u5931\u8d25", (Throwable)e);
            ResponseEntity result = BaseResponse.error((String)"\u4e0b\u8f7d\u6210\u679c\u5931\u8d25");
            TransmitTool.responseJsonData(result.getBody(), null, response);
        }
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code");
            return code == 200;
        }
        return false;
    }
}

