/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.thirdapi.rsia;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.dawn.data.HpcPredictRes;
import com.geoway.fczx.dawn.data.RsiaCreateJob;
import com.geoway.fczx.dawn.data.property.GwRsiaProperties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RsiaRestService {
    private static final Logger log = LoggerFactory.getLogger(RsiaRestService.class);
    @Resource
    private RestTemplate rsiaApiRest;
    @Resource
    private GwRsiaProperties rsiaProperties;
    private static final String queryModelUrl = "/model/model";
    private static final String queryTaskUrl = "/hoc/predict/";
    private static final String createTaskUrl = "/hoc/predict";

    @PostConstruct
    public void initRsiaService() {
        if (ObjectUtil.isEmpty((Object)this.rsiaProperties.getServerUrl())) {
            log.error("\u9065\u611f\u5206\u6790\u670d\u52a1\u5730\u5740\u4e3anull\uff0c\u8fd9\u5c06\u4f1a\u5bfc\u81f4\u9065\u611f\u5206\u6790\u670d\u52a1\u4e0d\u53ef\u7528");
        }
    }

    public JSONArray queryModel() {
        String url = this.rsiaProperties.getServerUrl().concat(queryModelUrl);
        ResponseEntity res = this.rsiaApiRest.getForEntity(url, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u5206\u6790\u6a21\u578b\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getJSONArray((Object)"data");
    }

    public HpcPredictRes getHpcPredict(String taskId) {
        String url = this.rsiaProperties.getServerUrl().concat(queryTaskUrl).concat(taskId);
        ResponseEntity res = this.rsiaApiRest.exchange(url, HttpMethod.GET, new HttpEntity(null), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u9065\u611f\u5206\u6790\u4efb\u52a1\u5931\u8d25\uff1a{}", res.getBody());
            return null;
        }
        JSONObject json = JSONUtil.parseObj((String)((String)res.getBody())).getJSONObject((Object)"data");
        if (json.isEmpty()) {
            log.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u9065\u611f\u5206\u6790\u4efb\u52a1{}\u6570\u636e", (Object)taskId);
            return null;
        }
        return (HpcPredictRes)json.toBean(HpcPredictRes.class);
    }

    public String createHpcPredict(RsiaCreateJob data) {
        String url = this.rsiaProperties.getServerUrl().concat(createTaskUrl);
        ResponseEntity res = this.rsiaApiRest.postForEntity(url, (Object)new HttpEntity((Object)data), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u9065\u611f\u5206\u6790\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"data");
    }

    public boolean deleteHpcPredict(String taskId) {
        String url = this.rsiaProperties.getServerUrl().concat(queryTaskUrl).concat(taskId);
        ResponseEntity res = this.rsiaApiRest.exchange(url, HttpMethod.DELETE, new HttpEntity(null), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u5220\u9664\u9065\u611f\u5206\u6790\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)res);
            return false;
        }
        return true;
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code");
            return code == 200;
        }
        return false;
    }
}

