/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.dawn.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmitTool {
    private static final Logger log = LoggerFactory.getLogger(TransmitTool.class);

    public static boolean downloadZip(String href, String path) {
        try {
            long s1 = System.currentTimeMillis();
            URL url = new URL(href);
            URLConnection conn = url.openConnection();
            FileUtil.writeFromStream((InputStream)conn.getInputStream(), (String)path);
            long s2 = System.currentTimeMillis();
            log.info("\u4e0b\u8f7d\u8017\u65f6" + (s2 - s1));
            return true;
        }
        catch (Exception var14) {
            log.error("url={}\u4e0b\u8f7dzip\u5305\u5931\u8d25", (Object)href, (Object)var14);
            FileUtil.del((String)path);
            return false;
        }
    }

    public static boolean downloadImage(String url, String path) {
        URL href = null;
        try {
            href = new URL(url);
            if (FileUtil.exist((String)path)) {
                return true;
            }
            FileUtil.mkdir((String)new File(path).getParent());
            FileUtil.newFile((String)path);
            URLConnection conn = href.openConnection();
            InputStream input = conn.getInputStream();
            FileUtil.writeFromStream((InputStream)input, (String)path);
            IoUtil.close((Closeable)input);
            return true;
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d{}\u5931\u8d25{}", (Object)href, (Object)e.getMessage());
            FileUtil.del((String)path);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRedirectUrl(String url) {
        URL href = null;
        HttpURLConnection conn = null;
        try {
            href = new URL(url);
            conn = (HttpURLConnection)href.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            int code = conn.getResponseCode();
            if (code > 300 && code < 400) {
                String string = conn.getHeaderField("Location");
                return string;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u91cd\u5b9a\u5411\u5730\u5740{}\u5931\u8d25{}", (Object)url, (Object)e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static String buildUrlParameters(Map<String, Object> map) {
        String parameters = "";
        if (ObjectUtil.isNotEmpty(map)) {
            ArrayList<String> args = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (!ObjectUtil.isNotEmpty((Object)map.get(key))) continue;
                args.add(key.concat("=").concat(map.get(key).toString()));
            }
            parameters = String.join((CharSequence)"&", args);
        }
        return parameters;
    }

    public static void responseJsonData(Object data, String contentType, HttpServletResponse response) {
        try {
            String json = new ObjectMapper().writeValueAsString(data);
            response.setCharacterEncoding("UTF-8");
            if (ObjectUtil.isEmpty((Object)contentType)) {
                response.setContentType("application/json");
            } else {
                response.setContentType(contentType);
            }
            IoUtil.copy((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }
}

