/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.flylib.CoordinateAble;
import com.geoway.flylib.GroupPhotoPoint;
import com.geoway.flylib.PhotoPoint;
import com.geoway.flylib.Tuban;
import com.geoway.flylib.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.Segment;

public class FlyUtil {
    private static final GeometryFactory geometryFactory = new GeometryFactory();
    public static final int YUNTAI_ZHENG_DEF = -90;
    private static final float YUNTAI_XIE_DEF = -45.0f;

    public static PhotoPoint generateXiePhotoPoint2(Tuban tb, Coordinate coordinate) {
        PhotoPoint photoPoint_xie = new PhotoPoint();
        photoPoint_xie.setId(UUID.randomUUID().toString());
        photoPoint_xie.setGenFromTbId(tb.getId());
        photoPoint_xie.setElevation((float)(tb.getAltitude() + tb.getRise()));
        photoPoint_xie.setAltitude((float)(tb.getAltitude() + tb.getRise()));
        photoPoint_xie.setYuntai(-45.0f);
        photoPoint_xie.setZoom(tb.getZoom());
        photoPoint_xie.setOrientation((float)GeoUtils.orientation(coordinate, tb.getCoordinate()));
        photoPoint_xie.setLat(coordinate.getY());
        photoPoint_xie.setLon(coordinate.getX());
        photoPoint_xie.setZheng(false);
        if (StrUtil.isNotEmpty((CharSequence)tb.getBizId()) && tb.getBizId().contains(",")) {
            photoPoint_xie.setLinkTbIds(StrUtil.split((CharSequence)tb.getBizId(), (CharSequence)","));
        } else {
            photoPoint_xie.setLinkTbIds(Collections.singletonList(tb.getId()));
        }
        return photoPoint_xie;
    }

    public static PhotoPoint generateZhengPhotoPoint(Tuban tb) {
        PhotoPoint photoPoint_zheng = new PhotoPoint();
        photoPoint_zheng.setId(UUID.randomUUID().toString());
        photoPoint_zheng.setGenFromTbId(tb.getId());
        photoPoint_zheng.setLon(tb.getCenterLon());
        photoPoint_zheng.setLat(tb.getCenterLat());
        photoPoint_zheng.setAltitude((float)(tb.getAltitude() + tb.getRise()));
        photoPoint_zheng.setElevation((float)(tb.getAltitude() + tb.getRise()));
        photoPoint_zheng.setYuntai(-90.0f);
        photoPoint_zheng.setOrientation((float)Math.toDegrees(tb.getAngle()));
        photoPoint_zheng.setZheng(true);
        photoPoint_zheng.setZoom(tb.getZoom());
        if (StrUtil.isNotEmpty((CharSequence)tb.getBizId()) && tb.getBizId().contains(",")) {
            photoPoint_zheng.setLinkTbIds(StrUtil.split((CharSequence)tb.getBizId(), (CharSequence)","));
        } else {
            photoPoint_zheng.setLinkTbIds(Collections.singletonList(tb.getId()));
        }
        return photoPoint_zheng;
    }

    private static GroupPhotoPoint wrapPhotoPoint(PhotoPoint photoPoint, Tuban tuban) {
        if (photoPoint == null) {
            return null;
        }
        GroupPhotoPoint groupPhotoPoint = new GroupPhotoPoint();
        groupPhotoPoint.setId(UUID.randomUUID().toString());
        groupPhotoPoint.setLon(photoPoint.getLon());
        groupPhotoPoint.setLat(photoPoint.getLat());
        groupPhotoPoint.setTbLon(tuban.getCenterLon());
        groupPhotoPoint.setTbLat(tuban.getCenterLat());
        groupPhotoPoint.setAltitude(photoPoint.getAltitude());
        groupPhotoPoint.setElevation(photoPoint.getElevation());
        groupPhotoPoint.setOrientation(photoPoint.getOrientation());
        photoPoint.setGroupId(groupPhotoPoint.getId());
        groupPhotoPoint.getPhotoPoints().add(photoPoint);
        groupPhotoPoint.setSubIndex(0L);
        groupPhotoPoint.setZoom(photoPoint.getZoom());
        photoPoint.setSel(true);
        return groupPhotoPoint;
    }

    public static <T extends CoordinateAble> List<T> simpleSortCoordinateAble(Coordinate startCoordinate, List<T> coordinateAbles) {
        ArrayList<T> list = new ArrayList<T>();
        T t = FlyUtil.getNearest(startCoordinate, coordinateAbles);
        while (t != null) {
            list.add(t);
            coordinateAbles.remove(t);
            t = FlyUtil.getNearest(((CoordinateAble)t).getCoordinate(), coordinateAbles);
        }
        return list;
    }

    public static <T extends CoordinateAble> void angleSort(Coordinate deviceCoordinate, List<T> coordinateAbles) {
        coordinateAbles.sort(Comparator.comparingDouble(t -> Angle.angle((Coordinate)deviceCoordinate, (Coordinate)t.getCoordinate())));
    }

    public static <T extends CoordinateAble> List<T> sortCoordinateAble(Coordinate startCoordinate, List<T> coordinateAbles, Coordinate endCoordinate) {
        double distance2;
        double distance1;
        List<T> list = FlyUtil.simpleSortCoordinateAble(startCoordinate, coordinateAbles);
        if (list.size() <= 500) {
            list = FlyUtil.change1(startCoordinate, endCoordinate, list);
        }
        if (list.size() <= 1000) {
            list = FlyUtil.change2(startCoordinate, endCoordinate, list);
        }
        boolean better = FlyUtil.change3(startCoordinate, endCoordinate, list);
        while (better) {
            better = FlyUtil.change3(startCoordinate, endCoordinate, list);
        }
        if (list.size() <= 50) {
            list = FlyUtil.change1(startCoordinate, endCoordinate, list);
        }
        if ((distance1 = ((CoordinateAble)list.get(0)).getCoordinate().distance(startCoordinate)) > (distance2 = ((CoordinateAble)list.get(list.size() - 1)).getCoordinate().distance(startCoordinate))) {
            Collections.reverse(list);
        }
        return list;
    }

    private static <T extends CoordinateAble> List<T> change2(Coordinate startCoordinate, Coordinate endCoordinate, List<T> list) {
        int[] cross = FlyUtil.findCross(startCoordinate, endCoordinate, list);
        while (cross[0] >= 0) {
            List<T> subList1 = list.subList(0, cross[0]);
            List<T> subList2 = list.subList(cross[0], cross[1] + 1);
            List<T> subList3 = list.subList(cross[1] + 1, list.size());
            Collections.reverse(subList2);
            ArrayList<T> newList = new ArrayList<T>(subList1);
            newList.addAll(subList2);
            newList.addAll(subList3);
            list = newList;
            cross = FlyUtil.findCross(startCoordinate, endCoordinate, list);
        }
        return list;
    }

    private static <T extends CoordinateAble> List<T> change1(Coordinate startCoordinate, Coordinate endCoordinate, List<T> list) {
        int[] betterPosition = FlyUtil.findBetterPosition(startCoordinate, endCoordinate, list);
        while (betterPosition[0] >= 0) {
            ArrayList<T> newList;
            List<T> subList3;
            List<T> subList1;
            if (betterPosition[0] > betterPosition[1]) {
                subList1 = list.subList(0, betterPosition[1]);
                List<T> subList2 = list.subList(betterPosition[1], betterPosition[0]);
                CoordinateAble toMove = (CoordinateAble)list.get(betterPosition[0]);
                subList3 = list.subList(betterPosition[0] + 1, list.size());
                newList = new ArrayList<T>(subList1);
                newList.add(toMove);
                newList.addAll(subList2);
                newList.addAll(subList3);
                list = newList;
            } else {
                subList1 = list.subList(0, betterPosition[0]);
                CoordinateAble toMove = (CoordinateAble)list.get(betterPosition[0]);
                List<T> subList2 = list.subList(betterPosition[0] + 1, betterPosition[1]);
                subList3 = list.subList(betterPosition[1], list.size());
                newList = new ArrayList<T>(subList1);
                newList.addAll(subList2);
                newList.add(toMove);
                newList.addAll(subList3);
                list = newList;
            }
            betterPosition = FlyUtil.findBetterPosition(startCoordinate, endCoordinate, list);
        }
        return list;
    }

    public static <T extends CoordinateAble> double length(Coordinate startCoordinate, List<T> list, Coordinate endCoordinate) {
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
        coordinateList.add(startCoordinate);
        for (CoordinateAble t : list) {
            coordinateList.add(t.getCoordinate());
        }
        coordinateList.add(endCoordinate);
        Coordinate[] coordinates = coordinateList.toArray(new Coordinate[0]);
        LineString lineString = geometryFactory.createLineString(coordinates);
        LineString lineStringPlane = (LineString)GeoUtils.toPlane((Geometry)lineString);
        return lineStringPlane.getLength();
    }

    private static <T extends CoordinateAble> int[] findBetterPosition(Coordinate startCoordinate, Coordinate endCoordinate, List<T> list) {
        int[] betterPosition = new int[]{-1, -1};
        for (int i = 0; i < list.size(); ++i) {
            Coordinate coordinate = ((CoordinateAble)list.get(i)).getCoordinate();
            Coordinate lastCoordinate = i == 0 ? startCoordinate : ((CoordinateAble)list.get(i - 1)).getCoordinate();
            Coordinate nextCoordinate = i == list.size() - 1 ? endCoordinate : ((CoordinateAble)list.get(i + 1)).getCoordinate();
            double decrease = coordinate.distance(lastCoordinate) + coordinate.distance(nextCoordinate) - lastCoordinate.distance(nextCoordinate);
            double tmpDecrease = 0.0;
            for (int j = 0; j <= list.size(); ++j) {
                if (j >= i - 1 && j <= i + 2) continue;
                Coordinate firstCoordinate = j == 0 ? startCoordinate : ((CoordinateAble)list.get(j - 1)).getCoordinate();
                Coordinate secondCoordinate = j == list.size() ? endCoordinate : ((CoordinateAble)list.get(j)).getCoordinate();
                double increase = coordinate.distance(firstCoordinate) + coordinate.distance(secondCoordinate) - firstCoordinate.distance(secondCoordinate);
                if (!(increase < decrease) || !(decrease - increase > tmpDecrease)) continue;
                tmpDecrease = decrease - increase;
                betterPosition[0] = i;
                betterPosition[1] = j;
            }
        }
        return betterPosition;
    }

    private static <T extends CoordinateAble> int[] findCross(Coordinate startCoordinate, Coordinate endCoordinate, List<T> list) {
        int[] crossIndexArr = new int[]{-1, -1};
        for (int i = 1; i <= list.size() - 1; ++i) {
            Segment segment = i == list.size() - 1 ? new Segment(((CoordinateAble)list.get(i)).getCoordinate(), endCoordinate) : new Segment(((CoordinateAble)list.get(i)).getCoordinate(), ((CoordinateAble)list.get(i + 1)).getCoordinate());
            for (int j = 0; j <= i - 1; ++j) {
                Segment segment1 = j == 0 ? new Segment(startCoordinate, ((CoordinateAble)list.get(j)).getCoordinate()) : new Segment(((CoordinateAble)list.get(j - 1)).getCoordinate(), ((CoordinateAble)list.get(j)).getCoordinate());
                if (segment1.getEnd().equals((Object)segment.getStart()) || segment1.getStart().equals((Object)segment.getEnd()) || segment.intersection(segment1) == null) continue;
                crossIndexArr[0] = j;
                crossIndexArr[1] = i;
                break;
            }
            if (crossIndexArr[0] >= 0) break;
        }
        return crossIndexArr;
    }

    private static <T extends CoordinateAble> boolean change3(Coordinate startCoordinate, Coordinate endCoordinate, List<T> list) {
        Object[] coordinates = (Coordinate[])list.stream().map(CoordinateAble::getCoordinate).toArray(Coordinate[]::new);
        coordinates = (Coordinate[])ArrayUtil.append((Object[])coordinates, (Object[])new Coordinate[]{endCoordinate});
        coordinates = (Coordinate[])ArrayUtil.setOrAppend((Object[])coordinates, (int)0, (Object)startCoordinate);
        LineString lineString = geometryFactory.createLineString((Coordinate[])coordinates);
        double lastLength = lineString.getLength();
        boolean better = false;
        for (int i = 1; i < list.size() - 3; ++i) {
            Integer[][] indexes;
            CoordinateAble t0 = (CoordinateAble)list.get(i);
            CoordinateAble t1 = (CoordinateAble)list.get(i + 1);
            CoordinateAble t2 = (CoordinateAble)list.get(i + 2);
            for (Integer[] arr : indexes = new Integer[][]{{0, 2, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}, {2, 1, 0}}) {
                ListUtil.setOrAppend(list, (int)(i + arr[0]), (Object)t0);
                ListUtil.setOrAppend(list, (int)(i + arr[1]), (Object)t1);
                ListUtil.setOrAppend(list, (int)(i + arr[2]), (Object)t2);
                Object[] tmpCoordinates = (Coordinate[])list.stream().map(CoordinateAble::getCoordinate).toArray(Coordinate[]::new);
                tmpCoordinates = (Coordinate[])ArrayUtil.setOrAppend((Object[])tmpCoordinates, (int)0, (Object)startCoordinate);
                tmpCoordinates = (Coordinate[])ArrayUtil.append((Object[])tmpCoordinates, (Object[])new Coordinate[]{endCoordinate});
                LineString tmpLineString = geometryFactory.createLineString((Coordinate[])tmpCoordinates);
                if (!(tmpLineString.getLength() - lastLength < 0.0)) continue;
                lastLength = tmpLineString.getLength();
                better = true;
                break;
            }
            if (better) break;
            ListUtil.setOrAppend(list, (int)i, (Object)t0);
            ListUtil.setOrAppend(list, (int)(i + 1), (Object)t1);
            ListUtil.setOrAppend(list, (int)(i + 2), (Object)t2);
        }
        return better;
    }

    public static <T extends CoordinateAble> T getNearest(Coordinate startCoordinate, List<T> coordinateAbles) {
        double minDist = -1.0;
        CoordinateAble result = null;
        for (CoordinateAble t : coordinateAbles) {
            double distance = t.getCoordinate().distance(startCoordinate);
            if (!(minDist < 0.0) && !(distance < minDist)) continue;
            minDist = distance;
            result = t;
        }
        return (T)result;
    }

    public static <T extends CoordinateAble> T getFarthest(Coordinate startCoordinate, List<T> coordinateAbles) {
        double maxDist = Double.MIN_VALUE;
        CoordinateAble result = null;
        for (CoordinateAble t : coordinateAbles) {
            double distance = t.getCoordinate().distance(startCoordinate);
            if (!(distance > maxDist)) continue;
            maxDist = distance;
            result = t;
        }
        return (T)result;
    }

    public static List<GroupPhotoPoint> generateGroupPhotoPoints2(List<Tuban> tubans, List<LineString> tubanLineStrings, LineString backLineString, double xieMinAngle) {
        ArrayList<GroupPhotoPoint> goPoints = new ArrayList<GroupPhotoPoint>();
        ArrayList<GroupPhotoPoint> backPoints = new ArrayList<GroupPhotoPoint>();
        for (int i = 0; i < tubans.size(); ++i) {
            double radian;
            GroupPhotoPoint lastPhotoPointXie;
            Tuban tuban = tubans.get(i);
            int xieNeed = tuban.isGrid() ? 1 : 2;
            double realAltitude = tuban.getAltitude() + tuban.getRise();
            PhotoPoint photoPointZheng = FlyUtil.generateZhengPhotoPoint(tuban);
            goPoints.add(FlyUtil.wrapPhotoPoint(photoPointZheng, tuban));
            Point point = geometryFactory.createPoint(tuban.getCoordinate());
            int planeSrid = GeoUtils.getPlaneSrid(point.getX());
            Point pointPlane = (Point)GeoUtils.toPlane((Geometry)point, planeSrid);
            LinearRing ring = ((Polygon)pointPlane.buffer(realAltitude)).getExteriorRing();
            int count = 0;
            boolean back = false;
            for (LineString lineString : tubanLineStrings) {
                List<GroupPhotoPoint> photoPointsXies = FlyUtil.findPhotoPointsXie(planeSrid, lineString, ring, tuban);
                for (GroupPhotoPoint photoPointsXie : photoPointsXies) {
                    if (count == 1) {
                        lastPhotoPointXie = (GroupPhotoPoint)goPoints.get(goPoints.size() - 1);
                        if (FlyUtil.valid(lastPhotoPointXie, photoPointsXie, xieMinAngle)) {
                            goPoints.add(photoPointsXie);
                            ++count;
                        }
                    } else {
                        goPoints.add(photoPointsXie);
                        ++count;
                    }
                    if (count != xieNeed) continue;
                    break;
                }
                if (count != xieNeed) continue;
                break;
            }
            if (count == xieNeed) continue;
            List<GroupPhotoPoint> backPhotoPointsXies = FlyUtil.findPhotoPointsXie(planeSrid, backLineString, ring, tuban);
            for (GroupPhotoPoint backPhotoPointsXie : backPhotoPointsXies) {
                if (count == 1) {
                    GroupPhotoPoint lastPhotoPointXie2;
                    GroupPhotoPoint groupPhotoPoint = lastPhotoPointXie2 = back ? (GroupPhotoPoint)backPoints.get(backPoints.size() - 1) : (GroupPhotoPoint)goPoints.get(goPoints.size() - 1);
                    if (FlyUtil.valid(lastPhotoPointXie2, backPhotoPointsXie, xieMinAngle)) {
                        backPoints.add(backPhotoPointsXie);
                        back = true;
                        ++count;
                    }
                } else {
                    backPoints.add(backPhotoPointsXie);
                    back = true;
                    ++count;
                }
                if (count != xieNeed) continue;
                break;
            }
            if (count == xieNeed) continue;
            LineString lineString = tubanLineStrings.get(i);
            Coordinate[] coordinates = lineString.getCoordinates();
            if (count == 1) {
                lastPhotoPointXie = back ? (GroupPhotoPoint)backPoints.get(backPoints.size() - 1) : (GroupPhotoPoint)goPoints.get(goPoints.size() - 1);
                radian = GeoUtils.angle(new Coordinate(lastPhotoPointXie.getLon(), lastPhotoPointXie.getLat()), coordinates[1]);
            } else {
                radian = GeoUtils.angle(new Coordinate(coordinates[0]), coordinates[1]);
            }
            Coordinate coordinatePlane = new Coordinate(pointPlane.getX() + realAltitude * Math.cos(radian), pointPlane.getY() + realAltitude * Math.sin(radian));
            Point point1 = (Point)GeoUtils.fromPlane((Geometry)geometryFactory.createPoint(coordinatePlane), planeSrid);
            PhotoPoint photoPointXie = FlyUtil.generateXiePhotoPoint2(tuban, point1.getCoordinate());
            goPoints.add(FlyUtil.wrapPhotoPoint(photoPointXie, tuban));
            if (++count != 1 || xieNeed != 2) continue;
            Coordinate coordinatePlane2 = new Coordinate(pointPlane.getX() - realAltitude * Math.cos(radian), pointPlane.getY() - realAltitude * Math.sin(radian));
            Point point2 = (Point)GeoUtils.fromPlane((Geometry)geometryFactory.createPoint(coordinatePlane2), planeSrid);
            PhotoPoint photoPointXie2 = FlyUtil.generateXiePhotoPoint2(tuban, point2.getCoordinate());
            goPoints.add(FlyUtil.wrapPhotoPoint(photoPointXie2, tuban));
        }
        Coordinate startCoordinate = backLineString.getCoordinates()[1];
        List sortedBackPhotoPoints = FlyUtil.simpleSortCoordinateAble(startCoordinate, backPoints);
        Collections.reverse(sortedBackPhotoPoints);
        Coordinate endStartCoordinate = startCoordinate;
        if (!sortedBackPhotoPoints.isEmpty()) {
            endStartCoordinate = ((GroupPhotoPoint)sortedBackPhotoPoints.get(0)).getCoordinate();
        }
        List<GroupPhotoPoint> sortedGoPhotoPoints = FlyUtil.sortCoordinateAble(startCoordinate, goPoints, endStartCoordinate);
        sortedGoPhotoPoints.addAll(sortedBackPhotoPoints);
        return sortedGoPhotoPoints;
    }

    private static boolean valid(GroupPhotoPoint lastPhotoPointXie, GroupPhotoPoint photoPointsXie, double xieMinAngle) {
        double orientation1;
        double orientation = lastPhotoPointXie.getOrientation();
        double diff = Math.abs(orientation - (orientation1 = photoPointsXie.getOrientation()));
        if (diff > 180.0) {
            diff = 180.0;
        }
        return diff >= xieMinAngle;
    }

    private static List<GroupPhotoPoint> findPhotoPointsXie(int planeSrid, LineString lineString, LinearRing ring, Tuban tuban) {
        ArrayList<GroupPhotoPoint> result = new ArrayList<GroupPhotoPoint>();
        LineString lineStringPlane = (LineString)GeoUtils.toPlane((Geometry)lineString, planeSrid);
        Geometry intersectionPlane = lineStringPlane.intersection((Geometry)ring);
        if (intersectionPlane != null && !intersectionPlane.isEmpty()) {
            Geometry intersection = GeoUtils.fromPlane(intersectionPlane, planeSrid);
            for (Coordinate coordinate : intersection.getCoordinates()) {
                PhotoPoint photoPoint = FlyUtil.generateXiePhotoPoint2(tuban, coordinate);
                result.add(FlyUtil.wrapPhotoPoint(photoPoint, tuban));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String json = "[\n  {\n    \"x\": 120.18954,\n    \"y\": 30.40691,\n    \"z\": 29.7451,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.18954,\n    \"y\": 30.40691,\n    \"z\": 224.7451,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.191852299,\n    \"y\": 30.411713386,\n    \"z\": 228.40174672851563,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.190958798,\n    \"y\": 30.40985736,\n    \"z\": 229.89967153320313,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.189774913,\n    \"y\": 30.410836114,\n    \"z\": 230.98565480957032,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.181443698,\n    \"y\": 30.40731738,\n    \"z\": 204.24288747558595,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.179623197,\n    \"y\": 30.406548377,\n    \"z\": 205.4407787109375,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.178195809,\n    \"y\": 30.405294705,\n    \"z\": 206.39486501464845,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.177542428,\n    \"y\": 30.400508927,\n    \"z\": 203.41625783691407,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.177328557,\n    \"y\": 30.400403834,\n    \"z\": 203.7659740234375,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.172981532,\n    \"y\": 30.400714607,\n    \"z\": 203.64791677246095,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.171554314,\n    \"y\": 30.399460861,\n    \"z\": 203.4195384765625,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.173538585,\n    \"y\": 30.39949922,\n    \"z\": 204.4981975341797,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.173583142,\n    \"y\": 30.399500081,\n    \"z\": 204.4931926513672,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.175567415,\n    \"y\": 30.399538409,\n    \"z\": 203.07475087890626,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.175781282,\n    \"y\": 30.399643505,\n    \"z\": 203.37037465820313,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.178901297,\n    \"y\": 30.399206071,\n    \"z\": 204.9871654296875,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.17927668,\n    \"y\": 30.398846153,\n    \"z\": 204.07600209960938,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.180635503,\n    \"y\": 30.397543279,\n    \"z\": 203.02697561035157,\n    \"m\": \"NaN\",\n    \"valid\": true\n  },\n  {\n    \"x\": 120.181922408,\n    \"y\": 30.398897136,\n    \"z\": 203.59179494628907,\n    \"m\": \"NaN\",\n    \"valid\": true\n  }\n]";
        List tubans = JSONUtil.parseArray((String)json).stream().map(j -> {
            Double x = ((JSONObject)j).getDouble((Object)"x");
            Double y = ((JSONObject)j).getDouble((Object)"y");
            Tuban tuban = new Tuban();
            tuban.setCenterLon(x);
            tuban.setCenterLat(y);
            return tuban;
        }).collect(Collectors.toList());
        Object[] coordinates = (Coordinate[])tubans.stream().map(Tuban::getCoordinate).toArray(Coordinate[]::new);
        coordinates = (Coordinate[])ArrayUtil.append((Object[])coordinates, (Object[])new Coordinate[]{coordinates[0]});
        LineString lineString = geometryFactory.createLineString((Coordinate[])coordinates);
        System.out.println(lineString.toText());
        System.out.println(lineString.getLength());
        Coordinate start = ((Tuban)tubans.get(0)).getCoordinate();
        List list = FlyUtil.sortCoordinateAble(start, tubans, start);
        list.remove(list.size() - 1);
        Coordinate[] coordinates1 = (Coordinate[])list.stream().map(Tuban::getCoordinate).toArray(Coordinate[]::new);
        LineString lineString1 = geometryFactory.createLineString(coordinates1);
        System.out.println(lineString1.toText());
        System.out.println(lineString1.getLength());
    }
}

