/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import com.geoway.flylib.GeoPoint;
import java.util.ArrayList;

public class GeoBound {
    public GeoPoint mGeoCenter;
    public int mLongSpanE6;
    public int mLatSpanE6;

    public GeoBound(ArrayList<GeoPoint> latlons) {
        double top;
        double left;
        if (latlons == null || latlons.size() == 0) {
            return;
        }
        double right = left = GeoBound.getdX(latlons.get(0));
        double bottom = top = GeoBound.getdY(latlons.get(0));
        for (GeoPoint pos : latlons) {
            double tempX = GeoBound.getdX(pos);
            double tempY = GeoBound.getdY(pos);
            if (left > tempX) {
                left = tempX;
            } else if (right < tempX) {
                right = tempX;
            }
            if (top < tempY) {
                top = tempY;
                continue;
            }
            if (!(bottom > tempY)) continue;
            bottom = tempY;
        }
        double centerX = (left + right) / 2.0;
        double centerY = (top + bottom) / 2.0;
        this.mGeoCenter = GeoBound.Double2GeoPoint(centerX, centerY);
        this.mLongSpanE6 = (int)((right - left) * 1000000.0);
        this.mLatSpanE6 = (int)((bottom - top) * 1000000.0);
    }

    public boolean isValid() {
        return this.mGeoCenter != null;
    }

    public void clear() {
        this.mGeoCenter = null;
        this.mLongSpanE6 = 0;
        this.mLatSpanE6 = 0;
    }

    public void union(GeoBound bound) {
        if (bound == null || !bound.isValid()) {
            return;
        }
        if (!this.isValid()) {
            this.mGeoCenter = new GeoPoint(bound.mGeoCenter.getLatitudeE6(), bound.mGeoCenter.getLongitudeE6());
            this.mLongSpanE6 = bound.mLongSpanE6;
            this.mLatSpanE6 = bound.mLatSpanE6;
            return;
        }
        int left = bound.getLeft();
        int right = bound.getRight();
        int top = bound.getTop();
        int bottom = bound.getBottom();
        int leftSrc = this.getLeft();
        int rightSrc = this.getRight();
        int topSrc = this.getTop();
        int bottomSrc = this.getBottom();
        if (left > leftSrc) {
            left = leftSrc;
        }
        if (right < rightSrc) {
            right = rightSrc;
        }
        if (top < topSrc) {
            top = topSrc;
        }
        if (bottom > bottomSrc) {
            bottom = bottomSrc;
        }
        this.mGeoCenter = new GeoPoint((top + bottom) / 2, (left + right) / 2);
        this.mLongSpanE6 = right - left;
        this.mLatSpanE6 = bottom - top;
    }

    public void union(GeoPoint point) {
        if (point == null) {
            return;
        }
        if (!this.isValid()) {
            this.mGeoCenter = new GeoPoint(point.getLatitudeE6(), point.getLongitudeE6());
            this.mLongSpanE6 = 0;
            this.mLatSpanE6 = 0;
            return;
        }
        int left = this.getLeft();
        int right = this.getRight();
        int top = this.getTop();
        int bottom = this.getBottom();
        if (left > point.getLongitudeE6()) {
            left = point.getLongitudeE6();
        }
        if (right < point.getLongitudeE6()) {
            right = point.getLongitudeE6();
        }
        if (top < point.getLatitudeE6()) {
            top = point.getLatitudeE6();
        }
        if (bottom > point.getLatitudeE6()) {
            bottom = point.getLatitudeE6();
        }
        this.mGeoCenter = new GeoPoint((top + bottom) / 2, (left + right) / 2);
        this.mLongSpanE6 = right - left;
        this.mLatSpanE6 = bottom - top;
    }

    public boolean intersects(GeoBound bound) {
        return this.getLeft() < bound.getRight() && bound.getLeft() < this.getRight() && this.getTop() > bound.getBottom() && bound.getTop() > this.getBottom();
    }

    public int getLeft() {
        if (!this.isValid()) {
            return 0;
        }
        return this.mGeoCenter.getLongitudeE6() - this.mLongSpanE6 / 2;
    }

    public int getRight() {
        if (!this.isValid()) {
            return 0;
        }
        return this.mGeoCenter.getLongitudeE6() + this.mLongSpanE6 / 2;
    }

    public int getTop() {
        if (!this.isValid()) {
            return 0;
        }
        return this.mGeoCenter.getLatitudeE6() - this.mLatSpanE6 / 2;
    }

    public int getBottom() {
        if (!this.isValid()) {
            return 0;
        }
        return this.mGeoCenter.getLatitudeE6() + this.mLatSpanE6 / 2;
    }

    public static double getdX(GeoPoint geo) {
        return (double)geo.getLongitudeE6() / 1000000.0;
    }

    public static double getdY(GeoPoint geo) {
        return (double)geo.getLatitudeE6() / 1000000.0;
    }

    public static GeoPoint Double2GeoPoint(double x, double y) {
        GeoPoint geo = new GeoPoint((int)(y * 1000000.0), (int)(x * 1000000.0));
        return geo;
    }
}

