/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import com.geoway.flylib.GeoPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.ArrayList;
import java.util.List;

public class GeoUtil {
    public static final double EARTH_RADIUS = 6378137.0;

    public static List<Geometry> getSimpleGeomListFromGeom(Geometry geom) {
        ArrayList<Geometry> simpleGeomList = new ArrayList<Geometry>();
        if (geom == null) {
            return simpleGeomList;
        }
        String geometryType = geom.getGeometryType();
        if (geometryType.equalsIgnoreCase("Polygon")) {
            simpleGeomList.add(geom);
        } else if (geometryType.equalsIgnoreCase("MultiPolygon")) {
            MultiPolygon mPolygon = (MultiPolygon)geom;
            int count = mPolygon.getNumGeometries();
            for (int i = 0; i < count; ++i) {
                Geometry subGeom = mPolygon.getGeometryN(i);
                simpleGeomList.addAll(GeoUtil.getSimpleGeomListFromGeom(subGeom));
            }
        }
        return simpleGeomList;
    }

    public static Geometry getGeoFromWkb(byte[] wkb) {
        if (wkb == null || wkb.length == 0) {
            return null;
        }
        WKBReader reader = new WKBReader();
        try {
            return reader.read(wkb);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Geometry getGeoFromWkt(String wkt) {
        if (wkt == null || wkt.length() == 0) {
            return null;
        }
        WKTReader reader = new WKTReader();
        try {
            return reader.read(wkt);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWktFromWkb(byte[] wkb) {
        if (wkb == null || wkb.length == 0) {
            return null;
        }
        WKBReader reader = new WKBReader();
        try {
            Geometry geometry = reader.read(wkb);
            WKTWriter writer = new WKTWriter();
            return writer.write(geometry);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getWkbFromWkt(String wkt) {
        if (wkt == null || wkt.length() == 0) {
            return null;
        }
        WKTReader reader = new WKTReader();
        try {
            Geometry geometry = reader.read(wkt);
            WKBWriter writer = new WKBWriter();
            return writer.write(geometry);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Geometry> getSimpleGeometries(String wkt) {
        Geometry geometry = GeoUtil.getGeoFromWkt(wkt);
        return GeoUtil.getSimpleGeometries(geometry);
    }

    public static List<Geometry> getSimpleGeometries(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        ArrayList<Geometry> geometryList = new ArrayList<Geometry>();
        String geometryType = geometry.getGeometryType();
        if (geometryType.equalsIgnoreCase("MultiPolygon")) {
            MultiPolygon mPolygon = (MultiPolygon)geometry;
            int count = mPolygon.getNumGeometries();
            for (int i = 0; i < count; ++i) {
                Geometry subGeom = mPolygon.getGeometryN(i);
                List<Geometry> subGeometryList = GeoUtil.getSimpleGeometries(subGeom);
                if (subGeometryList == null || subGeometryList.size() <= 0) continue;
                geometryList.addAll(subGeometryList);
            }
        } else if (geometryType.equalsIgnoreCase("Polygon")) {
            geometryList.add(geometry);
        }
        return geometryList;
    }

    public static GeoPoint getCenterPoint(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom.getCentroid() != null) {
            return new GeoPoint((int)(geom.getCentroid().getY() * 1000000.0), (int)(geom.getCentroid().getX() * 1000000.0));
        }
        return null;
    }

    public static GeoPoint getCenterPoint(String shape) {
        if (shape != null && !shape.equals("")) {
            Geometry geometry = GeoUtil.getGeoFromWkt(shape);
            return GeoUtil.getCenterPoint(geometry);
        }
        return null;
    }

    public static List<GeoPoint> getListPointsFromWkt(String wkt) {
        if (wkt == null || wkt.length() == 0) {
            return null;
        }
        WKTReader reader = new WKTReader();
        Geometry geometry = null;
        try {
            geometry = reader.read(wkt);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        if (geometry == null) {
            return null;
        }
        return GeoUtil.getListPoints(geometry);
    }

    public static List<GeoPoint> getListPoints(Geometry geom) {
        ArrayList<GeoPoint> geoPoints;
        block7: {
            block8: {
                String geometryType;
                block6: {
                    int i;
                    if (geom == null) {
                        return null;
                    }
                    geoPoints = new ArrayList<GeoPoint>();
                    geometryType = geom.getGeometryType();
                    if (!geometryType.equalsIgnoreCase("Polygon")) break block6;
                    Polygon py = (Polygon)geom;
                    Coordinate[] coordinate = py.getExteriorRing().getCoordinates();
                    for (i = 0; i < coordinate.length; ++i) {
                        geoPoints.add(new GeoPoint((int)(coordinate[i].y * 1000000.0), (int)(coordinate[i].x * 1000000.0)));
                    }
                    for (i = 0; i < py.getNumInteriorRing(); ++i) {
                        Coordinate[] inCoordinate = py.getInteriorRingN(i).getCoordinates();
                        for (int j = 0; j < inCoordinate.length; ++j) {
                            geoPoints.add(new GeoPoint((int)(inCoordinate[j].y * 1000000.0), (int)(inCoordinate[j].x * 1000000.0)));
                        }
                    }
                    break block7;
                }
                if (!geometryType.equalsIgnoreCase("MultiPolygon")) break block8;
                MultiPolygon mPolygon = (MultiPolygon)geom;
                int count = mPolygon.getNumGeometries();
                for (int i = 0; i < count; ++i) {
                    Geometry subGeom = mPolygon.getGeometryN(i);
                    geoPoints.addAll(GeoUtil.getListPoints(subGeom));
                }
                break block7;
            }
            Coordinate[] coordinates = geom.getCoordinates();
            if (coordinates == null) break block7;
            for (int i = 0; i < coordinates.length; ++i) {
                geoPoints.add(new GeoPoint((int)(coordinates[i].y * 1000000.0), (int)(coordinates[i].x * 1000000.0)));
            }
        }
        return geoPoints;
    }

    public static boolean checkGpsCoordination(double latitude, double longitude) {
        return latitude > 0.0 && latitude < 60.0 && longitude > 70.0 && longitude < 140.0;
    }

    public static GeoPoint getGeoPoint(double lat, double lon) {
        return new GeoPoint((int)(lat * 1000000.0), (int)(lon * 1000000.0));
    }

    public static Coordinate getCoordFromGeoPoint(GeoPoint gp) {
        if (gp == null) {
            return null;
        }
        return new Coordinate((double)(1.0f * (float)gp.getLongitudeE6()) / 1000000.0, (double)(1.0f * (float)gp.getLatitudeE6()) / 1000000.0);
    }

    public static Geometry getGeometryFromGps(List<GeoPoint> gps) {
        if (gps == null || gps.size() == 0) {
            return null;
        }
        Coordinate[] coordinates = new Coordinate[gps.size()];
        for (int i = 0; i < gps.size(); ++i) {
            coordinates[i] = GeoUtil.getCoordFromGeoPoint(gps.get(i));
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        if (gps.size() == 1) {
            return geometryFactory.createPoint(coordinates[0]);
        }
        if (gps.size() == 2) {
            return geometryFactory.createLinearRing(coordinates);
        }
        return geometryFactory.createPolygon(geometryFactory.createLinearRing(coordinates), null);
    }

    public static String getJtsGeoWkt(Geometry jtsGeometry) {
        if (jtsGeometry == null) {
            return null;
        }
        try {
            WKTWriter writer = new WKTWriter();
            return writer.write(jtsGeometry);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

