/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import com.geoway.flylib.util.GeoUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class MapPos3857 {
    private static final GeometryFactory geometryFactory = new GeometryFactory();
    private double x;
    private double y;

    public MapPos3857(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public static MapPos3857 fromGeography(Double lon, Double lat) {
        if (lon == null || lat == null) {
            lon = 118.0;
            lat = 30.0;
        }
        Point point = geometryFactory.createPoint(new Coordinate(lon.doubleValue(), lat.doubleValue()));
        point.setSRID(4490);
        Point point1 = (Point)GeoUtils.toPlane((Geometry)point, 3857);
        return new MapPos3857(point1.getX(), point1.getY());
    }

    public Coordinate get4490Coordinate() {
        Point point = geometryFactory.createPoint(new Coordinate(this.x, this.y));
        point.setSRID(3857);
        Point point1 = (Point)GeoUtils.sridTransForm((Geometry)point, 3857, 4490);
        return point1.getCoordinate();
    }
}

