/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import com.geoway.flylib.DigitUtil;
import com.geoway.flylib.GeoPoint;
import com.geoway.flylib.GeoUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PhotoPoint
implements Serializable {
    private String id = "";
    private String groupId = "";
    private String genFromTbId = "";
    private double lon;
    private double lat;
    private double altitude;
    private double elevation;
    private float orientation;
    private float yuntai;
    private double takeOffLon;
    private double takeOffLat;
    private double takeOffRelHeight;
    private double takeOffAltitude;
    private double xdgd = -9999.0;
    private double jdgd = -9999.0;
    private boolean isZheng = false;
    private boolean isSel = false;
    private double zoom = 1.0;
    private List<String> linkTbIds = new ArrayList<String>();

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public float getOrientation() {
        return this.orientation;
    }

    public void setOrientation(float orientation) {
        this.orientation = orientation;
    }

    public float getYuntai() {
        return this.yuntai;
    }

    public void setYuntai(float yuntai) {
        this.yuntai = yuntai;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public boolean isYuntaiZheng() {
        return !(this.yuntai - -90.0f > 1.0f);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGenFromTbId() {
        return this.genFromTbId;
    }

    public void setGenFromTbId(String genFromTbId) {
        this.genFromTbId = genFromTbId;
    }

    public boolean isZheng() {
        return this.isZheng;
    }

    public void setZheng(boolean zheng) {
        this.isZheng = zheng;
    }

    public double getTakeOffLon() {
        if (Double.isNaN(this.takeOffLon)) {
            return 0.0;
        }
        return this.takeOffLon;
    }

    public void setTakeOffLon(double takeOffLon) {
        this.takeOffLon = takeOffLon;
    }

    public double getTakeOffLat() {
        if (Double.isNaN(this.takeOffLat)) {
            return 0.0;
        }
        return this.takeOffLat;
    }

    public void setTakeOffLat(double takeOffLat) {
        this.takeOffLat = takeOffLat;
    }

    public double getTakeOffRelHeight() {
        if (Double.isNaN(this.takeOffRelHeight)) {
            return 0.0;
        }
        return this.takeOffRelHeight;
    }

    public void setTakeOffRelHeight(double takeOffRelHeight) {
        this.takeOffRelHeight = takeOffRelHeight;
    }

    public double getTakeOffAltitude() {
        if (Double.isNaN(this.takeOffAltitude)) {
            return 0.0;
        }
        return this.takeOffAltitude;
    }

    public void setTakeOffAltitude(double takeOffAltitude) {
        this.takeOffAltitude = takeOffAltitude;
    }

    public double getXdgd() {
        return this.xdgd;
    }

    public void setXdgd(double xdgd) {
        this.xdgd = DigitUtil.format2(xdgd);
    }

    public double getJdgd() {
        return this.jdgd;
    }

    public void setJdgd(double jdgd) {
        this.jdgd = DigitUtil.format2(jdgd);
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint((int)(this.lat * 1000000.0), (int)(this.lon * 1000000.0));
    }

    public PhotoPoint copy() {
        PhotoPoint photoPoint = new PhotoPoint();
        photoPoint.setId(this.id);
        photoPoint.setGroupId(this.groupId);
        photoPoint.setGenFromTbId(this.genFromTbId);
        photoPoint.setLon(this.lon);
        photoPoint.setLat(this.lat);
        photoPoint.setAltitude(this.altitude);
        photoPoint.setElevation(this.elevation);
        photoPoint.setOrientation(this.orientation);
        photoPoint.setYuntai(this.yuntai);
        photoPoint.setZheng(this.isZheng);
        photoPoint.setTakeOffLon(this.takeOffLon);
        photoPoint.setTakeOffLat(this.takeOffLat);
        photoPoint.setTakeOffRelHeight(this.takeOffRelHeight);
        photoPoint.setTakeOffAltitude(this.takeOffAltitude);
        return photoPoint;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PhotoPoint pp = (PhotoPoint)obj;
        return Objects.equals(this.id, pp.getId()) && Objects.equals(this.groupId, pp.getGroupId()) && Objects.equals(this.genFromTbId, pp.getGenFromTbId()) && Objects.equals(String.valueOf(this.lon), String.valueOf(pp.getLon())) && Objects.equals(String.valueOf(this.lat), String.valueOf(pp.getLat())) && this.altitude == pp.getAltitude() && this.yuntai == pp.getYuntai() && this.orientation == pp.getOrientation() && this.isZheng == pp.isZheng() && Objects.equals(String.valueOf(this.takeOffLon), String.valueOf(pp.getTakeOffLon())) && Objects.equals(String.valueOf(this.takeOffLat), String.valueOf(pp.getTakeOffLat())) && Objects.equals(String.valueOf(this.takeOffAltitude), String.valueOf(pp.getTakeOffAltitude())) && Objects.equals(String.valueOf(this.takeOffRelHeight), String.valueOf(pp.getTakeOffRelHeight()));
    }

    public String toString() {
        return "PhotoPoint{id='" + this.id + '\'' + ", groupId='" + this.groupId + '\'' + ", genFromTbId='" + this.genFromTbId + '\'' + ", lon=" + this.lon + ", lat=" + this.lat + ", altitude=" + this.altitude + ", orientation=" + this.orientation + ", yuntai=" + this.yuntai + ", isZheng=" + this.isZheng + ", takeOffLon=" + this.takeOffLon + ", takeOffLat=" + this.takeOffLat + ", takeOffRelHeight=" + this.takeOffRelHeight + ", takeOffAltitude=" + this.takeOffAltitude + '}';
    }

    public boolean isLonLatValid() {
        return GeoUtil.checkGpsCoordination(this.lat, this.lon);
    }

    public List<String> getLinkTbIds() {
        return this.linkTbIds;
    }

    public void setLinkTbIds(List<String> linkTbIds) {
        this.linkTbIds = linkTbIds;
    }

    public boolean isSel() {
        return this.isSel;
    }

    public void setSel(boolean sel) {
        this.isSel = sel;
    }
}

