/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.flylib.MapPos3857;
import com.geoway.flylib.util.GeoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.AffineTransformation;

public class PhotoRangeCalculate {
    private static final GeometryFactory geometryFactory = new GeometryFactory();

    public static void main(String[] args) {
        PhotoRangeCalculate.getEnvelope();
    }

    private static void getDistance(double yuntai, double h, double zoom) {
        double viewAngleWith = 71.0;
        double rw = Math.toRadians(viewAngleWith / 2.0);
        double R = h * Math.tan(rw) / zoom;
        double r = R * 0.75;
        double rw1 = Math.atan(R / h);
        double rh1 = Math.atan(r / h);
        double a = Math.toRadians(90.0 + yuntai);
        double[] diff = PhotoRangeCalculate.diff(h, a + rh1, rw1);
        double[] diff1 = PhotoRangeCalculate.diff(h, a - rh1, rw1);
        System.out.println(diff[0] + " " + diff[1]);
        System.out.println(diff1[0] + " " + diff1[1]);
    }

    private static void getEnvelope() {
        String value = "{\n  \"aircraft\": {\n    \"x\": 13173546.384774055,\n    \"y\": 4841148.25596041\n  },\n  \"altitude\": 152.245,\n  \"angleOfView\": 71,\n  \"isFollowOrientation\": true,\n  \"orientation\": -142.9,\n  \"yuntai\": -45.2,\n  \"zoom\": 6.3\n}";
        JSONObject jsonObject = JSONUtil.parseObj((String)value);
        JSONObject aircraft = jsonObject.getJSONObject((Object)"aircraft");
        Double x = aircraft.getDouble((Object)"x");
        Double y = aircraft.getDouble((Object)"y");
        Coordinate coordinate = new Coordinate(x.doubleValue(), y.doubleValue());
        Point point3857 = geometryFactory.createPoint(coordinate);
        point3857.setSRID(3857);
        Point point4490 = (Point)GeoUtils.sridTransForm((Geometry)point3857, 3857, 4490);
        double altitude = jsonObject.getDouble((Object)"altitude");
        double orientation = jsonObject.getDouble((Object)"orientation");
        double yuntai = jsonObject.getDouble((Object)"yuntai");
        double zoom = jsonObject.getDouble((Object)"zoom");
        List<Coordinate> coordinates = PhotoRangeCalculate.get4490Coordinates(new MapPos3857(coordinate.getX(), coordinate.getY()), altitude, orientation, yuntai, 71.0, 0.75, zoom);
        coordinates.add(0, point4490.getCoordinate());
        LineString lineString = geometryFactory.createLineString(coordinates.toArray(new Coordinate[0]));
        System.out.println(lineString.toText());
    }

    public static List<MapPos3857> getPhoto3857RangePosList(MapPos3857 mapPos3857, double altitude, double orientation, double yuntai, double angleOfView, float ratio, double zoom) {
        List<Coordinate> coordinates = PhotoRangeCalculate.get4490Coordinates(mapPos3857, altitude, orientation, yuntai, angleOfView, ratio, zoom);
        if (coordinates == null) {
            return null;
        }
        coordinates.remove(coordinates.size() - 1);
        return coordinates.stream().map(c -> MapPos3857.fromGeography(c.getX(), c.getY())).collect(Collectors.toList());
    }

    public static Envelope getObverseEnvelope(MapPos3857 mapPos3857, double altitude, double angleOfView, double ratio, int zoom) {
        List<Coordinate> coordinates = PhotoRangeCalculate.getPlaneCoordinates(mapPos3857, altitude, 0.0, -90.0, angleOfView, ratio, zoom);
        if (coordinates == null) {
            return null;
        }
        return geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0])).getEnvelopeInternal();
    }

    public static List<Coordinate> getPlaneCoordinates(MapPos3857 mapPos3857, double altitude, double orientation, double yuntai, double angleOfView, double ratio, double zoom) {
        List<Coordinate> coordinates = PhotoRangeCalculate.get4490Coordinates(mapPos3857, altitude, orientation, yuntai, angleOfView, ratio, zoom);
        if (coordinates == null) {
            return null;
        }
        int planeSrid = GeoUtils.getPlaneSrid(coordinates.get(0).getX());
        coordinates.forEach(c -> {
            Point point = geometryFactory.createPoint(new Coordinate(c.x, c.y));
            Point pointPlane = (Point)GeoUtils.toPlane((Geometry)point, planeSrid);
            c.setX(pointPlane.getX());
            c.setY(pointPlane.getY());
        });
        return coordinates;
    }

    public static List<Coordinate> get4490Coordinates(MapPos3857 mapPos3857, double altitude, double orientation, double yuntai, double angleOfView, double ratio, double zoom) {
        Point point3857 = geometryFactory.createPoint(new Coordinate(mapPos3857.getX(), mapPos3857.getY()));
        Point point4490 = (Point)GeoUtils.sridTransForm((Geometry)point3857, 3857, 4490);
        int planeSrid = GeoUtils.getPlaneSrid(point4490.getX());
        Point pointPlane = (Point)GeoUtils.sridTransForm((Geometry)point4490, 4490, planeSrid);
        if (yuntai >= 0.0) {
            return null;
        }
        double rw = Math.toRadians(angleOfView / 2.0);
        double R = altitude * Math.tan(rw) / zoom;
        double r = R * ratio;
        double rw1 = Math.atan(R / altitude);
        double rh1 = Math.atan(r / altitude);
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (yuntai == -90.0) {
            Coordinate cLeftTop = new Coordinate(pointPlane.getX() - R, pointPlane.getY() + r);
            Coordinate cRightTop = new Coordinate(pointPlane.getX() + R, pointPlane.getY() + r);
            Coordinate cRightBottom = new Coordinate(pointPlane.getX() + R, pointPlane.getY() - r);
            Coordinate cLeftBottom = new Coordinate(pointPlane.getX() - R, pointPlane.getY() - r);
            coordinates.add(cLeftTop);
            coordinates.add(cRightTop);
            coordinates.add(cRightBottom);
            coordinates.add(cLeftBottom);
        } else {
            double a = Math.toRadians(90.0 + yuntai);
            double rh2 = a + rh1;
            double[] diff = PhotoRangeCalculate.diff(altitude, rh2, rw1);
            Coordinate cLeftTop = new Coordinate(pointPlane.getX() - diff[0], pointPlane.getY() + diff[1]);
            Coordinate cRightTop = new Coordinate(pointPlane.getX() + diff[0], pointPlane.getY() + diff[1]);
            coordinates.add(cLeftTop);
            coordinates.add(cRightTop);
            double rh3 = a - rh1;
            double[] diff1 = PhotoRangeCalculate.diff(altitude, rh3, rw1);
            Coordinate cRightBottom = new Coordinate(pointPlane.getX() + diff1[0], pointPlane.getY() + diff1[1]);
            Coordinate cLeftBottom = new Coordinate(pointPlane.getX() - diff1[0], pointPlane.getY() + diff1[1]);
            coordinates.add(cRightBottom);
            coordinates.add(cLeftBottom);
        }
        if (orientation != 0.0) {
            AffineTransformation at = new AffineTransformation();
            at.rotate(-Math.toRadians(orientation), pointPlane.getX(), pointPlane.getY());
            coordinates.forEach(mp -> {
                Point point = geometryFactory.createPoint(mp);
                point.apply((CoordinateSequenceFilter)at);
                mp.setX(point.getX());
                mp.setY(point.getY());
            });
        }
        coordinates.forEach(mp -> {
            Point point = geometryFactory.createPoint(mp);
            Point point1 = (Point)GeoUtils.sridTransForm((Geometry)point, planeSrid, 4490);
            mp.setX(point1.getX());
            mp.setY(point1.getY());
        });
        coordinates.add(new Coordinate(((Coordinate)coordinates.get(0)).getX(), ((Coordinate)coordinates.get(0)).getY()));
        return coordinates;
    }

    private static double[] diff(double h, double rh, double rw) {
        double ywDiff = h * Math.tan(rh);
        double yDiff = h / Math.cos(rh);
        double xwDiff = yDiff * Math.tan(rw);
        return new double[]{xwDiff, ywDiff};
    }
}

