/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import com.geoway.flylib.GeoPoint;
import com.geoway.flylib.GeoPointEx;

public class Spatialcalculate {
    private static double MAPPROJECT_PI = Math.PI;
    private static double MAPPROJECT_EARTH_RADIUS = 6378137.0;

    public static float toMeters(GeoPoint point1, GeoPoint point2) {
        double lng1 = (double)(1.0f * (float)point1.getLongitudeE6()) / 1000000.0;
        double lat1 = (double)(1.0f * (float)point1.getLatitudeE6()) / 1000000.0;
        double lng2 = (double)(1.0f * (float)point2.getLongitudeE6()) / 1000000.0;
        double lat2 = (double)(1.0f * (float)point2.getLatitudeE6()) / 1000000.0;
        double radLat1 = Spatialcalculate.MAPPROJECT_RAD(lat1);
        double radLat2 = Spatialcalculate.MAPPROJECT_RAD(lat2);
        double a = radLat1 - radLat2;
        double b = Spatialcalculate.MAPPROJECT_RAD(lng1) - Spatialcalculate.MAPPROJECT_RAD(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= MAPPROJECT_EARTH_RADIUS;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return (float)s;
    }

    private static double MAPPROJECT_RAD(double d) {
        return d * MAPPROJECT_PI / 180.0;
    }

    public static double meterToRad(double mi) {
        return mi / (2.0 * MAPPROJECT_PI * MAPPROJECT_EARTH_RADIUS);
    }

    public static class PosInfo {
        public double mLon;
        public double mLat;

        public PosInfo() {
        }

        public PosInfo(GeoPoint geoPoint) {
            this.mLon = GeoPointEx.getdX(geoPoint);
            this.mLat = GeoPointEx.getdY(geoPoint);
        }

        public PosInfo(double dx, double dy) {
            this.mLon = dx;
            this.mLat = dy;
        }

        public GeoPoint getPoint() {
            return GeoPointEx.Double2GeoPoint(this.mLon, this.mLat);
        }

        public boolean equals(PosInfo info) {
            return this.mLat == info.mLat && this.mLon == info.mLon;
        }

        public boolean parse(String lonlat) {
            int position = lonlat.indexOf(",");
            if (position != -1) {
                this.mLon = Double.parseDouble(lonlat.substring(0, position));
                this.mLat = Double.parseDouble(lonlat.substring(position + 1));
                return true;
            }
            this.mLon = 0.0;
            this.mLat = 0.0;
            return false;
        }

        public boolean isValid() {
            return this.mLon != 0.0 || this.mLat != 0.0;
        }
    }
}

