/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib;

import com.geoway.flylib.CoordinateAble;
import com.geoway.flylib.GeoPoint;
import com.geoway.flylib.GeoUtil;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;

public class Tuban
extends CoordinateAble
implements Serializable {
    private String id;
    private String bizId;
    private String bianhao;
    private String wkt;
    private String tag;
    private double angle;
    private double centerLon;
    private double centerLat;
    private double mj;
    private double elevation = -9999.0;
    private long lastXfTime;
    private double zoom = 1.0;
    private double altitude = 0.0;
    private double rise = 0.0;
    private boolean grid = false;

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean grid) {
        this.grid = grid;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getRise() {
        return this.rise;
    }

    public void setRise(double rise) {
        this.rise = rise;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public void setCenterLon(double centerLon) {
        this.centerLon = centerLon;
    }

    public double getCenterLat() {
        return this.centerLat;
    }

    public void setCenterLat(double centerLat) {
        this.centerLat = centerLat;
    }

    public double getMj() {
        return this.mj;
    }

    public void setMj(double mj) {
        this.mj = mj;
    }

    public String getBianhao() {
        return this.bianhao;
    }

    public void setBianhao(String bianhao) {
        this.bianhao = bianhao;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getShowText() {
        if (this.bianhao != null && this.bianhao.length() > 0) {
            return this.bianhao;
        }
        return this.id;
    }

    public boolean isShapeSimple() {
        if (this.wkt == null || this.wkt.length() == 0) {
            return true;
        }
        Geometry geometry = GeoUtil.getGeoFromWkt(this.wkt);
        if (geometry == null) {
            return true;
        }
        String geoType = geometry.getGeometryType();
        return !geoType.toLowerCase().contains("multi");
    }

    public long getLastXfTime() {
        return this.lastXfTime;
    }

    public void setLastXfTime(long lastXfTime) {
        this.lastXfTime = lastXfTime;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Tuban tb = (Tuban)obj;
        return Objects.equals(this.id, tb.getId()) && Objects.equals(this.bizId, tb.getBizId()) && Objects.equals(this.bianhao, tb.getBianhao()) && Objects.equals(this.wkt, tb.getWkt()) && Objects.equals(this.tag, tb.getTag()) && Objects.equals(String.valueOf(this.centerLat), tb.getCenterLat()) && Objects.equals(String.valueOf(this.centerLon), tb.getCenterLon()) && Objects.equals(String.valueOf(this.mj), tb.getMj()) && this.lastXfTime == tb.getLastXfTime();
    }

    public String toString() {
        return "Tuban{id='" + this.id + '\'' + ", bizId='" + this.bizId + '\'' + ", bianhao='" + this.bianhao + '\'' + ", wkt='" + this.wkt + '\'' + ", tag='" + this.tag + '\'' + ", centerLon=" + this.centerLon + ", centerLat=" + this.centerLat + ", mj=" + this.mj + ", lastXfTime=" + this.lastXfTime + '}';
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint((int)(this.centerLat * 1000000.0), (int)(this.centerLon * 1000000.0));
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public Coordinate getCoordinate() {
        return new Coordinate(this.centerLon, this.centerLat);
    }
}

