/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib.data.grid;

import com.geoway.flylib.util.GeoUtils;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Grids;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridCreator {
    private CoordinateReferenceSystem crs;
    private GridFeatureBuilder gridFeatureBuilder;
    private Double sideLen;
    private Geometry geometry;

    public GridCreator(Double sideLen, Geometry geometry) {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null, sideLen, geometry);
    }

    public GridCreator(CoordinateReferenceSystem crs, Double sideLen, Geometry geometry) {
        this(crs, null, sideLen, geometry);
    }

    public GridCreator(GridFeatureBuilder gridFeatureBuilder, Double sideLen, Geometry geometry) {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, gridFeatureBuilder, sideLen, geometry);
    }

    public GridCreator(CoordinateReferenceSystem crs, GridFeatureBuilder gridFeatureBuilder, Double sideLen, Geometry geometry) {
        this.crs = crs;
        this.gridFeatureBuilder = gridFeatureBuilder;
        this.sideLen = sideLen;
        this.geometry = geometry;
    }

    private List<String> linestringSplit(Geometry geometry) {
        LinkedList<String> list = new LinkedList<String>();
        Coordinate[] coordinates = geometry.getCoordinates();
        block0: for (int i = 0; i < coordinates.length && i + 1 <= geometry.getCoordinates().length - 1; ++i) {
            Coordinate start = coordinates[i];
            Coordinate end = coordinates[i + 1];
            double deltaY = end.y - start.y;
            double deltaX = end.x - start.x;
            if (deltaX == 0.0 && deltaY == 0.0) continue;
            double degree = Math.atan(deltaY / deltaX);
            Geometry grid = GeoUtils.rotateGeometry(GeoUtils.createPoint(start.getX(), start.getY()).buffer(this.sideLen / 2.0, 1, 3), GeoUtils.createPoint(start.getX(), start.getY()), degree, false);
            list.add(grid.toText());
            while (true) {
                double realY;
                double realX;
                Coordinate[] coordinateArray = new Coordinate[]{start, end};
                if (!(GeoUtils.createLine(coordinateArray).getLength() > this.sideLen * 1.0 / 2.0)) continue block0;
                double x = this.sideLen * Math.cos(degree);
                double y = this.sideLen * Math.sin(degree);
                if (end.x >= start.x) {
                    realX = start.x + x;
                    realY = start.y + y;
                } else {
                    realX = start.x - x;
                    realY = start.y - y;
                }
                Point point = GeoUtils.createPoint(realX, realY);
                grid = GeoUtils.rotateGeometry(GeoUtils.createPoint(point.getX(), point.getY()).buffer(this.sideLen / 2.0, 1, 3), GeoUtils.createPoint(point.getX(), point.getY()), degree, false);
                list.add(grid.toText());
                start = new Coordinate(point.getX(), point.getY());
            }
        }
        return list;
    }

    private List<String> polygonSplit(Geometry geometry) {
        Envelope envelopeInternal = geometry.getEnvelopeInternal();
        double maxX = envelopeInternal.getMaxX();
        double minX = envelopeInternal.getMinX();
        double maxY = envelopeInternal.getMaxY();
        double minY = envelopeInternal.getMinY();
        if (maxX - minX < this.sideLen || (maxX - minX) % this.sideLen < this.sideLen) {
            maxX += this.sideLen.doubleValue();
        }
        if (maxY - minY < this.sideLen || (maxY - minY) % this.sideLen < this.sideLen) {
            maxY += this.sideLen.doubleValue();
        }
        try {
            ReferencedEnvelope gridBounds = new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            SimpleFeatureSource grid = this.gridFeatureBuilder == null ? Grids.createSquareGrid((ReferencedEnvelope)gridBounds, (double)this.sideLen) : Grids.createSquareGrid((ReferencedEnvelope)gridBounds, (double)this.sideLen, (double)-1.0, (GridFeatureBuilder)this.gridFeatureBuilder);
            LinkedList<String> gridList = new LinkedList<String>();
            SimpleFeatureIterator iterator = grid.getFeatures().features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry defaultGeometry = (Geometry)feature.getDefaultGeometry();
                gridList.add(defaultGeometry.toString());
            }
            return gridList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> create() {
        if (this.geometry == null) {
            return null;
        }
        if (this.geometry instanceof LineString) {
            return this.linestringSplit(this.geometry);
        }
        return this.polygonSplit(this.geometry);
    }
}

