/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib.data.grid;

import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridCreatorFeatureBuilder
extends GridFeatureBuilder {
    private final Geometry originGeometry;
    public static final String DEFAULT_TYPE_NAME = "grid";
    public static final String ID_ATTRIBUTE_NAME = "id";
    private int id;

    public GridCreatorFeatureBuilder(SimpleFeatureType type, Geometry originGeometry) {
        super(type);
        this.originGeometry = originGeometry;
    }

    protected static SimpleFeatureType createType(String typeName, CoordinateReferenceSystem crs) {
        String finalName = typeName != null && typeName.trim().length() > 0 ? typeName : DEFAULT_TYPE_NAME;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(finalName);
        tb.add("element", Polygon.class, crs);
        tb.add(ID_ATTRIBUTE_NAME, Integer.class);
        return tb.buildFeatureType();
    }

    public GridCreatorFeatureBuilder(Geometry originGeometry, CoordinateReferenceSystem crs) {
        super(GridCreatorFeatureBuilder.createType(DEFAULT_TYPE_NAME, crs));
        this.originGeometry = originGeometry;
    }

    public void setAttributes(GridElement el, Map<String, Object> attributes) {
        attributes.put(ID_ATTRIBUTE_NAME, ++this.id);
    }

    public boolean getCreateFeature(GridElement el) {
        return this.originGeometry.intersects(el.toGeometry());
    }
}

