/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Grids;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeoTool {
    public static void intersectGeoJSON(String geoJsonFile1, String geoJsonFile2, String savegeoJsonFile3) throws Exception {
        File sourceFile = new File(geoJsonFile1);
        File targetFile = new File(geoJsonFile2);
        FeatureJSON featureJSON = new FeatureJSON();
        byte[] bytes = Files.readAllBytes(sourceFile.toPath());
        String content = new String(bytes, StandardCharsets.UTF_8);
        SimpleFeatureCollection sourceFeatures = (SimpleFeatureCollection)featureJSON.readFeatureCollection((Object)GeoTool.readFileToString(sourceFile));
        SimpleFeatureCollection targetFeatures = (SimpleFeatureCollection)featureJSON.readFeatureCollection((Object)GeoTool.readFileToString(targetFile));
        SimpleFeatureCollection intersectedFeatures = GeoTool.performIntersect(sourceFeatures, targetFeatures);
        File outputFile = new File(savegeoJsonFile3);
        GeoTool.writeFeatureCollection(intersectedFeatures, outputFile);
        System.out.println("\u76f8\u4ea4\u7684 .geojson \u6570\u636e\u5df2\u5199\u5165\u8f93\u51fa\u6587\u4ef6\uff1a" + outputFile.getAbsolutePath());
    }

    public static void writeFeatureCollection(SimpleFeatureCollection featureCollection, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        FeatureJSON featureJSON = new FeatureJSON();
        featureJSON.writeFeatureCollection((FeatureCollection)featureCollection, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    public static String readFileToString(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SimpleFeatureCollection performIntersect(SimpleFeatureCollection sourceFeatures, SimpleFeatureCollection targetFeatures) {
        ArrayList<SimpleFeature> intersectedFeatureList = new ArrayList<SimpleFeature>();
        SimpleFeatureType featureType = GeoTool.createFeatureType((SimpleFeature)sourceFeatures.features().next());
        try (SimpleFeatureIterator sourceIterator = sourceFeatures.features();){
            block10: while (sourceIterator.hasNext()) {
                SimpleFeature sourceFeature = (SimpleFeature)sourceIterator.next();
                Geometry sourceGeometry = (Geometry)sourceFeature.getDefaultGeometry();
                SimpleFeatureIterator targetIterator = targetFeatures.features();
                try {
                    while (targetIterator.hasNext()) {
                        SimpleFeature targetFeature = (SimpleFeature)targetIterator.next();
                        Geometry targetGeometry = (Geometry)targetFeature.getDefaultGeometry();
                        if (!sourceGeometry.intersects(targetGeometry)) continue;
                        Geometry intersection = sourceGeometry.intersection(targetGeometry);
                        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
                        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                        double area = intersection.getArea() / 1000000.0;
                        featureBuilder.set("orarea", sourceFeature.getAttribute("area"));
                        featureBuilder.set("area", (Object)area);
                        featureBuilder.set("geometry", (Object)intersection);
                        SimpleFeature feature = featureBuilder.buildFeature(null);
                        intersectedFeatureList.add(feature);
                        continue block10;
                    }
                }
                finally {
                    if (targetIterator == null) continue;
                    targetIterator.close();
                }
            }
            return GeoTool.featureListToCollection(intersectedFeatureList, featureType);
        }
    }

    private static SimpleFeatureType createFeatureType(SimpleFeature sourceFeature) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("GeometryFeature");
        typeBuilder.setCRS(sourceFeature.getFeatureType().getCoordinateReferenceSystem());
        typeBuilder.add("geometry", Geometry.class);
        typeBuilder.add("orarea", Double.class);
        typeBuilder.add("area", Double.class);
        return typeBuilder.buildFeatureType();
    }

    private static SimpleFeatureCollection featureListToCollection(List<SimpleFeature> featureList, SimpleFeatureType featureType) {
        return new ListFeatureCollection(featureType, featureList);
    }

    private static String convertToGeoJson(MultiPolygon geometry, SimpleFeatureType featureType) throws IOException {
        FeatureJSON featureJSON = new FeatureJSON();
        StringWriter writer = new StringWriter();
        featureJSON.writeFeatureCollection((FeatureCollection)geometry, (Object)writer);
        return writer.toString();
    }

    private static Geometry projectGeometry(Geometry geometry, MathTransform transform) {
        try {
            return JTS.transform((Geometry)geometry, (MathTransform)transform);
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static MathTransform createTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        MathTransform transform = null;
        try {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return transform;
    }

    public static double Distance(double lng1, double lat1, double lng2, double lat2) {
        double d = Math.PI / 180;
        double f = lat1 * d;
        double h = lat2 * d;
        double i = lng2 * d - lng1 * d;
        double e = (1.0 - Math.cos(h - f) + (1.0 - Math.cos(i)) * Math.cos(f) * Math.cos(h)) / 2.0;
        return 1.2756274E7 * Math.asin(Math.sqrt(e));
    }

    public static double[][] CreateSimpleCircle(double lng, double lat, double radius, int pointCount) {
        double km = radius / 1000.0;
        double a = km < 5.0 ? 0.01 : (km < 50.0 ? 0.1 : (km < 500.0 ? 1.0 : 10.0));
        double b = GeoTool.Distance(lng, lat, lng + a, lat);
        double c = GeoTool.Distance(lng, lat, lng, lat + a);
        double rb = radius / b * a;
        double rc = radius / c * a;
        double[][] arr = new double[pointCount + 1][];
        double step = 360.0 / (double)pointCount;
        double N = 360.0 - step / 2.0;
        int i = 0;
        for (double n = 0.0; n < N; n += step) {
            double x = lng + rb * Math.cos(n * Math.PI / 180.0);
            double y = lat + rc * Math.sin(n * Math.PI / 180.0);
            arr[i] = new double[]{x, y};
            ++i;
        }
        arr[pointCount] = new double[]{arr[0][0], arr[0][1]};
        return arr;
    }

    public static String CreateSimpleCircleWKT(double lng, double lat, double radius, int pointCount) {
        double[][] points = GeoTool.CreateSimpleCircle(lng, lat, radius, pointCount);
        DecimalFormat df = new DecimalFormat("0.##########");
        StringBuilder wkt = new StringBuilder("POLYGON((");
        for (int i = 0; i < points.length; ++i) {
            if (i > 0) {
                wkt.append(",");
            }
            wkt.append(df.format(points[i][0]) + " " + df.format(points[i][1]));
        }
        wkt.append("))");
        return wkt.toString();
    }

    public static void testGrid() throws Exception {
        double sideLen = 0.001;
        String wkt = "POLYGON ((105.94528299700005 30.21016383600005, 105.94529897100006 30.21015118500003, 105.94531464000005 30.21014389900006, 105.94533234600004 30.210139839000078, 105.94537680900004 30.21013548700006, 105.94539227400008 30.21012707400007, 105.94539921000006 30.210117813000068, 105.94539799200004 30.21009076400003, 105.94540630100005 30.21004542600008, 105.94540976600007 30.209991916000035, 105.94540092600005 30.209893513000054, 105.94541038300008 30.209667872000068, 105.94540399500005 30.209615072000076, 105.94538444700004 30.20955481200008, 105.94535146900006 30.209478559000047, 105.94532169700005 30.209417164000058, 105.94522883400003 30.209262800000033, 105.94521034900004 30.209237683000026, 105.94518358800008 30.20921123100004, 105.94515940000008 30.209220852000044, 105.94515131900005 30.209244604000048, 105.94517576600003 30.20932868700004, 105.94522787300008 30.20946070100007, 105.94526887400008 30.20955619600005, 105.94531747000008 30.20965330000007, 105.94532944900004 30.209742625000047, 105.94532595000004 30.209794679000026, 105.94530255900008 30.209866851000072, 105.94528288400005 30.20991864000007, 105.94526105400007 30.209962008000048, 105.94524639200006 30.209979582000074, 105.94522741400004 30.209988913000075, 105.94519991800007 30.20999370800007, 105.94515853000007 30.209985732000064, 105.94513295000007 30.20996936800003, 105.94511148500004 30.209940103000065, 105.94510494500008 30.209920843000077, 105.94509567200004 30.209837247000053, 105.94506829400007 30.20974713700008, 105.94507227600008 30.209720446000063, 105.94515234600004 30.209674819000043, 105.94518594900006 30.209641376000036, 105.94519315200006 30.20961925900008, 105.94518748700006 30.209580687000027, 105.94516541600007 30.20948964200005, 105.94510314700005 30.209408131000032, 105.94505938600008 30.209373511000024, 105.94501110300007 30.209313879000035, 105.94498196800004 30.209258007000074, 105.94496945600008 30.209167732000026, 105.94497354000003 30.209150564000026, 105.94499452600007 30.20913077700004, 105.94502087000006 30.20911305100003, 105.94504152300004 30.209094863000075, 105.94505191600007 30.209078266000063, 105.94505841300008 30.209051182000053, 105.94502884200006 30.208950110000046, 105.94498565700007 30.208864919000064, 105.94492198400008 30.20871044200004, 105.94492069400007 30.208698154000047, 105.94492507300004 30.208687436000048, 105.94494817200007 30.208679800000027, 105.94500288200004 30.20866849300006, 105.94493811200005 30.208479476000036, 105.94491570300005 30.208429772000045, 105.94488434500005 30.208372522000047, 105.94484742200007 30.208317872000066, 105.94480452500005 30.208266601000048, 105.94475543800007 30.20821969800005, 105.94469981100008 30.20817821600008, 105.94467042100007 30.208160431000067, 105.94460691800003 30.208129404000033, 105.94453935000007 30.20810484900005, 105.94447199900009 30.208087017000025, 105.94443316300004 30.208079757000064, 105.94438385100005 30.208077509000077, 105.94428773300007 30.208094498000037, 105.94424290900008 30.208095394000054, 105.94421849600008 30.208089393000023, 105.94416412400005 30.208068294000043, 105.94411474300006 30.208056714000065, 105.94408905200004 30.208056801000055, 105.94401544000004 30.20806767600004, 105.94395429000008 30.208063627000058, 105.94395030700008 30.208033656000055, 105.94394017700006 30.208023894000064, 105.94380237200005 30.208017362000078, 105.94371497000009 30.20802967700007, 105.94367561500007 30.208029960000033, 105.94362441900006 30.208025097000075, 105.94362099500006 30.208046958000068, 105.94362121600005 30.20807014500008, 105.94360393300008 30.20809534700004, 105.94365030100005 30.208109190000073, 105.94367403900009 30.208123784000065, 105.94369341400005 30.20814126700003, 105.94371727000004 30.208168244000035, 105.94371581400009 30.208188259000053, 105.94370773300005 30.20820403500005, 105.94368339300007 30.208241361000034, 105.94366330700007 30.208256275000053, 105.94363288000005 30.20826992800005, 105.94356149200007 30.208282578000023, 105.94348238500004 30.20830628500005, 105.94340994900006 30.208335401000056, 105.94334039300008 30.20837195300004, 105.94329803200009 30.208400999000048, 105.94324133100008 30.208451565000075, 105.94320768900008 30.208488851000027, 105.94314460700008 30.20856581700008, 105.94311764300005 30.208587975000057, 105.94310280100007 30.20859673900003, 105.94307733500005 30.20860735000008, 105.94305043300005 30.208612886000026, 105.94302801500004 30.208612579000032, 105.94299805400004 30.20860390300004, 105.94296999800008 30.208587390000048, 105.94295464000004 30.208574879000025, 105.94292511700007 30.208544818000064, 105.94291379200007 30.208558468000035, 105.94289905800008 30.20856731500004, 105.94287826700008 30.208567926000057, 105.94285957600005 30.208559282000067, 105.94282895400005 30.20852570200003, 105.94279417200005 30.20847322800006, 105.94272175000003 30.208352895000075, 105.94268282600007 30.20825164300004, 105.94267561800007 30.20822630300006, 105.94266254100006 30.208160727000063, 105.94266346900008 30.20806194800008, 105.94265923500006 30.208021147000068, 105.94265373600007 30.207995519000065, 105.94264277200006 30.207976232000078, 105.94259826300004 30.207912085000032, 105.94256868700006 30.20787406000005, 105.94254789700005 30.207853428000078, 105.94244483000006 30.207791947000032, 105.94242259700007 30.207783231000064, 105.94240832100007 30.207805906000033, 105.94238418400005 30.207831533000046, 105.94236517100006 30.207843840000066, 105.94233663000006 30.207856804000073, 105.94228228300005 30.207877565000047, 105.94227285100004 30.207884129000036, 105.94226162400008 30.207901597000046, 105.94225558300008 30.207930563000048, 105.94225592100008 30.207949176000056, 105.94227596400003 30.208065591000036, 105.94227424000007 30.208082802000035, 105.94228273400006 30.208111875000043, 105.94230504800004 30.208153983000045, 105.94236231200006 30.208249556000055, 105.94250218600007 30.20853615900006, 105.94256122500008 30.20852955500004, 105.94259287100004 30.208522446000075, 105.94263406900006 30.208519398000078, 105.94264598100006 30.20852137600008, 105.94273499000008 30.20855655200006, 105.94274651600006 30.208569391000026, 105.94276877700008 30.208582813000078, 105.94277270200007 30.208592742000064, 105.94277097800006 30.208611267000038, 105.94276853000008 30.208623335000027, 105.94276399900008 30.20863055700005, 105.94272023600007 30.208655778000036, 105.94270131000007 30.20867750000008, 105.94270033600009 30.208773147000045, 105.94270442400006 30.208800515000064, 105.94272306500005 30.20884936400006, 105.94274945300003 30.208904089000043, 105.94276299600006 30.208919765000076, 105.94279281500008 30.208936985000037, 105.94280717200007 30.20893771200008, 105.94284349500003 30.20893496000008, 105.94289504700004 30.208923797000068, 105.94299874800004 30.208873727000025, 105.94301386300003 30.208861871000067, 105.94304150100004 30.208832302000076, 105.94304898900003 30.208819031000075, 105.94304545100005 30.20880290300005, 105.94303260700008 30.208786842000052, 105.94302825100004 30.208773656000062, 105.94302815300006 30.20876337800007, 105.94304066100005 30.208744197000044, 105.94306085300008 30.208732303000033, 105.94308198100003 30.20872994900003, 105.94311074400008 30.20872974200006, 105.94315523200004 30.20873497100007, 105.94317721600004 30.20873365700004, 105.94320315400006 30.20872768600003, 105.94324893300006 30.208705374000033, 105.94327547900008 30.20868308000007, 105.94333840400009 30.208641556000032, 105.94335755100008 30.208622328000047, 105.94336818100004 30.20861878200003, 105.94340017300004 30.208618552000075, 105.94343360400006 30.208622940000055, 105.94347305900004 30.208636540000043, 105.94348705000004 30.208635860000072, 105.94352615200006 30.208612440000024, 105.94353545100006 30.208608902000037, 105.94354944700007 30.20860880200007, 105.94356427900004 30.208613886000023, 105.94363168800004 30.20862323500006, 105.94377602000009 30.20862961100005, 105.94380366600006 30.20862551600004, 105.94383426200005 30.20861685400007, 105.94389458700005 30.208587197000043, 105.94390571100007 30.208576727000036, 105.94391355300007 30.208557641000027, 105.94390954600004 30.208455610000044, 105.94388689500005 30.208353223000074, 105.94389268600008 30.20823604800006, 105.94391700400007 30.20819291500004, 105.94398670300006 30.20815422700008, 105.94404978300008 30.208141840000053, 105.94413650200005 30.208159115000058, 105.94426730800006 30.20818919900006, 105.94436545300005 30.20823678000005, 105.94439593300007 30.20826923800007, 105.94446876400008 30.208307261000073, 105.94451392700006 30.208324181000023, 105.94454337000008 30.20834730100006, 105.94456509700007 30.208367533000057, 105.94457580200009 30.20837750100003, 105.94462357500004 30.208410272000037, 105.94467408400004 30.208436283000026, 105.94468299300007 30.208444256000064, 105.94473898500007 30.208514595000054, 105.94471426300004 30.208536778000052, 105.94468976300004 30.20856082100005, 105.94467069500007 30.20857826100007, 105.94466392300006 30.208588452000072, 105.94466749500003 30.208602746000054, 105.94468909600005 30.208634809000046, 105.94472307300003 30.208667976000072, 105.94472867700006 30.20867927200004, 105.94472673000007 30.20869121800007, 105.94471519500007 30.20870621800003, 105.94469878900009 30.208714689000033, 105.94465363600006 30.208734107000055, 105.94460429100008 30.208751670000026, 105.94452562200007 30.20872588800006, 105.94444317700004 30.208573458000046, 105.94431278400003 30.20861430700006, 105.94431182700004 30.208656650000023, 105.94431713800009 30.208687931000043, 105.94432551700004 30.208721765000064, 105.94433449100006 30.208750201000043, 105.94435734200005 30.208782420000034, 105.94437853100004 30.20880726100006, 105.94439254200006 30.208816975000047, 105.94443535100004 30.208836296000072, 105.94450580300008 30.208877878000067, 105.94451384000007 30.208888417000026, 105.94451824500004 30.208902161000026, 105.94451894600007 30.20891169300006, 105.94451489800008 30.208930447000057, 105.94454630700005 30.20893336300003, 105.94457769000007 30.208937417000072, 105.94459906500003 30.208944014000053, 105.94462324900007 30.20896076300005, 105.94464086500005 30.20897391400007, 105.94464695600004 30.20898169000003, 105.94465038500005 30.208989100000053, 105.94464961000006 30.208993603000067, 105.94464370100007 30.209007506000034, 105.94461195400004 30.209035518000064, 105.94460238400006 30.209050968000042, 105.94459964300006 30.20906339100003, 105.94460687800006 30.209102534000067, 105.94463477000005 30.20915004400007, 105.94468209900003 30.209196445000032, 105.94470577100009 30.209234388000027, 105.94474423200006 30.209317846000033, 105.94477873200009 30.209435041000063, 105.94481848600009 30.20952553400008, 105.94486320300007 30.209595595000053, 105.94489773800007 30.209644472000036, 105.94491074200005 30.209687646000077, 105.94491110700005 30.209725853000066, 105.94491663300005 30.20975328000003, 105.94493880200008 30.209769497000025, 105.94495629100004 30.209788547000073, 105.94499578600005 30.20991708200006, 105.94499492000006 30.209936192000043, 105.94496284100006 30.21004263800006, 105.94494462900008 30.21010706000004, 105.94491056100009 30.21016189000005, 105.94487120400004 30.210216471000024, 105.94485113300004 30.210255279000023, 105.94483832300006 30.210289901000067, 105.94481558200005 30.21033284300006, 105.94476983900006 30.210391505000075, 105.94472159700007 30.21042296400003, 105.94466657600009 30.21044863700007, 105.94463905700007 30.21046453400004, 105.94462130900007 30.210486847000027, 105.94461042300009 30.21051998100006, 105.94461908700004 30.210568742000078, 105.94462169900004 30.210607611000057, 105.94462287100004 30.210655029000065, 105.94462011300004 30.21067903100004, 105.94462180500005 30.21069975900008, 105.94463245800006 30.210720422000065, 105.94467613000006 30.210757700000045, 105.94472338800006 30.210779397000067, 105.94479520500005 30.210883392000028, 105.94481197000005 30.210938601000066, 105.94481517100007 30.210968897000043, 105.94480689700003 30.211023187000023, 105.94478705200004 30.211114124000062, 105.94477866600005 30.21114153600007, 105.94476894200005 30.21115823200006, 105.94475668500007 30.21116850900006, 105.94474504300007 30.211174777000053, 105.94476566600008 30.211216894000074, 105.94477928600008 30.21128118200005, 105.94478983600004 30.211305536000054, 105.94483111400007 30.211337403000073, 105.94484229300008 30.211325310000063, 105.94489954300008 30.211285579000048, 105.94493917500006 30.211264938000056, 105.94495920900005 30.211251168000047, 105.94497630200004 30.21123592400005, 105.94499133200009 30.211216827000044, 105.94499862200007 30.211202048000075, 105.94500572600003 30.21116515600005, 105.94500158700004 30.211088562000043, 105.94500194300008 30.21101366700003, 105.94501384300008 30.210925815000053, 105.94503053900007 30.21086357300004, 105.94504487600005 30.210826918000066, 105.94506297400005 30.210792351000066, 105.94508531600007 30.210760882000045, 105.94511237600005 30.210733504000075, 105.94514399700006 30.21071031100007, 105.94517910100006 30.210690082000042, 105.94529382200005 30.21063391900003, 105.94534067000006 30.21060620600008, 105.94536657800006 30.21058710400007, 105.94539757600006 30.210558199000047, 105.94541080200008 30.210542463000024, 105.94543132000007 30.21050866300004, 105.94543805800004 30.21049068800005, 105.94544311200008 30.210459138000033, 105.94544102600008 30.210433227000067, 105.94542824400008 30.210395009000024, 105.94540518200006 30.21036175300003, 105.94538241200007 30.210342936000075, 105.94535466300005 30.21032998000004, 105.94524900700009 30.210306761000027, 105.94520864600008 30.210291519000066, 105.94518969600006 30.210279510000078, 105.94517327800008 30.21026518900004, 105.94515963900005 30.210248802000024, 105.94514948500006 30.21023083700004, 105.94514351600009 30.210211784000023, 105.94514243800006 30.210192129000063, 105.94514478900004 30.210178917000064, 105.94515690200006 30.21015368700006, 105.94517903800005 30.210132513000076, 105.94518825000006 30.210128202000078, 105.94520553600006 30.210125885000025, 105.94522432900004 30.210129771000027, 105.94524375100008 30.210138507000067, 105.94528299700005 30.21016383600005), (105.94382399000006 30.20845922500007, 105.94363123100004 30.20859838900003, 105.94355736700004 30.208531890000074, 105.94348246700008 30.208466128000055, 105.94363223500005 30.208371210000053, 105.94368145400006 30.208401752000043, 105.94372179100009 30.20838714200005, 105.94375810700006 30.20837104800006, 105.94382399000006 30.20845922500007))";
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(wkt);
        Envelope envelopeInternal = geometry.getEnvelopeInternal();
        double maxX = envelopeInternal.getMaxX();
        double minX = envelopeInternal.getMinX();
        double maxY = envelopeInternal.getMaxY();
        double minY = envelopeInternal.getMinY();
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SimpleFeatureSource grid = Grids.createSquareGrid((ReferencedEnvelope)gridBounds, (double)sideLen);
        LinkedList<String> gridList = new LinkedList<String>();
        SimpleFeatureIterator iterator = grid.getFeatures().features();
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            Object defaultGeometry = feature.getDefaultGeometry();
            gridList.add(defaultGeometry.toString());
            System.err.println(defaultGeometry.toString());
        }
        gridList.add(wkt);
        System.out.println(wkt);
        System.out.println(gridList.size());
    }

    public static void main(String[] args) throws Exception {
        double lng = 107.251922404845;
        double lat = 30.246895813978;
        double radius = 105.74;
        String wkt = GeoTool.CreateSimpleCircleWKT(lng, lat, radius, 360);
        GeoTool.testGrid();
    }
}

