/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.flylib.util;

import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GeoUtils {
    private static final GeometryFactory geometryFactory = new GeometryFactory();
    private static final CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);

    public static Geometry wktToGeo(String wkt) {
        WKTReader reader = new WKTReader();
        try {
            return reader.read(wkt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Geometry toPlane(Geometry geometry, int planeSrid) {
        return GeoUtils.sridTransForm(geometry, 4490, planeSrid);
    }

    public static Geometry fromPlane(Geometry geometry, int planeSrid) {
        return GeoUtils.sridTransForm(geometry, planeSrid, 4490);
    }

    public static Geometry toPlane(Geometry geometry) {
        int planeSrid = GeoUtils.getPlaneSrid(geometry.getCentroid().getX());
        return GeoUtils.sridTransForm(geometry, 4490, planeSrid);
    }

    public static Geometry sridTransForm(Geometry geometry, int fromSrid, int toSrid) {
        try {
            CoordinateReferenceSystem source = factory.createCoordinateReferenceSystem("EPSG:" + fromSrid);
            CoordinateReferenceSystem target = factory.createCoordinateReferenceSystem("EPSG:" + toSrid);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
            return JTS.transform((Geometry)geometry, (MathTransform)transform);
        }
        catch (Exception e) {
            throw new RuntimeException("EPSG:" + fromSrid + "\u8f6c\u6362\u5750\u6807\u7cfb\u4e3aEPSG:" + toSrid + " \u8f6c\u6362\u5f02\u5e38 : " + e.getMessage());
        }
    }

    public static int getPlaneSrid(double lon) {
        int planeSrid = (int)Math.floor((lon + 1.5) / 3.0) - 25 + 4513;
        if (planeSrid < 3857 || planeSrid > 4538) {
            planeSrid = 3857;
        }
        return planeSrid;
    }

    public static Point createPoint(Double lon, Double lat) {
        Coordinate coordinate = new Coordinate();
        coordinate.x = lon;
        coordinate.y = lat;
        return geometryFactory.createPoint(coordinate);
    }

    public static Polygon createPolygon(Coordinate ... coordinates) {
        return geometryFactory.createPolygon(coordinates);
    }

    public static LineString createLine(Coordinate ... coordinates) {
        return geometryFactory.createLineString(coordinates);
    }

    public static double pointLength(Point a, Point b) {
        return GeoUtils.createLine(a.getCoordinate(), b.getCoordinate()).getLength();
    }

    public static double degree(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        if (y == 0.0 && x > 0.0) {
            return 0.0;
        }
        if (y == 0.0 && x < 0.0) {
            return Math.PI;
        }
        if (x == 0.0 && y > 0.0) {
            return 1.5707963267948966;
        }
        if (x == 0.0 && y < 0.0) {
            return 4.71238898038469;
        }
        if (x > 0.0 && y > 0.0) {
            return Math.atan(y / x);
        }
        if (x < 0.0 && y > 0.0) {
            return Math.PI - Math.atan(y / -x);
        }
        if (x < 0.0 && y < 0.0) {
            return Math.PI + Math.atan(-y / -x);
        }
        if (x > 0.0 && y < 0.0) {
            return Math.PI * 2 - Math.atan(-y / x);
        }
        return 0.0;
    }

    public static Point rotatePoint(Point A, Point P, double degree, boolean isClockwise) {
        Point a = GeoUtils.createPoint(A.getX() - P.getX(), A.getY() - P.getY());
        double radius = GeoUtils.pointLength(a, GeoUtils.createPoint(0.0, 0.0));
        double degreeWithX = GeoUtils.degree(a.getX(), a.getY());
        double degreeAfterRotateWithX = degreeWithX - (double)(isClockwise ? 1 : -1) * degree;
        Point b = GeoUtils.createPoint(radius * Math.cos(degreeAfterRotateWithX), radius * Math.sin(degreeAfterRotateWithX));
        return GeoUtils.createPoint(b.getX() + P.getX(), b.getY() + P.getY());
    }

    public static Geometry rotateGeometry(Geometry a, Point c, double degree, boolean isClockwise) {
        Coordinate[] coordinates;
        for (Coordinate coordinate : coordinates = a.getCoordinates()) {
            Point point = GeoUtils.rotatePoint(GeoUtils.createPoint(coordinate.x, coordinate.y), c, degree, isClockwise);
            coordinate.setX(point.getX());
            coordinate.setY(point.getY());
        }
        return a;
    }

    public static double angle(Coordinate coordinate0, Coordinate coordinate1) {
        Point point0 = geometryFactory.createPoint(coordinate0);
        Point point1 = geometryFactory.createPoint(coordinate1);
        int planeSrid = GeoUtils.getPlaneSrid(point0.getX());
        Point point0Plane = (Point)GeoUtils.toPlane((Geometry)point0, planeSrid);
        Point point1Plane = (Point)GeoUtils.toPlane((Geometry)point1, planeSrid);
        return Angle.angle((Coordinate)point0Plane.getCoordinate(), (Coordinate)point1Plane.getCoordinate());
    }

    public static double orientation(Coordinate coordinate0, Coordinate coordinate1) {
        double degrees = Math.toDegrees(GeoUtils.angle(coordinate0, coordinate1));
        if ((degrees = 90.0 - degrees) > 180.0) {
            degrees -= 360.0;
        }
        return degrees;
    }

    public static double distance(Coordinate coordinate0, Coordinate coordinate1) {
        Point point0 = geometryFactory.createPoint(coordinate0);
        Point point1 = geometryFactory.createPoint(coordinate1);
        int planeSrid = GeoUtils.getPlaneSrid(point0.getX());
        Point point0Plane = (Point)GeoUtils.toPlane((Geometry)point0, planeSrid);
        Point point1Plane = (Point)GeoUtils.toPlane((Geometry)point1, planeSrid);
        return point0Plane.getCoordinate().distance(point1Plane.getCoordinate());
    }
}

