/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.log.entity;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="osd_data")
public class EsDevOsd {
    @Id
    @Field(type=FieldType.Keyword)
    private String id;
    @Field(type=FieldType.Keyword)
    private String sn;
    @Field(type=FieldType.Keyword)
    private String gateway;
    @Field(type=FieldType.Object, dynamic=Dynamic.TRUE)
    private Object payload;
    @Field(type=FieldType.Date, format={DateFormat.date_hour_minute_second, DateFormat.epoch_millis})
    private Date timestamp;

    public Map<String, Object> convertTrackDto() {
        if (ObjectUtil.isNotEmpty((Object)this.payload)) {
            JSONObject json = new JSONObject(this.payload);
            String payloadIndex = (String)json.getByPath("data.cameras[0].payload_index", String.class);
            HashMap<String, Object> track = new HashMap<String, Object>();
            track.put("timestamp", this.timestamp);
            track.put("lat", json.getByPath("data.latitude"));
            track.put("lng", json.getByPath("data.longitude"));
            track.put("rth", json.getByPath("data.elevation"));
            track.put("elevation", json.getByPath("data.height"));
            track.put("attitudeHead", json.getByPath("data.attitude_head"));
            track.put("attitudePitch", json.getByPath("data.attitude_pitch"));
            track.put("attitudeRoll", json.getByPath("data.attitude_roll"));
            track.put("gimbalPitch", json.getByPath("data." + payloadIndex + ".gimbal_pitch"));
            track.put("zoomFactor", json.getByPath("data." + payloadIndex + ".zoom_factor"));
            track.put("gimbalRoll", json.getByPath("data." + payloadIndex + ".gimbal_roll"));
            track.put("gimbalYaw", json.getByPath("data." + payloadIndex + ".gimbal_yaw"));
            return track;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getSn() {
        return this.sn;
    }

    public String getGateway() {
        return this.gateway;
    }

    public Object getPayload() {
        return this.payload;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsDevOsd)) {
            return false;
        }
        EsDevOsd other = (EsDevOsd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsDevOsd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "EsDevOsd(id=" + this.getId() + ", sn=" + this.getSn() + ", gateway=" + this.getGateway() + ", payload=" + this.getPayload() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

