/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.robot.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.robot.data.WxMessageBase;
import com.geoway.fczx.robot.data.WxMessagePerson;
import com.geoway.fczx.robot.data.property.SmsProperties;
import com.geoway.landteam.hb.sms4j.sdk.Hbsms4jService;
import com.sms.service.sdk.config.SMSConfig;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxRobotTool {
    private static final Logger log = LoggerFactory.getLogger(WxRobotTool.class);

    public static void sendMessage(WxMessageBase message, List<String> user) {
        HttpRequest post = HttpUtil.createPost((String)message.getServer());
        post.header("Content-Type", "application/json");
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.putOnce("content", (Object)message.getContent());
        if (ObjectUtil.isNotEmpty(user)) {
            jsonObject.putOnce("mentioned_mobile_list", user);
        }
        if (ObjectUtil.equal((Object)message.getType(), (Object)"markdown")) {
            params.put("markdown", jsonObject);
        } else {
            params.put("text", jsonObject);
        }
        params.put("msgtype", message.getType());
        post.body(JSONUtil.toJsonStr(params));
        HttpResponse response = post.execute();
        Assert.state((200 == response.getStatus() ? 1 : 0) != 0, (String)"\u53d1\u9001\u6587\u6863\u6d88\u606f\u5931\u8d25", (Object[])new Object[0]);
    }

    public static boolean sendSMSMessage(SmsProperties properties, WxMessagePerson message) {
        try {
            new Hbsms4jService((SMSConfig)properties).sendMsg(message.getContent(), String.join((CharSequence)",", message.getPhones()));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
        return true;
    }
}

