CREATE TABLE IF NOT EXISTS "device_flight_area"
(
    "id"           serial primary key,
    "device_sn"    varchar(64) NOT NULL,
    "workspace_id" varchar(64) NOT NULL,
    "file_id"      varchar(64) NOT NULL,
    "sync_status"  varchar(32) NOT NULL,
    "sync_code"    int         NOT NULL DEFAULT '0',
    "create_time"  bigint      NOT NULL,
    "update_time"  bigint      NOT NULL
);

CREATE TABLE IF NOT EXISTS "flight_area_file"
(
    "id"           serial primary key,
    "file_id"      varchar(64)   NOT NULL,
    "workspace_id" varchar(64)   NOT NULL,
    "name"         varchar(100)  NOT NULL,
    "object_key"   varchar(1000) NOT NULL,
    "sign"         varchar(64)   NOT NULL,
    "size"         int           NOT NULL,
    "latest"       boolean       NOT NULL,
    "create_time"  bigint        NOT NULL,
    "update_time"  bigint        NOT NULL
);

CREATE TABLE IF NOT EXISTS "flight_area_property"
(
    "id"         serial primary key,
    "element_id" varchar(64) NOT NULL,
    "type"       varchar(32) NOT NULL,
    "enable"     boolean     NOT NULL,
    "sub_type"   varchar(32)          DEFAULT NULL,
    "radius"     int         NOT NULL DEFAULT '0'
);

CREATE TABLE IF NOT EXISTS "logs_file"
(
    "id"          serial primary key,
    "file_id"     varchar(45)   NOT NULL DEFAULT '',
    "name"        varchar(100)  NOT NULL DEFAULT '',
    "size"        bigint        NOT NULL DEFAULT '0',
    "logs_id"     varchar(45)   NOT NULL DEFAULT '',
    "device_sn"   varchar(45)   NOT NULL DEFAULT '',
    "fingerprint" varchar(64)   NOT NULL DEFAULT '',
    "object_key"  varchar(1000) NOT NULL DEFAULT '',
    "status"      boolean       NOT NULL,
    "create_time" bigint        NOT NULL,
    "update_time" bigint        NOT NULL
);

CREATE TABLE IF NOT EXISTS "logs_file_index"
(
    "id"          serial primary key,
    "boot_index"  int         NOT NULL,
    "file_id"     varchar(64) NOT NULL DEFAULT '',
    "start_time"  bigint      NOT NULL,
    "end_time"    bigint      NOT NULL,
    "size"        bigint      NOT NULL,
    "device_sn"   varchar(64) NOT NULL DEFAULT '',
    "domain"      int         NOT NULL,
    "create_time" bigint      NOT NULL,
    "update_time" bigint      NOT NULL
);

CREATE TABLE IF NOT EXISTS "manage_device"
(
    "id"                serial primary key,
    "device_sn"         varchar(32) NOT NULL DEFAULT '',
    "device_name"       varchar(64)          DEFAULT 'undefined',
    "user_id"           varchar(64)          DEFAULT '',
    "nickname"          varchar(64),
    "workspace_id"      varchar(64)          DEFAULT '',
    "device_type"       int                  DEFAULT '-1',
    "sub_type"          int                  DEFAULT '-1',
    "domain"            int                  DEFAULT '-1',
    "firmware_version"  varchar(32)          DEFAULT '',
    "compatible_status" boolean     NOT NULL DEFAULT true,
    "fly_status"        boolean     NOT NULL DEFAULT false,
    "version"           varchar(32)          DEFAULT '',
    "device_index"      varchar(32)          DEFAULT '',
    "child_sn"          varchar(32)          DEFAULT '',
    "create_time"       bigint      NOT NULL,
    "update_time"       bigint      NOT NULL,
    "bound_time"        bigint               DEFAULT NULL,
    "bound_status"      boolean     NOT NULL DEFAULT false,
    "login_time"        bigint               DEFAULT NULL,
    "device_desc"       varchar(100)         DEFAULT '',
    "url_normal"        varchar(200)         DEFAULT '',
    "url_select"        varchar(200)         DEFAULT ''
);

CREATE TABLE IF NOT EXISTS "manage_device_firmware"
(
    "id"               serial primary key,
    "firmware_id"      varchar(45)   NOT NULL DEFAULT '',
    "file_name"        varchar(64)   NOT NULL DEFAULT 'undefined',
    "firmware_version" varchar(45)   NOT NULL DEFAULT '',
    "object_key"       varchar(200)  NOT NULL,
    "file_size"        bigint        NOT NULL,
    "file_md5"         varchar(45)   NOT NULL DEFAULT '',
    "workspace_id"     varchar(64)   NOT NULL,
    "release_note"     varchar(1000) NOT NULL DEFAULT '',
    "release_date"     bigint        NOT NULL,
    "user_name"        varchar(64)   NOT NULL,
    "status"           boolean       NOT NULL DEFAULT false,
    "create_time"      bigint        NOT NULL,
    "update_time"      bigint        NOT NULL
);

CREATE TABLE IF NOT EXISTS "manage_device_hms"
(
    "id"          serial primary key,
    "hms_id"      varchar(45)  NOT NULL DEFAULT '',
    "tid"         varchar(45)  NOT NULL DEFAULT '',
    "bid"         varchar(45)  NOT NULL DEFAULT '',
    "sn"          varchar(45)  NOT NULL DEFAULT '',
    "level"       smallint     NOT NULL,
    "module"      int          NOT NULL,
    "hms_key"     varchar(64)  NOT NULL DEFAULT '',
    "message_zh"  varchar(100) NOT NULL DEFAULT '',
    "message_en"  varchar(300) NOT NULL DEFAULT '',
    "create_time" bigint       NOT NULL,
    "update_time" bigint       NOT NULL
);

CREATE TABLE IF NOT EXISTS "manage_device_logs"
(
    "id"          serial primary key,
    "logs_id"     varchar(45)   NOT NULL DEFAULT '',
    "username"    varchar(100)  NOT NULL DEFAULT '',
    "device_sn"   varchar(45)   NOT NULL DEFAULT '',
    "logs_info"   varchar(1000) NOT NULL DEFAULT '',
    "happen_time" bigint                 DEFAULT NULL,
    "status"      int           NOT NULL,
    "update_time" bigint        NOT NULL,
    "create_time" bigint        NOT NULL
);

CREATE TABLE IF NOT EXISTS "manage_device_payload"
(
    "id"               serial primary key,
    "payload_sn"       varchar(32) NOT NULL DEFAULT '',
    "payload_name"     varchar(64) NOT NULL DEFAULT 'undefined',
    "payload_type"     smallint    NOT NULL,
    "sub_type"         smallint    NOT NULL,
    "firmware_version" varchar(32)          DEFAULT NULL,
    "payload_index"    smallint    NOT NULL,
    "device_sn"        varchar(32) NOT NULL DEFAULT '',
    "payload_desc"     varchar(100)         DEFAULT NULL,
    "control_source"   varchar(1)           DEFAULT NULL,
    "create_time"      bigint      NOT NULL,
    "update_time"      bigint      NOT NULL
);
CREATE TABLE IF NOT EXISTS "manage_firmware_model"
(
    "id"          serial primary key,
    "firmware_id" varchar(64) NOT NULL,
    "device_name" varchar(64) NOT NULL,
    "create_time" bigint      NOT NULL,
    "update_time" bigint      NOT NULL
);

CREATE TABLE IF NOT EXISTS "map_element_coordinate"
(
    "id"         serial primary key,
    "element_id" varchar(64)     NOT NULL DEFAULT '',
    "longitude"  decimal(18, 14) NOT NULL,
    "latitude"   decimal(17, 14) NOT NULL,
    "altitude"   decimal(17, 14)          DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS "map_group"
(
    "id"             serial primary key,
    "group_id"       varchar(64) NOT NULL DEFAULT '',
    "group_name"     varchar(64) NOT NULL DEFAULT '',
    "group_type"     int         NOT NULL,
    "workspace_id"   varchar(64) NOT NULL DEFAULT '',
    "is_distributed" boolean     NOT NULL DEFAULT true,
    "is_lock"        boolean     NOT NULL DEFAULT false,
    "create_time"    bigint      NOT NULL,
    "update_time"    bigint      NOT NULL
);


CREATE TABLE IF NOT EXISTS "map_group_element"
(
    "id"              serial primary key,
    "element_id"      varchar(64) NOT NULL DEFAULT '',
    "element_name"    varchar(64) NOT NULL DEFAULT '',
    "display"         smallint    NOT NULL DEFAULT '1',
    "group_id"        varchar(64) NOT NULL DEFAULT '',
    "element_type"    smallint    NOT NULL,
    "username"        varchar(64) NOT NULL DEFAULT '',
    "color"           varchar(32) NOT NULL DEFAULT '',
    "clamp_to_ground" boolean     NOT NULL DEFAULT false,
    "create_time"     bigint      NOT NULL,
    "update_time"     bigint      NOT NULL
);

CREATE TABLE IF NOT EXISTS "media_file"
(
    "id"                serial primary key,
    "file_id"           varchar(64)   NOT NULL DEFAULT '',
    "file_name"         varchar(100)  NOT NULL DEFAULT '',
    "file_path"         varchar(1000) NOT NULL DEFAULT '',
    "workspace_id"      varchar(64)   NOT NULL DEFAULT '',
    "fingerprint"       varchar(64)            DEFAULT '',
    "tinny_fingerprint" varchar(100)           DEFAULT '',
    "object_key"        varchar(1000) NOT NULL DEFAULT '',
    "sub_file_type"     int                    DEFAULT NULL,
    "is_original"       boolean,
    "drone"             varchar(32)   NOT NULL DEFAULT 'undefined',
    "payload"           varchar(32)   NOT NULL DEFAULT 'undefined',
    "job_id"            varchar(64)            DEFAULT '',
    "create_time"       bigint        NOT NULL,
    "update_time"       bigint        NOT NULL
);

CREATE TABLE IF NOT EXISTS "wayline_file"
(
    "id"                 serial primary key,
    "name"               varchar(64)  NOT NULL DEFAULT '',
    "wayline_id"         varchar(64)  NOT NULL DEFAULT '',
    "drone_model_key"    varchar(32)  NOT NULL DEFAULT '',
    "payload_model_keys" varchar(200)          DEFAULT NULL,
    "workspace_id"       varchar(64)  NOT NULL DEFAULT '',
    "sign"               varchar(64)  NOT NULL DEFAULT '',
    "favorited"          boolean      NOT NULL DEFAULT false,
    "template_types"     varchar(32)  NOT NULL DEFAULT '',
    "object_key"         varchar(200) NOT NULL DEFAULT '',
    "user_name"          varchar(64)  NOT NULL DEFAULT '',
    "create_time"        bigint       NOT NULL,
    "update_time"        bigint       NOT NULL
);

CREATE TABLE IF NOT EXISTS "wayline_job"
(
    "id"             serial primary key,
    "job_id"         varchar(45) NOT NULL DEFAULT '',
    "name"           varchar(64) NOT NULL DEFAULT '',
    "file_id"        varchar(45) NOT NULL DEFAULT '',
    "dock_sn"        varchar(45) NOT NULL DEFAULT '',
    "workspace_id"   varchar(45) NOT NULL DEFAULT '',
    "task_type"      int         NOT NULL,
    "wayline_type"   int         NOT NULL,
    "execute_time"   bigint               DEFAULT NULL,
    "completed_time" bigint               DEFAULT NULL,
    "username"       varchar(64) NOT NULL DEFAULT '',
    "begin_time"     bigint      NOT NULL,
    "end_time"       bigint               DEFAULT NULL,
    "error_code"     int                  DEFAULT NULL,
    "status"         int         NOT NULL,
    "rth_altitude"   int         NOT NULL,
    "rth_mode"       int,
    "out_of_control" int         NOT NULL,
    "media_count"    int         NOT NULL DEFAULT '0',
    "create_time"    bigint      NOT NULL,
    "update_time"    bigint      NOT NULL,
    "parent_id"      varchar(45)          DEFAULT NULL
);

ALTER TABLE IF EXISTS flight_area_file
    ADD CONSTRAINT file_id_uq UNIQUE (file_id);
ALTER TABLE IF EXISTS flight_area_property
    ADD CONSTRAINT element_id_uq UNIQUE (element_id);
ALTER TABLE IF EXISTS logs_file
    ADD CONSTRAINT log_file_id_uq UNIQUE (file_id);
ALTER TABLE IF EXISTS manage_device
    ADD CONSTRAINT device_sn_uq UNIQUE (device_sn);
ALTER TABLE IF EXISTS manage_device_firmware
    ADD CONSTRAINT firmware_id_uq UNIQUE (firmware_id);
ALTER TABLE IF EXISTS manage_device_hms
    ADD CONSTRAINT hms_id_uq UNIQUE (hms_id);
ALTER TABLE IF EXISTS manage_device_logs
    ADD CONSTRAINT logs_id_uq UNIQUE (logs_id);
ALTER TABLE IF EXISTS map_group
    ADD CONSTRAINT group_id_uq UNIQUE (group_id);
ALTER TABLE IF EXISTS map_group_element
    ADD CONSTRAINT o_element_id_uq UNIQUE (element_id);
ALTER TABLE IF EXISTS media_file
    ADD CONSTRAINT media_file_id_uq UNIQUE (file_id);
ALTER TABLE IF EXISTS wayline_file
    ADD CONSTRAINT wayline_id_uq UNIQUE (wayline_id);
ALTER TABLE IF EXISTS wayline_job
    ADD CONSTRAINT o_job_id_uq UNIQUE (job_id);

CREATE TABLE IF NOT EXISTS zx_wayline_job
(
    job_id      character varying(255) NOT NULL,
    wayline_id  character varying(255),
    tb_ids      character varying(255),
    create_time timestamp with time zone,
    finish_time timestamp with time zone,
    attachs     json,
    status      integer,
    photos      json,
    device      json,
    progress    json,
    wayline     json,
    CONSTRAINT zx_wayline_job_pkey PRIMARY KEY (job_id)
);

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN metadata json;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN radius double precision DEFAULT 5000;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN min_height double precision DEFAULT 150;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN max_height double precision DEFAULT 300;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN exe_height double precision DEFAULT 180;

CREATE TABLE IF NOT EXISTS zx_namespace
(
    namespace_id   character varying(64) NOT NULL,
    workspace_id   character varying(64),
    name           character varying(64),
    alias          character varying(64) NOT NULL,
    namespace_desc character varying(255),
    metadata       json,
    status         integer,
    deleted        integer,
    type           integer,
    start_time     timestamp with time zone,
    end_time       timestamp with time zone,
    create_time    timestamp with time zone,
    update_time    timestamp with time zone,
    PRIMARY KEY (namespace_id)
);

ALTER TABLE IF EXISTS zx_wayline_job
    ADD COLUMN namespace_id character varying(64);

CREATE TABLE zx_clue
(
    clue_id        varchar(32)                     NOT NULL,
    clue_no        text                            NULL,
    clue_source    varchar(32)                     NULL,
    clue_type      varchar(32)                     NULL,
    description    text                            NULL,
    tags           varchar(255)                    NULL,
    attachs        json                            NULL,
    tb_bsm         varchar(64)                     NULL,
    job_id         varchar(64)                     NULL,
    namespace_id   varchar(64)                     NULL,
    namespace_name varchar(255)                    NULL,
    status         integer                         NULL,
    create_time    timestamptz                     NULL,
    update_time    timestamptz                     NULL,
    review_segment varchar(1000)                   NULL,
    "location"     text                            NULL,
    discovery_time timestamp                       NULL,
    dock_sn        varchar(32)                     NULL,
    dock_name      varchar(64)                     NULL,
    job_name       varchar(64)                     NULL,
    region         varchar(64)                     NULL,
    region_code    varchar(64)                     NULL,
    metadata       json                            NULL,
    address        varchar(128)                    NULL,
    img            varchar(255)                    NULL,
    zldwdm         varchar(19)                     NULL,
    geom           public.geometry(geometry, 4490) NULL,
    PRIMARY KEY (clue_id)
);

ALTER TABLE zx_namespace
    ADD CONSTRAINT uq_ns_alias UNIQUE (alias);
ALTER TABLE zx_namespace
    ADD CONSTRAINT uq_ns_name UNIQUE (name);

CREATE TABLE IF NOT EXISTS zx_splice_job
(
    id             character varying(32),
    name           character varying(64),
    process_id     character varying(32),
    process_state  character varying(16),
    service        json,
    create_time    timestamp with time zone,
    update_time    timestamp with time zone,
    process_result character varying(255),
    PRIMARY KEY (id)
);

CREATE TABLE IF NOT EXISTS zx_splice_file
(
    splice_id  character varying(64)  NOT NULL,
    job_id     character varying(64),
    job_name   character varying(64),
    object_key character varying(255) NOT NULL,
    ns_id      character varying(64),
    ns_name    character varying(64)
);

CREATE TABLE IF NOT EXISTS zx_manual_track
(
    track_id    character varying(32) NOT NULL,
    flight_id   character varying(64) NOT NULL,
    device_sn   character varying(32) NOT NULL,
    lng         double precision,
    lat         double precision,
    elevation   double precision,
    rth         double precision,
    create_time timestamp with time zone,
    metadata    json,
    PRIMARY KEY (track_id)
);

CREATE TABLE IF NOT EXISTS zx_transaction
(
    tid character varying(64) NOT NULL,
    PRIMARY KEY (tid)
);

CREATE TABLE IF NOT EXISTS zx_image_spot
(
    id           character varying(64) NOT NULL,
    job_id       character varying(64),
    namespace_id character varying(64),
    object_key   text,
    attach       json,
    tb_ids       text,
    create_time  timestamp with time zone,
    PRIMARY KEY (id)
);

ALTER TABLE IF EXISTS zx_image_spot
    ADD CONSTRAINT object_key_uq UNIQUE (object_key);

CREATE TABLE IF NOT EXISTS zx_job_video
(
    id         character varying(64) NOT NULL,
    job_id     character varying(64),
    name       character varying(100),
    video_size bigint,
    start_time timestamp with time zone,
    end_time   timestamp with time zone,
    PRIMARY KEY (id)
);

ALTER TABLE zx_wayline_job
    ALTER COLUMN tb_ids TYPE text;

ALTER TABLE IF EXISTS zx_wayline_job
    ADD COLUMN breakpoints json;

CREATE TABLE IF NOT EXISTS zx_system_config
(
    id          character varying(64),
    p_id        character varying(64),
    name        character varying(128),
    code        character varying(32),
    value       character varying(64),
    type        character varying(16),
    dict        json,
    create_time timestamp with time zone,
    update_time timestamp with time zone,
    PRIMARY KEY (id)
);

CREATE TABLE IF NOT EXISTS zx_xzj_xzq
(
    objectid serial primary key,
    xzqmc    character varying(50),
    xzqdm    character varying(50),
    maxx     double precision,
    minx     double precision,
    maxy     double precision,
    miny     double precision,
    level    int4,
    pid      character varying(50),
    geom     public.geometry(Geometry, 4490)
);

INSERT INTO zx_system_config (id, p_id, "name", code, "type", dict, create_time, update_time, value)
VALUES ('8c72a8dc1aaf4bf69844b1ffd133ab4c', NULL, '航线设置', 'waylineSetting', 'group', NULL,
        '2024-06-05 15:06:59.058', NULL, NULL),
       (gen_random_uuid(), '8c72a8dc1aaf4bf69844b1ffd133ab4c', '航线角度', 'routeAngleOfLine',
        'number', NULL, '2024-06-05 15:22:54.723', NULL, '0'),
       (gen_random_uuid(), '8c72a8dc1aaf4bf69844b1ffd133ab4c', '选中图斑个数', 'minTbNumOfLine',
        'number', NULL, '2024-06-05 15:15:20.840', NULL, '10'),
       (gen_random_uuid(), '8c72a8dc1aaf4bf69844b1ffd133ab4c', '选中图斑总面积', 'minAreaOfLine',
        'number', NULL, '2024-06-05 15:15:56.775', NULL, '1000'),
       (gen_random_uuid(), '8c72a8dc1aaf4bf69844b1ffd133ab4c', '面积和与外接矩形面积比',
        'minAreaRatioOfLine', 'number', NULL, '2024-06-05 15:17:03.885', NULL, '0.5');
INSERT INTO zx_system_config
    (id, p_id, "name", code, value, "type", dict, create_time, update_time)
VALUES ('d77b7793d51e4929972646556ce3bfaf', NULL, '个性化设置', 'personSetting', NULL, 'group', NULL,
        '2024-11-28 11:33:47.499', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '系统标题名称', 'appTitle', NULL,
        'text', NULL, '2024-11-28 11:35:18.382', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '系统初始层级', 'appInitialLevel', '16',
        'number', NULL, '2024-11-28 11:36:38.153', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '系统初始行政区', 'appInitialRegion',
        '唐山市', 'text', NULL, '2024-11-28 11:40:09.249', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '系统初始中心点', 'appInitialCenter',
        '120,30', 'text', NULL, '2024-11-28 11:37:13.493', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '企业微信推送地址', 'appWxPushUrl',
        NULL, 'text', NULL, '2024-11-28 11:42:06.985', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '线索报告标题', 'appClueReportTitleName',
        NULL, 'text', NULL, '2024-11-28 11:42:06.985', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '大疆司空2对应组织校验码', 'djiFlightHubOrgKey',
        NULL, 'text', NULL, '2024-11-28 11:42:06.985', NULL),
       (gen_random_uuid(), 'd77b7793d51e4929972646556ce3bfaf', '大疆司空2对应组织uuid', 'djiFlightHubOrgUuid',
        NULL, 'text', NULL, '2024-11-28 11:42:06.985', NULL);
