CREATE OR REPLACE FUNCTION merge_devices()
    RETURNS SETOF RECORD AS
$$
declare
    in_schemas TEXT[] := array(SELECT distinct table_schema
                               FROM information_schema.columns
                               WHERE table_name = 'manage_device');
    sql        TEXT   := '';
begin
    FOR i IN 1..array_length(in_schemas, 1)
        LOOP
            sql := sql ||
                   'SELECT device_sn,device_name,nickname,device_type,sub_type,domain,distribute_type,radius,child_sn,source,fly_status,' ||
                   'to_timestamp(bound_time / 1000) as bound_time, bound_status, to_timestamp(login_time / 1000) as login_time,workspace_id FROM ' ||
                   concat(quote_ident(in_schemas[i]), '.manage_device');
            IF i < array_length(in_schemas, 1) THEN
                sql := sql || ' ' || ' UNION ALL ';
            END IF;
        END LOOP;
    raise notice '%',sql;
    return QUERY EXECUTE sql;
END;
$$ LANGUAGE plpgsql;

create or replace view vw_devices as
select *
from merge_devices() as t(
                          device_sn character varying,
                          device_name character varying,
                          nickname character varying,
                          device_type integer,
                          sub_type integer,
                          domain integer,
                          distribute_type character varying,
                          radius double precision,
                          child_sn character varying,
                          source character varying,
                          fly_status boolean,
                          bound_time timestamp with time zone,
                          bound_status boolean,
                          login_time timestamp with time zone,
                          workspace_id character varying);