--自定义限飞区视图（简化查询sql）
create or replace view custom_limit_map_view as
with T1 as (select fap.element_id,
                   public.ST_Buffer(public.ST_MakePoint(mec.longitude, mec.latitude),
                                    (fap.radius * 180 / (6378137 * PI() * 100))) as geom
            from flight_area_property fap
                     left join map_element_coordinate mec on fap.element_id = mec.element_id
            where fap."type" = 'nfz'
              and fap.sub_type is not null),
     T2 as (with Q1 as (with points as ((select element_id, public.ST_MakePoint(longitude, latitude) as geom
                                         from map_element_coordinate
                                         order by id)
                                        union all
                                        (select pe.element_id, pe.geom
                                         from (select element_id,
                                                      public.ST_MakePoint(longitude, latitude)                as geom,
                                                      row_number() over (partition by element_id order by id) as group_idx
                                               from map_element_coordinate) pe
                                         where pe.group_idx = 1))
                        select row_number() over () as rownumber, fap.element_id, p.geom
                        from flight_area_property fap
                                 left join points p on
                            fap.element_id = p.element_id
                        where fap."type" = 'nfz'
                          and fap.sub_type is null)
            select element_id, public.ST_MakePolygon(public.ST_MakeLine(ARRAY_AGG(geom order by rownumber))) as geom
            from Q1
            group by element_id)
select *
from T1
union all
select *
from T2;