-- 新增航线告警表
CREATE TABLE zx_wayline_job_alert
(
    alert_id       varchar(255) NOT NULL,
    job_id         varchar(255) NOT NULL,
    job_Name       varchar(255) NOT NULL,
    alert_info     text         NOT NULL,
    alert_type     varchar(255) NOT NULL,
    status         int4         NOT NULL,
    create_time    timestamptz  NOT NULL,
    job_begin_time timestamptz  NOT NULL,
    job_end_time   timestamptz  NOT NULL,
    phone          text         NULL,
    message        text         NULL,
    CONSTRAINT zx_wayline_job_alert_pkey PRIMARY KEY (alert_id)
);

-- 告警表新增location字段
ALTER TABLE zx_wayline_job_alert
    ADD location varchar(255) NOT NULL;
-- 告警表新增dock字段
ALTER TABLE zx_wayline_job_alert
    ADD dock varchar(255) NULL;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN wind_threshold integer DEFAULT 12;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN rain_threshold integer DEFAULT 3;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN weather_block_status integer DEFAULT false;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN distribute_type varchar(16);

CREATE TABLE zx_analysis_job
(
    id            varchar(255) not null,
    "name"        varchar(255) NULL,
    "type"        integer      NULL,
    rebuild_ids   text         NULL,
    status        integer      NULL,
    model         varchar(4)   NULL,
    model_name    varchar(64)  NULL,
    err_code      varchar(16)  NULL,
    err_msg       varchar(255) NULL,
    process_id    varchar(64)  NULL,
    create_time   timestamp without time zone,
    start_time    timestamp without time zone,
    complete_time timestamp without time zone,
    service       json         NULL,
    metadata      json         NULL,
    CONSTRAINT zx_analysis_job_pkey PRIMARY KEY (id)
);

CREATE TABLE zx_wayline_group
(
    group_id    varchar(64) NOT NULL,
    group_name  varchar(64) NOT NULL,
    group_type  varchar(12) NOT NULL default '',
    create_time timestamp without time zone,
    update_time timestamp without time zone,
    "level"     integer     NOT NULL DEFAULT 1,
    parent_id   varchar(64) NULL,
    "oid"       integer     NULL,
    CONSTRAINT zx_wayline_group_pkey PRIMARY KEY (group_id)
);

ALTER TABLE IF EXISTS wayline_file
    ADD COLUMN group_id varchar(64) default 'default';

CREATE TABLE IF NOT EXISTS "unlock_file"
(
    "id"             serial primary key,
    "unlock_file_id" varchar(64)  NOT NULL DEFAULT '',
    "unlock_name"    varchar(64)  NOT NULL DEFAULT '',
    "device_sn"      varchar(32)  NOT NULL DEFAULT '',
    "object_key"     varchar(255) NOT NULL DEFAULT '',
    "shape"          text,
    "workspace_id"   varchar(64)  NOT NULL DEFAULT '',
    "sign"           varchar(64)  NOT NULL DEFAULT '',
    "status"         integer      NOT NULL DEFAULT 0,
    "uploaded_file"  bigint       NOT NULL,
    "expire_time"    bigint       NOT NULL
);