--  20250704 新增叠图任务表

CREATE TABLE public.zx_stack_job (
         id serial4 NOT NULL,
         "name" varchar(64) DEFAULT ''::character varying NOT NULL,
         job_id varchar(64) DEFAULT ''::character varying NOT NULL,
         status int2 NOT NULL,
         metadata json NULL,
         begin_time timestamptz NOT NULL,
         end_time timestamptz NULL,
         CONSTRAINT zx_stack_job_pkey PRIMARY KEY (id)
);

-- 叠图表新增飞行任务名称字段
ALTER TABLE public.zx_stack_job ADD job_name varchar NULL;


-- 新增叠图任务文件表
CREATE TABLE public.zx_stack_media_file (
        file_id serial4 NOT NULL,
        object_key varchar(1000) DEFAULT ''::character varying NOT NULL,
        file_name varchar(100) DEFAULT ''::character varying NOT NULL,
        file_path varchar(1000) DEFAULT ''::character varying NOT NULL,
        stack_job_id int4 NOT NULL,
        create_time timestamp NOT NULL,
        metadata json NULL,
        CONSTRAINT zx_stack_media_file_pkey PRIMARY KEY (file_id)
);

-- 媒体文件表job_id字段新增索引
CREATE INDEX media_file_job_id_idx ON public.media_file (job_id);